/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class TypeConversionRuleUtil {
    TypeConversionRuleUtil() {
    }

    static List<PsiVariable> getVariablesToMakeFinal(@NotNull PsiExpression expression) {
        ControlFlow controlFlow;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/rules/TypeConversionRuleUtil", "getVariablesToMakeFinal"));
        }
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)expression.getProject()).getControlFlow((PsiElement)expression, (ControlFlowPolicy)new MyControlFlowPolicy((PsiElement)expression), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        Collection writtenVariables = ControlFlowUtil.getWrittenVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize(), (boolean)false);
        if (!writtenVariables.isEmpty()) {
            return null;
        }
        return ControlFlowUtil.getUsedVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize()).stream().filter(v -> !v.hasModifierProperty("final")).collect(Collectors.toList());
    }

    private static class MyControlFlowPolicy
    implements ControlFlowPolicy {
        private final PsiElement myElement;

        public MyControlFlowPolicy(PsiElement element) {
            this.myElement = element;
        }

        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/refactoring/typeMigration/rules/TypeConversionRuleUtil$MyControlFlowPolicy", "getUsedVariable"));
            }
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if ((refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)this.myElement, (PsiElement)refElement, (boolean)true)) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/refactoring/typeMigration/rules/TypeConversionRuleUtil$MyControlFlowPolicy", "isParameterAccepted"));
            }
            return true;
        }

        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/TypeConversionRuleUtil$MyControlFlowPolicy", "isLocalVariableAccepted"));
            }
            return true;
        }
    }
}

