/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.beans;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSetting {
    public static final String PROCESS_EXPLICITLY_ANNOTATED = "process_explicitly_annotated";
    private String myName;
    private String myDescription;

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public abstract void setStringValue(@NotNull String var1);

    @Nullable
    public abstract String getStringValue();

    public abstract boolean isModified();

    public abstract void apply();

    public abstract void reset();

    protected CustomSetting(String name, String description) {
        this.myName = name;
        this.myDescription = description;
    }

    protected CustomSetting(Key<? extends CustomSetting> key, String description) {
        this.myName = key.toString();
        this.myDescription = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSetting setting = (CustomSetting)o;
        return this.myName.equals(setting.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public static class BOOLEAN
    extends CustomSetting {
        private Boolean myValue;
        private boolean myDefaultValue;
        private boolean myModified;

        public BOOLEAN(@NotNull String name, @NotNull String description, boolean defaultValue) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/beans/CustomSetting$BOOLEAN", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/spring/facet/beans/CustomSetting$BOOLEAN", "<init>"));
            }
            super(name, description);
            this.myValue = null;
            this.myDefaultValue = defaultValue;
        }

        public BOOLEAN(Key<BOOLEAN> key, String description, boolean defaultValue) {
            super(key, description);
            this.myValue = null;
            this.myDefaultValue = defaultValue;
        }

        public void setBooleanValue(boolean value) {
            boolean currentValue = this.getBooleanValue();
            if (value != currentValue) {
                this.myModified = true;
                this.myValue = value;
            }
        }

        public boolean getBooleanValue() {
            return this.myModified || this.myValue == null ? this.myDefaultValue : this.myValue;
        }

        @Nullable
        public Boolean getValue() {
            return this.myValue;
        }

        public boolean getDefaultValue() {
            return this.myDefaultValue;
        }

        @Override
        public void setStringValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/facet/beans/CustomSetting$BOOLEAN", "setStringValue"));
            }
            this.setBooleanValue(Boolean.valueOf(value));
        }

        @Override
        @Nullable
        public String getStringValue() {
            return this.myValue == null ? null : Boolean.toString(this.myValue);
        }

        @Override
        public void apply() {
            this.myModified = false;
        }

        @Override
        public void reset() {
            if (this.myModified) {
                this.myValue = null;
            }
            this.myModified = false;
        }

        @Override
        public boolean isModified() {
            return this.myModified;
        }
    }

    public static class STRING
    extends CustomSetting {
        private String myValue;
        private String myDefaultValue;
        private boolean myModified;

        public STRING(String name, String description, String defaultValue) {
            super(name, description);
            this.myDefaultValue = defaultValue;
        }

        public STRING(Key<STRING> key, String description, String defaultValue) {
            super(key, description);
            this.myDefaultValue = defaultValue;
        }

        public void clear() {
            this.myValue = null;
        }

        @NotNull
        public String getDefaultValue() {
            String string = this.myDefaultValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/beans/CustomSetting$STRING", "getDefaultValue"));
            }
            return string;
        }

        @Override
        public void setStringValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/facet/beans/CustomSetting$STRING", "setStringValue"));
            }
            if (!value.equals(this.myValue)) {
                this.myValue = value;
                this.myModified = true;
            }
        }

        @Override
        @Nullable
        public String getStringValue() {
            return this.myValue;
        }

        @Override
        public boolean isModified() {
            return this.myModified;
        }

        @Override
        public void apply() {
            this.myModified = false;
        }

        @Override
        public void reset() {
            if (this.myModified) {
                this.myValue = null;
            }
            this.myModified = false;
        }
    }
}

