/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.spring.SpringApiBundle;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternFileReferenceSet
extends FileReferenceSet {
    private final String myTemplateName;

    public PatternFileReferenceSet(String str, @NotNull PsiElement element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/PatternFileReferenceSet", "<init>"));
        }
        this(str, element, offset, true);
    }

    public PatternFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int offset, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/spring/model/converters/PatternFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/PatternFileReferenceSet", "<init>"));
        }
        this(str, element, offset, endingSlashNotAllowed, null);
    }

    public PatternFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int offset, boolean endingSlashNotAllowed, @Nullable String templateName) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/spring/model/converters/PatternFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/PatternFileReferenceSet", "<init>"));
        }
        super(str, element, offset, null, true, endingSlashNotAllowed, null, false);
        this.myTemplateName = templateName;
        this.reparse();
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        if (!PatternFileReferenceSet.isAntPattern(text)) {
            return new FileReference(this, range, index, text){

                @Nullable
                public String getNewFileTemplateName() {
                    return PatternFileReferenceSet.this.myTemplateName;
                }
            };
        }
        return new PatternFileReference(this, range, index, text, (Condition<PsiFileSystemItem>)this.getReferenceCompletionFilter());
    }

    public static boolean isAntPattern(String str) {
        return str.indexOf(42) != -1 || str.indexOf(63) != -1;
    }

    protected boolean isSoft() {
        return true;
    }

    public static class PatternFileReference
    extends FileReference {
        private final Condition<PsiFileSystemItem> myFilter;

        public PatternFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text, Condition<PsiFileSystemItem> filter) {
            super(referenceSet, range, index, text);
            this.myFilter = filter;
        }

        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference", "innerResolveInContext"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference", "innerResolveInContext"));
            }
            if (text.equals("**")) {
                PatternFileReference.addDirectoryResolves((PsiElement)context, result);
            } else {
                PsiElement[] psiElements;
                String patternText = FileUtil.convertAntToRegexp((String)text);
                Pattern pattern = Pattern.compile(patternText);
                for (PsiElement psiElement : psiElements = context.getChildren()) {
                    boolean acceptFile;
                    PsiFileSystemItem psiFileSystemItem;
                    if (!(psiElement instanceof PsiFileSystemItem) || !pattern.matcher((psiFileSystemItem = (PsiFileSystemItem)psiElement).getName()).matches()) continue;
                    boolean bl = acceptFile = psiFileSystemItem.isDirectory() || this.myFilter.value((Object)PatternFileReference.getOriginalFile((PsiFileSystemItem)psiFileSystemItem));
                    if (!acceptFile) continue;
                    result.add((ResolveResult)new PsiElementResolveResult(psiElement));
                }
            }
        }

        private static void addDirectoryResolves(PsiElement context, final Collection<ResolveResult> result) {
            if (!(context instanceof PsiFileSystemItem)) {
                return;
            }
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)context;
            if (fileSystemItem.isDirectory()) {
                result.add((ResolveResult)new PsiElementResolveResult(context));
                fileSystemItem.processChildren((PsiElementProcessor)new PsiFileSystemItemProcessor(){

                    public boolean acceptItem(String name, boolean isDirectory) {
                        return isDirectory;
                    }

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference$1", "execute"));
                        }
                        VirtualFile virtualFile = element.getVirtualFile();
                        if (virtualFile != null) {
                            PatternFileReference.addDirectoryResolves((PsiElement)element.getManager().findDirectory(virtualFile), result);
                        }
                        return true;
                    }
                });
            }
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = SpringApiBundle.message("pattern.fileset.no.matching.files", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

