/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModelSearchers {
    @NotNull
    public static List<SpringBeanPointer> findBeans(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringModelSearchers", "findBeans"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/SpringModelSearchers", "findBeans"));
        }
        if (!parameters.canSearch()) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelSearchers", "findBeans"));
            }
            return list;
        }
        SmartList beans = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)beans);
        model.processByClass(parameters, (Processor<SpringBeanPointer>)processor);
        SmartList smartList = beans;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringModelSearchers", "findBeans"));
        }
        return smartList;
    }

    @Nullable
    public static SpringBeanPointer findBean(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringModelSearchers", "findBean"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/utils/SpringModelSearchers", "findBean"));
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        model.processByName(SpringModelSearchParameters.byName(beanName), (Processor<SpringBeanPointer>)findFirstProcessor);
        return (SpringBeanPointer)findFirstProcessor.getFoundValue();
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringModelSearchers", "doesBeanExist"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/SpringModelSearchers", "doesBeanExist"));
        }
        return SpringModelSearchers.containsBean(model, parameters);
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull PsiClass beanClass) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringModelSearchers", "doesBeanExist"));
        }
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/utils/SpringModelSearchers", "doesBeanExist"));
        }
        return SpringModelSearchers.containsBean(model, SpringModelSearchParameters.byClass(beanClass).withInheritors().effectiveBeanTypes());
    }

    private static boolean containsBean(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringModelSearchers", "containsBean"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/SpringModelSearchers", "containsBean"));
        }
        if (!parameters.canSearch()) {
            return false;
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        model.processByClass(parameters, (Processor<SpringBeanPointer>)findFirstProcessor);
        return findFirstProcessor.isFound();
    }
}

