/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.IdeaSubversionConfigurationDirectory;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.SvnServerFileManagerImpl;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationProvider;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

@State(name="SvnConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SvnConfiguration
implements PersistentStateComponent<SvnConfigurationState> {
    public static final int ourMaxAnnotateRevisionsDefault = 500;
    private static final long UPGRADE_TO_15_VERSION_ASKED = 123L;
    private static final long CHANGELIST_SUPPORT = 124L;
    private static final long UPGRADE_TO_16_VERSION_ASKED = 125L;
    private final Project myProject;
    @NotNull
    private SvnConfigurationState myState = new SvnConfigurationState();
    private ISVNOptions myOptions;
    private SvnAuthenticationManager myAuthManager;
    private SvnAuthenticationManager myPassiveAuthManager;
    private SvnAuthenticationManager myInteractiveManager;
    public static final AuthStorage RUNTIME_AUTH_CACHE = new AuthStorage();
    private final Map<File, MergeRootInfo> myMergeRootInfos = new HashMap<File, MergeRootInfo>();
    private final Map<File, UpdateRootInfo> myUpdateRootInfos = new HashMap<File, UpdateRootInfo>();
    private SvnInteractiveAuthenticationProvider myInteractiveProvider;
    private IdeaSVNConfigFile myServersFile;
    private SVNConfigFile myConfigFile;

    public boolean isCommandLine() {
        return UseAcceleration.commandLine.equals((Object)this.getUseAcceleration());
    }

    @NotNull
    public SvnConfigurationState getState() {
        SvnConfigurationState svnConfigurationState = this.myState;
        if (svnConfigurationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getState"));
        }
        return svnConfigurationState;
    }

    public void loadState(@NotNull SvnConfigurationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/svn/SvnConfiguration", "loadState"));
        }
        this.myState = state;
    }

    public long getHttpTimeout() {
        String timeout = this.getServersFile().getDefaultGroup().getTimeout();
        try {
            return Long.parseLong(timeout) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @NotNull
    public DiffOptions getMergeOptions() {
        DiffOptions diffOptions = new DiffOptions(this.isIgnoreSpacesInMerge(), this.isIgnoreSpacesInMerge(), this.isIgnoreSpacesInMerge());
        if (diffOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getMergeOptions"));
        }
        return diffOptions;
    }

    @NotNull
    private IdeaSVNConfigFile getServersFile() {
        if (this.myServersFile == null) {
            this.myServersFile = new IdeaSVNConfigFile(new File(this.getConfigurationDirectory(), "servers"));
        }
        this.myServersFile.updateGroups();
        IdeaSVNConfigFile ideaSVNConfigFile = this.myServersFile;
        if (ideaSVNConfigFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getServersFile"));
        }
        return ideaSVNConfigFile;
    }

    @NotNull
    public SVNConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            this.myConfigFile = new SVNConfigFile(new File(this.getConfigurationDirectory(), "config"));
        }
        SVNConfigFile sVNConfigFile = this.myConfigFile;
        if (sVNConfigFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getConfigFile"));
        }
        return sVNConfigFile;
    }

    @NotNull
    public String getSshTunnelSetting() {
        String string = StringUtil.notNullize((String)this.getConfigFile().getPropertyValue("tunnels", "ssh"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getSshTunnelSetting"));
        }
        return string;
    }

    public void setSshTunnelSetting(@Nullable String value) {
        this.getConfigFile().setPropertyValue("tunnels", "ssh", value, true);
    }

    public void setHttpTimeout(long value) {
        long cut = value / 1000L;
        this.getServersFile().setValue("global", "http-timeout", String.valueOf(cut));
        this.getServersFile().save();
    }

    public static SvnConfiguration getInstance(Project project) {
        return (SvnConfiguration)ServiceManager.getService((Project)project, SvnConfiguration.class);
    }

    public SvnConfiguration(Project project) {
        this.myProject = project;
    }

    public void setIgnoreSpacesInAnnotate(boolean value) {
        boolean changed = this.myState.IGNORE_SPACES_IN_ANNOTATE != value;
        this.myState.IGNORE_SPACES_IN_ANNOTATE = value;
        if (changed) {
            ((VcsAnnotationRefresher)this.getProject().getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).configurationChanged(SvnVcs.getKey());
        }
    }

    public long getSshConnectionTimeout() {
        return this.myState.sshConnectionTimeout;
    }

    public void setSshConnectionTimeout(long sshConnectionTimeout) {
        this.myState.sshConnectionTimeout = sshConnectionTimeout;
    }

    public long getSshReadTimeout() {
        return this.myState.sshReadTimeout;
    }

    public void setSshReadTimeout(long sshReadTimeout) {
        this.myState.sshReadTimeout = sshReadTimeout;
    }

    public Project getProject() {
        return this.myProject;
    }

    public Boolean isKeepNewFilesAsIsForTreeConflictMerge() {
        return this.myState.keepNewFilesAsIsForTreeConflictMerge;
    }

    public void setKeepNewFilesAsIsForTreeConflictMerge(Boolean keepNewFilesAsIsForTreeConflictMerge) {
        this.myState.keepNewFilesAsIsForTreeConflictMerge = keepNewFilesAsIsForTreeConflictMerge;
    }

    public SSLProtocols getSslProtocols() {
        return this.myState.sslProtocols;
    }

    public void setSslProtocols(SSLProtocols sslProtocols) {
        this.myState.sslProtocols = sslProtocols;
    }

    public Depth getUpdateDepth() {
        return this.myState.UPDATE_DEPTH;
    }

    public void setUpdateDepth(Depth updateDepth) {
        this.myState.UPDATE_DEPTH = updateDepth;
    }

    public UseAcceleration getUseAcceleration() {
        return this.myState.accelerationType;
    }

    public void setUseAcceleration(UseAcceleration useAcceleration) {
        this.myState.accelerationType = useAcceleration;
    }

    public boolean isRunUnderTerminal() {
        return this.myState.runUnderTerminal;
    }

    public void setRunUnderTerminal(boolean value) {
        this.myState.runUnderTerminal = value;
    }

    public boolean isIgnoreExternals() {
        return this.myState.IGNORE_EXTERNALS;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.myState.IGNORE_EXTERNALS = ignoreExternals;
    }

    public boolean isMergeDryRun() {
        return this.myState.MERGE_DRY_RUN;
    }

    public void setMergeDryRun(boolean mergeDryRun) {
        this.myState.MERGE_DRY_RUN = mergeDryRun;
    }

    public boolean isMergeDiffUseAncestry() {
        return this.myState.MERGE_DIFF_USE_ANCESTRY;
    }

    public void setMergeDiffUseAncestry(boolean mergeDiffUseAncestry) {
        this.myState.MERGE_DIFF_USE_ANCESTRY = mergeDiffUseAncestry;
    }

    public boolean isUpdateLockOnDemand() {
        return this.myState.UPDATE_LOCK_ON_DEMAND;
    }

    public void setUpdateLockOnDemand(boolean updateLockOnDemand) {
        this.myState.UPDATE_LOCK_ON_DEMAND = updateLockOnDemand;
    }

    public boolean isIgnoreSpacesInMerge() {
        return this.myState.IGNORE_SPACES_IN_MERGE;
    }

    public void setIgnoreSpacesInMerge(boolean ignoreSpacesInMerge) {
        this.myState.IGNORE_SPACES_IN_MERGE = ignoreSpacesInMerge;
    }

    public boolean isCheckNestedForQuickMerge() {
        return this.myState.CHECK_NESTED_FOR_QUICK_MERGE;
    }

    public void setCheckNestedForQuickMerge(boolean checkNestedForQuickMerge) {
        this.myState.CHECK_NESTED_FOR_QUICK_MERGE = checkNestedForQuickMerge;
    }

    public boolean isIgnoreSpacesInAnnotate() {
        return this.myState.IGNORE_SPACES_IN_ANNOTATE;
    }

    public boolean isShowMergeSourcesInAnnotate() {
        return this.myState.SHOW_MERGE_SOURCES_IN_ANNOTATE;
    }

    public void setShowMergeSourcesInAnnotate(boolean showMergeSourcesInAnnotate) {
        this.myState.SHOW_MERGE_SOURCES_IN_ANNOTATE = showMergeSourcesInAnnotate;
    }

    public boolean isForceUpdate() {
        return this.myState.FORCE_UPDATE;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.myState.FORCE_UPDATE = forceUpdate;
    }

    private static Long fixSupportedVersion(Long version) {
        return version == null || version < 124L ? 123L : version;
    }

    public boolean changeListsSynchronized() {
        this.ensureSupportedVersion();
        return this.myState.supportedVersion != null && this.myState.supportedVersion >= 124L;
    }

    public void upgrade() {
        this.myState.supportedVersion = 125L;
    }

    private void ensureSupportedVersion() {
        if (this.myState.supportedVersion == null) {
            this.myState.supportedVersion = SvnConfiguration.fixSupportedVersion(SvnBranchConfigurationManager.getInstance(this.myProject).getSupportValue());
        }
    }

    public String getConfigurationDirectory() {
        if (this.myState.directory.path == null || this.isUseDefaultConfiguation()) {
            this.myState.directory.path = IdeaSubversionConfigurationDirectory.getPath();
        }
        return this.myState.directory.path;
    }

    public boolean isUseDefaultConfiguation() {
        return this.myState.directory.useDefault;
    }

    public void setConfigurationDirParameters(boolean newUseDefault, String newConfigurationDirectory) {
        boolean usageChanged;
        boolean directoryChanged;
        String defaultPath = IdeaSubversionConfigurationDirectory.getPath();
        String oldEffectivePath = this.isUseDefaultConfiguation() ? defaultPath : this.getConfigurationDirectory();
        String newEffectivePath = newUseDefault ? defaultPath : newConfigurationDirectory;
        boolean bl = directoryChanged = !Comparing.equal((String)this.getConfigurationDirectory(), (String)newConfigurationDirectory);
        if (directoryChanged) {
            this.setConfigurationDirectory(newConfigurationDirectory);
        }
        boolean bl2 = usageChanged = this.isUseDefaultConfiguation() != newUseDefault;
        if (usageChanged) {
            this.setUseDefaultConfiguation(newUseDefault);
        }
        if ((directoryChanged || usageChanged) && !Comparing.equal((String)oldEffectivePath, (String)newEffectivePath)) {
            this.clear();
        }
    }

    private void setConfigurationDirectory(String path) {
        this.myState.directory.path = path;
        File dir = path == null ? new File(IdeaSubversionConfigurationDirectory.getPath()) : new File(path);
        SVNConfigFile.createDefaultConfiguration((File)dir);
    }

    public void clear() {
        this.myOptions = null;
        this.myAuthManager = null;
        this.myPassiveAuthManager = null;
        this.myInteractiveManager = null;
        this.myInteractiveProvider = null;
        RUNTIME_AUTH_CACHE.clear();
    }

    private void setUseDefaultConfiguation(boolean useDefault) {
        this.myState.directory.useDefault = useDefault;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            File path = new File(this.getConfigurationDirectory());
            this.myOptions = SVNWCUtil.createDefaultOptions((File)path.getAbsoluteFile(), (boolean)true);
        }
        return this.myOptions;
    }

    public SvnAuthenticationManager getAuthenticationManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnVcs", "org/jetbrains/idea/svn/SvnConfiguration", "getAuthenticationManager"));
        }
        if (this.myAuthManager == null) {
            this.myAuthManager = new SvnAuthenticationManager(svnVcs, new File(this.getConfigurationDirectory()));
            Disposer.register((Disposable)svnVcs.getProject(), () -> {
                this.myAuthManager = null;
            });
            this.getInteractiveManager(svnVcs);
            this.myAuthManager.setAuthenticationProvider(new SvnAuthenticationProvider(svnVcs, this.myInteractiveProvider, this.myAuthManager));
            this.myAuthManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
        }
        return this.myAuthManager;
    }

    public SvnAuthenticationManager getPassiveAuthenticationManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnVcs", "org/jetbrains/idea/svn/SvnConfiguration", "getPassiveAuthenticationManager"));
        }
        if (this.myPassiveAuthManager == null) {
            this.myPassiveAuthManager = new SvnAuthenticationManager(svnVcs, new File(this.getConfigurationDirectory()));
            this.myPassiveAuthManager.setAuthenticationProvider(new ISVNAuthenticationProvider(){

                public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                    return null;
                }

                public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                    return 0;
                }
            });
            this.myPassiveAuthManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
        }
        return this.myPassiveAuthManager;
    }

    public SvnAuthenticationManager getInteractiveManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnVcs", "org/jetbrains/idea/svn/SvnConfiguration", "getInteractiveManager"));
        }
        if (this.myInteractiveManager == null) {
            this.myInteractiveManager = new SvnAuthenticationManager(svnVcs, new File(this.getConfigurationDirectory()));
            this.myInteractiveManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
            this.myInteractiveProvider = new SvnInteractiveAuthenticationProvider(svnVcs, this.myInteractiveManager);
            this.myInteractiveManager.setAuthenticationProvider(this.myInteractiveProvider);
        }
        return this.myInteractiveManager;
    }

    public void getServerFilesManagers(Ref<SvnServerFileManager> systemManager, Ref<SvnServerFileManager> userManager) {
        File dir = new File(this.getConfigurationDirectory());
        if (!dir.exists()) {
            SVNConfigFile.createDefaultConfiguration((File)dir);
        }
        systemManager.set((Object)new SvnServerFileManagerImpl(new IdeaSVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"))));
        userManager.set((Object)new SvnServerFileManagerImpl(this.getServersFile()));
    }

    public boolean isAutoUpdateAfterCommit() {
        return this.myState.autoUpdateAfterCommit;
    }

    public void setAutoUpdateAfterCommit(boolean autoUpdateAfterCommit) {
        this.myState.autoUpdateAfterCommit = autoUpdateAfterCommit;
    }

    public boolean isKeepLocks() {
        return this.myState.keepLocks;
    }

    public void setKeepLocks(boolean keepLocks) {
        this.myState.keepLocks = keepLocks;
    }

    public boolean isIsUseDefaultProxy() {
        return this.myState.useDefaultProxy;
    }

    public void setIsUseDefaultProxy(boolean isUseDefaultProxy) {
        this.myState.useDefaultProxy = isUseDefaultProxy;
    }

    @NotNull
    public MergeRootInfo getMergeRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myMergeRootInfos.containsKey(file)) {
            this.myMergeRootInfos.put(file, new MergeRootInfo(file, svnVcs));
        }
        MergeRootInfo mergeRootInfo = this.myMergeRootInfos.get(file);
        if (mergeRootInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration", "getMergeRootInfo"));
        }
        return mergeRootInfo;
    }

    public UpdateRootInfo getUpdateRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myUpdateRootInfos.containsKey(file)) {
            this.myUpdateRootInfos.put(file, new UpdateRootInfo(file, svnVcs));
        }
        return this.myUpdateRootInfos.get(file);
    }

    public Map<File, UpdateRootInfo> getUpdateInfosMap() {
        return Collections.unmodifiableMap(this.myUpdateRootInfos);
    }

    public void acknowledge(String kind, String realm, Object object) {
        RUNTIME_AUTH_CACHE.putData(kind, realm, object);
    }

    public void clearCredentials(String kind, String realm) {
        RUNTIME_AUTH_CACHE.putData(kind, realm, null);
    }

    public void clearRuntimeStorage() {
        RUNTIME_AUTH_CACHE.clear();
    }

    public int getMaxAnnotateRevisions() {
        return this.myState.maxAnnotateRevisions;
    }

    public void setMaxAnnotateRevisions(int maxAnnotateRevisions) {
        this.myState.maxAnnotateRevisions = maxAnnotateRevisions;
    }

    public boolean isCleanupRun() {
        return this.myState.cleanupOnStartRun;
    }

    public void setCleanupRun(boolean cleanupRun) {
        this.myState.cleanupOnStartRun = cleanupRun;
    }

    public static enum SshConnectionType {
        PASSWORD,
        PRIVATE_KEY,
        SUBVERSION_CONFIG;

    }

    public static enum SSLProtocols {
        sslv3,
        tlsv1,
        all;

    }

    public static enum UseAcceleration {
        commandLine,
        nothing;

    }

    public static class AuthStorage
    implements ISVNAuthenticationStorage {
        private final TreeSet<String> myKeys = ContainerUtil.newTreeSet();
        private final Map<String, Object> myStorage = ContainerUtil.newHashMap();

        @NotNull
        public static String getKey(@NotNull String type, @NotNull String realm) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/SvnConfiguration$AuthStorage", "getKey"));
            }
            if (realm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realm", "org/jetbrains/idea/svn/SvnConfiguration$AuthStorage", "getKey"));
            }
            String string = type + "$" + realm;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnConfiguration$AuthStorage", "getKey"));
            }
            return string;
        }

        public synchronized void clear() {
            this.myStorage.clear();
            this.myKeys.clear();
        }

        public synchronized void putData(String kind, String realm, Object data) {
            String key = AuthStorage.getKey(kind, realm);
            if (data == null) {
                this.myStorage.remove(key);
                this.myKeys.remove(key);
            } else {
                this.myStorage.put(key, data);
                this.myKeys.add(key);
            }
        }

        public synchronized Object getData(String kind, String realm) {
            return this.myStorage.get(AuthStorage.getKey(kind, realm));
        }

        public synchronized Object getDataWithLowerCheck(String kind, String realm) {
            String lowerKey;
            String key = AuthStorage.getKey(kind, realm);
            Object result = this.myStorage.get(key);
            if (result == null && (lowerKey = this.myKeys.lower(key)) != null && key.startsWith(lowerKey)) {
                result = this.myStorage.get(lowerKey);
            }
            return result;
        }
    }
}

