/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.RelocateDialog;
import org.jetbrains.idea.svn.info.Info;

public class RelocateAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(RelocateAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        if ("Relocate working copy to a different URL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/RelocateAction", "getActionName"));
        }
        return "Relocate working copy to a different URL";
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/RelocateAction", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/RelocateAction", "isEnabled"));
        }
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        String afterURL;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/RelocateAction", "perform"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/RelocateAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/RelocateAction", "perform"));
        }
        Info info = vcs.getInfo(file);
        if (info == null) {
            LOG.info("Could not get info for " + file);
            return;
        }
        RelocateDialog dlg = new RelocateDialog(vcs.getProject(), info.getURL());
        if (!dlg.showAndGet()) {
            return;
        }
        String beforeURL = dlg.getBeforeURL();
        if (beforeURL.equals(afterURL = dlg.getAfterURL())) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/RelocateAction", "lambda$perform$1"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/RelocateAction", "lambda$perform$1"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(path).createRelocateClient().relocate(path, beforeURL, afterURL);
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).markEverythingDirty();
            }
            catch (VcsException e) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                    if (vcs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/RelocateAction", "lambda$null$0"));
                    }
                    Messages.showErrorDialog((Project)vcs.getProject(), (String)("Error relocating working copy: " + e.getMessage()), (String)"Relocate Working Copy");
                }, null, (Project)vcs.getProject());
            }
        }, "Relocating Working Copy", false, vcs.getProject());
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/RelocateAction", "batchPerform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/actions/RelocateAction", "batchPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/RelocateAction", "batchPerform"));
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

