/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitPropertyClient
extends BaseSvnClient
implements PropertyClient {
    public static final ISVNOptions LF_SEPARATOR_OPTIONS = new DefaultSVNOptions(){

        public byte[] getNativeEOL() {
            return CharsetToolkit.getUtf8Bytes((String)LineSeparator.LF.getSeparatorString());
        }
    };

    @Override
    @Nullable
    public PropertyValue getProperty(@NotNull SvnTarget target, @NotNull String property, boolean revisionProperty, @Nullable SVNRevision revision) throws VcsException {
        PropertyData resultData;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        try {
            resultData = !revisionProperty ? (target.isFile() ? PropertyData.create(this.createClient().doGetProperty(target.getFile(), property, target.getPegRevision(), revision)) : PropertyData.create(this.createClient().doGetProperty(target.getURL(), property, target.getPegRevision(), revision))) : this.getRevisionProperty(target, property, revision);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        return resultData != null ? resultData.getValue() : null;
    }

    @NotNull
    private SVNWCClient createClient() {
        SVNWCClient client = this.myVcs.getSvnKitManager().createWCClient();
        client.setOptions(LF_SEPARATOR_OPTIONS);
        SVNWCClient sVNWCClient = client;
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "createClient"));
        }
        return sVNWCClient;
    }

    @Override
    public void getProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        this.runGetProperty(target, property, revision, depth, handler);
    }

    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "list"));
        }
        this.runGetProperty(target, null, revision, depth, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable PropertyValue value, @Nullable Depth depth, boolean force) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperty"));
        }
        try {
            this.createClient().doSetProperty(file, property, SvnKitPropertyClient.toPropertyValue(value), force, SvnKitPropertyClient.toDepth(depth), null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull PropertiesMap properties) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperties"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperties"));
        }
        SVNProperties propertiesToSet = SvnKitPropertyClient.toSvnProperties(properties);
        try {
            this.createClient().doSetProperty(file, (path, properties1) -> propertiesToSet, true, SVNDepth.EMPTY, null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setRevisionProperty(@NotNull SvnTarget target, @NotNull String property, @NotNull SVNRevision revision, @Nullable PropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        try {
            if (target.isFile()) {
                this.createClient().doSetRevisionProperty(target.getFile(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            } else {
                this.createClient().doSetRevisionProperty(target.getURL(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private static SVNProperties toSvnProperties(@NotNull PropertiesMap properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "toSvnProperties"));
        }
        SVNProperties result = new SVNProperties();
        for (Map.Entry entry : properties.entrySet()) {
            result.put((String)entry.getKey(), SvnKitPropertyClient.toPropertyValue((PropertyValue)entry.getValue()));
        }
        SVNProperties sVNProperties = result;
        if (sVNProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "toSvnProperties"));
        }
        return sVNProperties;
    }

    private void runGetProperty(@NotNull SvnTarget target, @Nullable String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "runGetProperty"));
        }
        SVNWCClient client = this.createClient();
        try {
            if (target.isURL()) {
                client.doGetProperty(target.getURL(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler));
            } else {
                client.doGetProperty(target.getFile(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler), null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private PropertyData getRevisionProperty(@NotNull SvnTarget target, final @NotNull String property, @Nullable SVNRevision revision) throws SVNException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getRevisionProperty"));
        }
        SVNWCClient client = this.createClient();
        final PropertyData[] result = new PropertyData[1];
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(long revision, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            private void handle(@NotNull SVNPropertyData data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient$2", "handle"));
                }
                if (property.equals(data.getName())) {
                    result[0] = PropertyData.create(data);
                }
            }
        };
        if (target.isFile()) {
            client.doGetRevisionProperty(target.getFile(), null, revision, handler);
        } else {
            client.doGetRevisionProperty(target.getURL(), null, revision, handler);
        }
        return result[0];
    }

    @Nullable
    private static ISVNPropertyHandler toHandler(final @Nullable PropertyConsumer consumer) {
        ISVNPropertyHandler result = null;
        if (consumer != null) {
            result = new ISVNPropertyHandler(){

                public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(path, PropertyData.create(property));
                }

                public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(url, PropertyData.create(property));
                }

                public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(revision, PropertyData.create(property));
                }
            };
        }
        return result;
    }

    @Nullable
    private static SVNPropertyValue toPropertyValue(@Nullable PropertyValue value) {
        SVNPropertyValue result = null;
        if (value != null) {
            result = SVNPropertyValue.create((String)value.toString());
        }
        return result;
    }
}

