/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;

public class SuperfluousRemover {
    private final Set<File> myParentPaths;
    private final boolean myCheckBefore;

    SuperfluousRemover(boolean checkBefore) {
        this.myCheckBefore = checkBefore;
        this.myParentPaths = new HashSet<File>();
    }

    protected boolean accept(@NotNull Change change) {
        ContentRevision otherRevision;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/rollback/SuperfluousRemover", "accept"));
        }
        ContentRevision mainRevision = this.myCheckBefore ? change.getBeforeRevision() : change.getAfterRevision();
        ContentRevision contentRevision = otherRevision = !this.myCheckBefore ? change.getBeforeRevision() : change.getAfterRevision();
        if (mainRevision == null || SvnRollbackEnvironment.isMoveRenameReplace(change)) {
            this.check(otherRevision.getFile().getIOFile());
            return true;
        }
        return false;
    }

    public void check(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/SuperfluousRemover", "check"));
        }
        boolean parentAlreadyRegistered = ContainerUtil.or(this.myParentPaths, parentCandidate -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/SuperfluousRemover", "lambda$check$0"));
            }
            return VfsUtilCore.isAncestor((File)parentCandidate, (File)file, (boolean)true);
        });
        if (!parentAlreadyRegistered) {
            ContainerUtil.retainAll(this.myParentPaths, childCandidate -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/SuperfluousRemover", "lambda$check$1"));
                }
                return !VfsUtilCore.isAncestor((File)file, (File)childCandidate, (boolean)true);
            });
            this.myParentPaths.add(file);
        }
    }

    public Set<File> getParentPaths() {
        return this.myParentPaths;
    }
}

