/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnTreeConflictResolver {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final FilePath myRevertPath;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public SvnTreeConflictResolver(@NotNull SvnVcs vcs, @NotNull FilePath path, @Nullable FilePath revertPath) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "<init>"));
        }
        this.myVcs = vcs;
        this.myPath = path;
        this.myRevertPath = revertPath;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
    }

    public void resolveSelectTheirsFull() throws VcsException {
        LocalHistory localHistory = LocalHistory.getInstance();
        String pathPresentation = TreeConflictRefreshablePanel.filePath(this.myPath);
        localHistory.putSystemLabel(this.myVcs.getProject(), "Before accepting theirs for " + pathPresentation);
        try {
            this.updateToTheirsFull();
            this.pathDirty(this.myPath);
            this.revertAdditional();
        }
        finally {
            localHistory.putSystemLabel(this.myVcs.getProject(), "After accepting theirs for " + pathPresentation);
        }
    }

    private void pathDirty(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "pathDirty"));
        }
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (validParent != null) {
            validParent.refresh(false, true);
            if (path.isDirectory()) {
                this.myDirtyScopeManager.dirDirtyRecursively(path);
            } else {
                this.myDirtyScopeManager.fileDirty(path);
            }
        }
    }

    private void revertAdditional() throws VcsException {
        if (this.myRevertPath != null) {
            File ioFile = this.myRevertPath.getIOFile();
            Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
            this.revert(ioFile);
            if (StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
                FileUtil.delete((File)ioFile);
            }
            this.pathDirty(this.myRevertPath);
        }
    }

    public void resolveSelectMineFull() throws VcsException {
        File ioFile = this.myPath.getIOFile();
        this.myVcs.getFactory(ioFile).createConflictClient().resolve(ioFile, Depth.INFINITY, true, true, true);
        this.pathDirty(this.myPath);
    }

    private void updateToTheirsFull() throws VcsException {
        File ioFile = this.myPath.getIOFile();
        Status status = this.myVcs.getFactory(ioFile).createStatusClient().doStatus(ioFile, false);
        if (status == null || StatusType.STATUS_UNVERSIONED.equals((Object)status.getNodeStatus())) {
            this.revert(ioFile);
            this.updateFile(ioFile, SVNRevision.HEAD);
        } else if (StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
            this.revert(ioFile);
            this.updateFile(ioFile, SVNRevision.HEAD);
            FileUtil.delete((File)ioFile);
        } else {
            HashSet usedToBeAdded = this.myPath.isDirectory() ? this.getDescendantsWithAddedStatus(ioFile) : ContainerUtil.newHashSet();
            this.revert(ioFile);
            for (File wasAdded : usedToBeAdded) {
                FileUtil.delete((File)wasAdded);
            }
            this.updateFile(ioFile, SVNRevision.HEAD);
        }
    }

    @NotNull
    private Set<File> getDescendantsWithAddedStatus(@NotNull File ioFile) throws SvnBindException {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "getDescendantsWithAddedStatus"));
        }
        HashSet result = ContainerUtil.newHashSet();
        StatusClient statusClient = this.myVcs.getFactory(ioFile).createStatusClient();
        statusClient.doStatus(ioFile, SVNRevision.UNDEFINED, Depth.INFINITY, false, false, false, false, status -> {
            if (status != null && StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
                result.add(status.getFile());
            }
        }, null);
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "getDescendantsWithAddedStatus"));
        }
        return hashSet;
    }

    private void revert(@NotNull File file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "revert"));
        }
        this.myVcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.INFINITY, null);
    }

    private void updateFile(@NotNull File file, @NotNull SVNRevision revision) throws SvnBindException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "updateFile"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/treeConflict/SvnTreeConflictResolver", "updateFile"));
        }
        boolean useParentAsTarget = !file.exists();
        File target = useParentAsTarget ? file.getParentFile() : file;
        this.myVcs.getFactory(target).createUpdateClient().doUpdate(target, revision, Depth.INFINITY, useParentAsTarget, false);
    }
}

