/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FtlCompletionContributor;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlDeclarationCache;
import com.intellij.freemarker.psi.directives.FtlDeclarationHolder;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlFileReference;
import com.intellij.freemarker.psi.directives.PackageFileSystemItem;
import com.intellij.freemarker.psi.directives.ResolveStateParameters;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlFileReferenceDirective
extends FtlDirective {
    private static final Key<FtlDeclarationCache> FILE_DECLARATIONS = Key.create((String)"FILE_DECLARATIONS");
    @NonNls
    public static final Pattern FTL_ROOT_PATTERN = Pattern.compile(".#-- @ftlroot \"(.+)\"( *)--.");
    public static final RecursionGuard FILE_RECURSION_GUARD = RecursionManager.createGuard((String)"Ftl File Declarations");

    public FtlFileReferenceDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective", "<init>"));
        }
        super(node);
    }

    @Nullable
    public PsiFile resolveFile() {
        return (PsiFile)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.doResolveFile(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    private PsiFile doResolveFile() {
        FtlStringLiteral literal = this.getReferenceLiteral();
        if (literal == null) {
            return null;
        }
        for (PsiReference reference : literal.getReferences()) {
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiFile)) continue;
            return (PsiFile)target;
        }
        return null;
    }

    @Nullable
    public FtlStringLiteral getReferenceLiteral() {
        return (FtlStringLiteral)this.findChildByClass(FtlStringLiteral.class);
    }

    public boolean processDeclarationsInFile(PsiScopeProcessor processor, ResolveState state) {
        PsiFile file = this.resolveFile();
        if (!(file instanceof FtlFile)) {
            return true;
        }
        Boolean result = (Boolean)FILE_RECURSION_GUARD.doPreventingRecursion((Object)file, false, () -> {
            FtlXmlRootTag tag = ((FtlFile)file).getRootTag();
            FtlDeclarationCache cache = (FtlDeclarationCache)tag.getUserData(FILE_DECLARATIONS);
            if (cache == null) {
                cache = new FtlTagDeclarationCache(tag);
                tag.putUserData(FILE_DECLARATIONS, cache);
            }
            return cache.processDirectiveDeclarations(processor, state, true);
        });
        return result == null || result != false;
    }

    public static PsiReference[] createFileReferences(FtlStringLiteral literal) {
        int start = literal.getFirstChild().getTextLength();
        String text = literal.getValueText();
        boolean acquisition = false;
        if (text.startsWith("*/")) {
            start += 2;
            text = text.substring(2);
            acquisition = true;
        }
        FileReferenceSet set = new FileReferenceSet(text, literal, start, null, true, true){

            protected boolean isSoft() {
                return true;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FtlFileReference(range, index, text, this);
            }
        };
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)new ContextFileProvider(acquisition, set));
        return (PsiReference[])ArrayUtil.append((Object[])set.getAllReferences(), (Object)((Object)new FtlCustomFileReference(literal)), PsiReference.class);
    }

    private static PsiDirectory[] getAllVisibleSourceRoots(PsiFile psiFile) {
        Project project = psiFile.getProject();
        return (PsiDirectory[])CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            PsiPackage rootPkg = JavaPsiFacade.getInstance((Project)project).findPackage("");
            PsiDirectory[] result = rootPkg != null ? rootPkg.getDirectories(psiFile.getResolveScope()) : PsiDirectory.EMPTY_ARRAY;
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        });
    }

    public static void collectFtlRoots(Module module, Collection<PsiFileSystemItem> result) {
        for (FtlFile file : FtlFile.getImplicitlyIncludedFiles(module)) {
            FtlFileReferenceDirective.collectFtlRoots((PsiFile)file, result);
        }
    }

    public static void collectFtlRoots(@NotNull PsiFile psiFile, Collection<PsiFileSystemItem> result) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective", "collectFtlRoots"));
        }
        result.addAll(FtlFileReferenceDirective.getDefinedFtlRoots(psiFile.getManager(), psiFile));
    }

    public static Set<PsiDirectory> getDefinedFtlRoots(PsiManager manager, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective", "getDefinedFtlRoots"));
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            HashSet set = new HashSet();
            FileBasedIndex.getInstance().processValues(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.DATA, vFile, (file, value) -> {
                for (String rootPath : value.roots) {
                    VirtualFile root = FtlFileReferenceDirective.getFtlRoot(rootPath, vFile);
                    if (root == null) continue;
                    ContainerUtil.addIfNotNull((Collection)set, (Object)manager.findDirectory(root));
                }
                return true;
            }, GlobalSearchScope.fileScope((Project)manager.getProject(), (VirtualFile)vFile));
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static VirtualFile getFtlRoot(String path, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective", "getFtlRoot"));
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return null;
        }
        int jarSeparator = path.indexOf("!/");
        if (jarSeparator > 0) {
            return JarFileSystem.getInstance().findFileByPath(parent.getPath() + "/" + path);
        }
        return parent.findFileByRelativePath(path);
    }

    @Nullable
    public static String getRelativePath(VirtualFile from, VirtualFile to) {
        return VfsUtil.getPath((VirtualFile)from, (VirtualFile)to, (char)'/');
    }

    private static class ContextFileProvider
    implements NullableFunction<PsiFile, Collection<PsiFileSystemItem>> {
        private final boolean myAcquisition;
        private final FileReferenceSet mySet;

        public ContextFileProvider(boolean acquisition, FileReferenceSet set) {
            this.myAcquisition = acquisition;
            this.mySet = set;
        }

        private static PsiDirectory[] getMetaInfResourcesDirectories(@NotNull PsiFile element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective$ContextFileProvider", "getMetaInfResourcesDirectories"));
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)element.getProject()).findPackage("META-INF.resources");
            return psiPackage == null || module == null ? PsiDirectory.EMPTY_ARRAY : psiPackage.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false));
        }

        public Collection<PsiFileSystemItem> fun(PsiFile psiFile) {
            if (this.myAcquisition) {
                return this.getAcquisitionVariants(psiFile);
            }
            LinkedHashSet<PsiFileSystemItem> result = new LinkedHashSet<PsiFileSystemItem>();
            if (this.mySet.isAbsolutePathReference() || !this.mySet.getPathString().contains("/")) {
                ContextFileProvider.addFtlRoots(psiFile, result);
            }
            if (this.mySet.isAbsolutePathReference()) {
                if (result.isEmpty()) {
                    result.addAll(FileReferenceSet.getAbsoluteTopLevelDirLocations((PsiFile)psiFile));
                    Collections.addAll(result, ContextFileProvider.getMetaInfResourcesDirectories(psiFile));
                    Collections.addAll(result, FtlFileReferenceDirective.getAllVisibleSourceRoots(psiFile));
                }
            } else {
                PsiDirectory directory = psiFile.getContainingDirectory();
                if (directory != null) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    result.add(aPackage != null ? new PackageFileSystemItem(aPackage, this.mySet.getElement().getResolveScope()) : directory);
                }
            }
            return result.isEmpty() ? null : result;
        }

        private static void addFtlRoots(PsiFile psiFile, Collection<PsiFileSystemItem> result) {
            Module module;
            result.addAll(FtlFileReferenceDirective.getDefinedFtlRoots(psiFile.getManager(), psiFile.getOriginalFile()));
            if (result.isEmpty() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null) {
                FtlFileReferenceDirective.collectFtlRoots(module, result);
            }
        }

        private Collection<PsiFileSystemItem> getAcquisitionVariants(PsiFile psiFile) {
            ArrayList<PsiFileSystemItem> allDirs = new ArrayList<PsiFileSystemItem>();
            for (PsiDirectory directory = psiFile.getContainingDirectory(); directory != null; directory = directory.getParentDirectory()) {
                FileReference reference;
                allDirs.add((PsiFileSystemItem)directory);
                PsiDirectory context = directory;
                FileReference[] fileReferenceArray = this.mySet.getAllReferences();
                int n = fileReferenceArray.length;
                for (int i = 0; i < n && (context = ((FtlFileReference)(reference = fileReferenceArray[i])).resolveInContext((PsiFileSystemItem)context)) != null; ++i) {
                }
                if (!(context instanceof PsiFile)) continue;
                return Collections.singletonList(directory);
            }
            return allDirs;
        }
    }

    private static class FtlTagDeclarationCache
    extends FtlDeclarationCache<FtlXmlTag> {
        public FtlTagDeclarationCache(FtlXmlTag tag) {
            super(tag);
        }

        @Override
        protected FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters parameters) {
            final ArrayList declarations = ContainerUtil.newArrayList();
            this.myTag.processDirectiveDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective$FtlTagDeclarationCache$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective$FtlTagDeclarationCache$1", "execute"));
                    }
                    declarations.add(Pair.create((Object)element, (Object)state));
                    return true;
                }
            }, parameters.createState(), null, true);
            return new FtlDeclarationHolder(){

                @Override
                public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state) {
                    for (Pair pair : declarations) {
                        if (processor.execute((PsiElement)pair.first, (ResolveState)pair.second)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
    }

    public static class FtlCustomFileReference
    extends PsiReferenceBase<FtlStringLiteral> {
        private final FtlStringLiteral myLiteral;

        public FtlCustomFileReference(FtlStringLiteral literal) {
            super((PsiElement)literal, literal.getValueRange(), true);
            this.myLiteral = literal;
        }

        public PsiElement resolve() {
            for (FtlGlobalVariableProvider provider : (FtlGlobalVariableProvider[])Extensions.getExtensions(FtlGlobalVariableProvider.EP_NAME)) {
                Map<String, FtlFile> values = provider.getSpecialFileReferenceValues(this.myLiteral.getContainingFile());
                FtlFile target = values.get(this.getCanonicalText());
                if (target == null) continue;
                return target;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            SmartList result = new SmartList();
            for (FtlGlobalVariableProvider provider : (FtlGlobalVariableProvider[])Extensions.getExtensions(FtlGlobalVariableProvider.EP_NAME)) {
                Map<String, FtlFile> values = provider.getSpecialFileReferenceValues(this.myLiteral.getContainingFile());
                for (String s : values.keySet()) {
                    result.add(FtlCompletionContributor.createFileReferenceLookupItem(s));
                }
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlFileReferenceDirective$FtlCustomFileReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

