/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonToolArguments arguments) throws InstantiationException, IllegalAccessException {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArrayList<String> result = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments, (CommonToolArguments)arguments.getClass().newInstance(), arguments.getClass(), result);
        result.addAll(arguments.freeArgs);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonToolArguments arguments, @NotNull CommonToolArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result) throws IllegalAccessException, InstantiationException {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (value == null || Objects.equals(value, defaultValue)) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) continue;
                value = StringsKt.join(Arrays.asList(values), ",");
            }
            result.add(argument.value());
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument)) {
                result.set(result.size() - 1, argument.value() + "=" + value.toString());
                continue;
            }
            result.add(value.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments, defaultArguments, superClazz, result);
        }
    }
}

