/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EjbClassInheritorsSearcher {
    private EjbClassInheritorsSearcher() {
    }

    private static boolean processImplementations(PsiClass aClass, Processor<PsiClass> consumer) {
        EjbClassRole[] classRoles = (EjbClassRole[])ReadAction.compute(() -> OldEjbRolesUtil.getEjbRoles(aClass));
        if (classRoles.length == 0) {
            return true;
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (EjbClassRole classRole : classRoles) {
            boolean processed;
            if (classRole == null || !classRole.isDeclarationRole() || (processed = ((Boolean)ReadAction.compute(() -> {
                for (PsiClass candidate : classRole.findImplementations()) {
                    if (candidate.isInheritor(aClass, true) || !visited.add(candidate) || consumer.process((Object)candidate)) continue;
                    return false;
                }
                return true;
            })).booleanValue())) continue;
            return false;
        }
        return true;
    }

    public static class ClassInheritorsSearcher
    implements QueryExecutor<PsiClass, ClassInheritorsSearch.SearchParameters> {
        public boolean execute(@NotNull ClassInheritorsSearch.SearchParameters p, @NotNull Processor<PsiClass> consumer) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/javaee/EjbClassInheritorsSearcher$ClassInheritorsSearcher", "execute"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/EjbClassInheritorsSearcher$ClassInheritorsSearcher", "execute"));
            }
            return EjbClassInheritorsSearcher.processImplementations(p.getClassToProcess(), (Processor<PsiClass>)consumer);
        }
    }

    public static class DirectInheritorsSearcher
    implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
        public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters p, @NotNull Processor<PsiClass> consumer) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/javaee/EjbClassInheritorsSearcher$DirectInheritorsSearcher", "execute"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/EjbClassInheritorsSearcher$DirectInheritorsSearcher", "execute"));
            }
            return EjbClassInheritorsSearcher.processImplementations(p.getClassToProcess(), (Processor<PsiClass>)consumer);
        }
    }
}

