/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.view.panels;

import com.intellij.javaee.toolwindow.view.JavaeeViewFrameworkProvider;
import com.intellij.javaee.toolwindow.view.JavaeeViewSettings;
import com.intellij.javaee.toolwindow.view.panels.ModulesPanel;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.FinderRecursivePanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworksFinderRecursivePanel
extends FinderRecursivePanel<JavaeeViewFrameworkProvider> {
    @NotNull
    private final DefaultActionGroup myActions;
    private Module myModule;

    public FrameworksFinderRecursivePanel(@NotNull Project project, @NotNull DefaultActionGroup actions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/toolwindow/view/panels/FrameworksFinderRecursivePanel", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/javaee/toolwindow/view/panels/FrameworksFinderRecursivePanel", "<init>"));
        }
        super(project, "FrameworksFinderRecursivePanel");
        this.myActions = actions;
    }

    public FrameworksFinderRecursivePanel(ModulesPanel panel, Module module, @NotNull DefaultActionGroup actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/javaee/toolwindow/view/panels/FrameworksFinderRecursivePanel", "<init>"));
        }
        super((FinderRecursivePanel)panel);
        this.myModule = module;
        this.myActions = actions;
    }

    @NotNull
    protected List<JavaeeViewFrameworkProvider> getListItems() {
        ArrayList<JavaeeViewFrameworkProvider> items = new ArrayList<JavaeeViewFrameworkProvider>();
        if (this.isRootPanel()) {
            block0: for (JavaeeViewFrameworkProvider frameworkProvider : (JavaeeViewFrameworkProvider[])Extensions.getExtensions(JavaeeViewFrameworkProvider.EXTENSION_POINT_NAME)) {
                for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                    if (!frameworkProvider.isAvailable(module)) continue;
                    items.add(frameworkProvider);
                    continue block0;
                }
            }
        } else {
            for (JavaeeViewFrameworkProvider frameworkProvider : (JavaeeViewFrameworkProvider[])Extensions.getExtensions(JavaeeViewFrameworkProvider.EXTENSION_POINT_NAME)) {
                if (!frameworkProvider.isAvailable(this.myModule)) continue;
                items.add(frameworkProvider);
            }
        }
        ArrayList<JavaeeViewFrameworkProvider> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/toolwindow/view/panels/FrameworksFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    @NotNull
    protected String getItemText(JavaeeViewFrameworkProvider provider) {
        String string = provider.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/toolwindow/view/panels/FrameworksFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(JavaeeViewFrameworkProvider provider) {
        return provider.getIcon();
    }

    @Nullable
    protected JComponent createRightComponent(JavaeeViewFrameworkProvider provider) {
        if (this.isRootPanel()) {
            if (JavaeeViewSettings.getInstance(this.getProject()).isShowModules()) {
                return new ModulesPanel(this, provider, this.myActions);
            }
            JComponent projectView = provider.createProjectView(this, this.getProject(), this.myActions);
            return projectView == null ? new ModulesPanel(this, provider, this.myActions) : projectView;
        }
        return provider.createModuleView(this, this.myModule, this.myActions);
    }

    protected boolean hasChildren(JavaeeViewFrameworkProvider provider) {
        return true;
    }
}

