/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerBinding;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.mapping.EntityBase;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.nodes.PersistenceFacetNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistentObjectNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModelMergerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityListenerBindingsPanel
implements Disposable {
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JCheckBox myDefaultEntityListener;
    private final PersistenceFacet myFacet;
    private final Project myProject;
    private final PersistenceEntityBaseTreeView myTreeView;
    private final HashMap<PersistentEntityBase, String> targetMembers;
    private boolean isDefaultEntityListener;
    private final String myEntityListenerClass;

    public EntityListenerBindingsPanel(@NotNull Project project, @NotNull PersistenceFacet facet, @NotNull String entityListenerClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/view/EntityListenerBindingsPanel", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/view/EntityListenerBindingsPanel", "<init>"));
        }
        if (entityListenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityListenerClass", "com/intellij/jpa/view/EntityListenerBindingsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.targetMembers = new HashMap();
        this.isDefaultEntityListener = false;
        this.myEntityListenerClass = entityListenerClass;
        this.myFacet = facet;
        this.myProject = project;
        this.initEntityListenerBindings();
        this.myTreeView = new PersistenceEntityBaseTreeView(this.myProject, facet, this.targetMembers);
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.setupControls();
        this.refreshControls();
    }

    private void initEntityListenerBindings() {
        this.targetMembers.clear();
        this.processEntityListenerBindings((PairProcessor<EntityListenerBinding, String>)((PairProcessor)(s, t) -> {
            if (s.getTargetObject() != null) {
                this.targetMembers.put(s.getTargetObject(), (String)t);
            } else if ("*".equals(s.getEntityBaseClassName())) {
                this.isDefaultEntityListener = true;
            }
            return true;
        }));
    }

    private void processEntityListenerBindings(PairProcessor<EntityListenerBinding, String> processor) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myEntityListenerClass, GlobalSearchScope.moduleScope((Module)this.myFacet.getModule()));
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass)) {
            if (!(role.getEntityListener() instanceof EntityListener)) continue;
            ((EntityListener)role.getEntityListener()).processEntityListenerBindings(binding -> processor.process(binding, (Object)binding.getEntityBaseClassName()));
        }
    }

    private void refreshControls() {
        this.updateOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeView.getTreeTableView();
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myDefaultEntityListener.setSelected(this.isDefaultEntityListener);
        boolean enableDefault = !JpaUtil.processEntityMappings(this.myFacet, (Processor<EntityMappings>)((Processor)o -> !(o instanceof com.intellij.javaee.model.xml.persistence.mapping.EntityMappings)));
        this.myDefaultEntityListener.setEnabled(enableDefault);
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myTreeView.getComponent(), "Center");
        this.myPanel.doLayout();
    }

    protected void updateOKAction() {
    }

    public boolean isOKActionEnabled() {
        return true;
    }

    public boolean isDataValid() {
        return this.isOKActionEnabled();
    }

    public void applyEntityListenerBindings() {
        boolean addDefault;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final HashMap<PersistentEntityBase, String> newTargetElements = new HashMap<PersistentEntityBase, String>();
        newTargetElements.putAll(this.targetMembers);
        final ArrayList bindingsToRemove = new ArrayList();
        this.processEntityListenerBindings((PairProcessor<EntityListenerBinding, String>)((PairProcessor)(s, t) -> {
            PersistentEntityBase entityBase = s.getTargetObject();
            if (entityBase != null) {
                String boundEntityName = this.targetMembers.get(entityBase);
                if (!t.equals(boundEntityName)) {
                    bindingsToRemove.add(s);
                } else {
                    newTargetElements.remove(entityBase);
                }
            } else if ("*".equals(s.getEntityBaseClassName()) && !this.myDefaultEntityListener.isSelected()) {
                bindingsToRemove.add(s);
            }
            return true;
        }));
        HashSet<PsiElement> allPsiElements = new HashSet<PsiElement>();
        for (PersistentEntityBase entityBase : this.targetMembers.keySet()) {
            for (PersistentEntityBase object : ModelMergerUtil.getFilteredImplementations((Object)entityBase)) {
                if (object instanceof com.intellij.javaee.model.common.persistence.mapping.EntityBase && object instanceof DomElement) {
                    allPsiElements.add(object.getIdentifyingPsiElement());
                    continue;
                }
                ContainerUtil.addIfNotNull(allPsiElements, (Object)entityBase.getClazz().getValue());
            }
        }
        for (EntityListenerBinding binding : bindingsToRemove) {
            if (binding.getTargetObject() == null) continue;
            allPsiElements.add(binding.getTargetObject().getIdentifyingPsiElement());
        }
        boolean bl = addDefault = this.myDefaultEntityListener.isSelected() && !this.isDefaultEntityListener;
        if (addDefault) {
            JpaUtil.processEntityMappings(this.myFacet, (Processor<EntityMappings>)((Processor)o -> {
                if (o instanceof com.intellij.javaee.model.xml.persistence.mapping.EntityMappings) {
                    allPsiElements.add((PsiElement)o.getContainingFile());
                    return false;
                }
                return true;
            }));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, allPsiElements)) {
            return;
        }
        new WriteCommandAction.Simple(this.myProject, JpaMessages.message((String)"command.apply.entity.listener.bindings.command", (Object[])new Object[0]), new PsiFile[0]){

            protected void run() throws Throwable {
                try {
                    EntityListenerBindingsPanel.this.updateEntityListenerBindings(bindingsToRemove, newTargetElements, addDefault);
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)e.getMessage(), (String)JpaMessages.message((String)"dialog.title.apply.entity.listener.bindings.failed", (Object[])new Object[0])));
                }
            }
        };
    }

    private void updateEntityListenerBindings(ArrayList<EntityListenerBinding> bindingsToRemove, HashMap<PersistentEntityBase, String> newTargetElements, boolean addDefault) throws IncorrectOperationException {
        for (EntityListenerBinding binding : bindingsToRemove) {
            binding.delete();
        }
        EntityListenerBindingsPanel.createEntityListenerXmlMetadata(this.myFacet, this.myEntityListenerClass, newTargetElements, addDefault);
        EntityListenerBindingsPanel.createEntityListenerAnnotations(this.myEntityListenerClass, newTargetElements);
    }

    public static <U extends PersistencePackage, MyFacet extends PersistenceFacet> void createEntityListenerXmlMetadata(MyFacet facet, String entityListenerClassName, Map<PersistentEntityBase, String> memberToEjbNameMap, boolean addDefault) {
        if (addDefault) {
            JpaUtil.processEntityMappings(facet, (Processor<EntityMappings>)((Processor)o -> {
                if (o instanceof com.intellij.javaee.model.xml.persistence.mapping.EntityMappings) {
                    com.intellij.javaee.model.xml.persistence.mapping.EntityMappings entityMappings = (com.intellij.javaee.model.xml.persistence.mapping.EntityMappings)o;
                    com.intellij.javaee.model.xml.persistence.mapping.EntityListener entityListener = entityMappings.getPersistenceUnitMetadata().getPersistenceUnitDefaults().getEntityListeners().addEntityListener();
                    entityListener.getClazz().setStringValue(entityListenerClassName);
                    return false;
                }
                return true;
            }));
        }
        for (Map.Entry<PersistentEntityBase, String> entry : memberToEjbNameMap.entrySet()) {
            PersistentEntityBase member = entry.getKey();
            for (PersistentEntityBase object : ModelMergerUtil.getFilteredImplementations((Object)member)) {
                if (!(object instanceof EntityBase)) continue;
                EntityBase entity = (EntityBase)object;
                com.intellij.javaee.model.xml.persistence.mapping.EntityListener entityListener = entity.getEntityListeners().addEntityListener();
                entityListener.getClazz().setStringValue(entityListenerClassName);
            }
        }
    }

    public static void createEntityListenerAnnotations(String entityListenerClassName, Map<PersistentEntityBase, String> memberToEjbNameMap) throws IncorrectOperationException {
        block0: for (Map.Entry<PersistentEntityBase, String> entry : memberToEjbNameMap.entrySet()) {
            PersistentEntityBase entityBase = entry.getKey();
            PsiClass psiClass = (PsiClass)entityBase.getClazz().getValue();
            if (psiClass == null) continue;
            for (PersistentEntityBase object : ModelMergerUtil.getFilteredImplementations((Object)entityBase)) {
                if (!(object instanceof EntityImpl) && (!(object instanceof DomElement) || object instanceof com.intellij.javaee.model.common.persistence.mapping.EntityBase)) continue;
                EntityListenerBindingsPanel.createEntityListenerAnnotation(psiClass, entityListenerClassName);
                continue block0;
            }
        }
    }

    public static void createEntityListenerAnnotation(PsiClass member, String entityListenerClassName) throws IncorrectOperationException {
        PsiAnnotation curAnnotation = member.getModifierList().findAnnotation("javax.persistence.EntityListeners");
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)member, "javax.persistence.EntityListeners", true, curAnnotation, "value", AnnotationTextUtil.createStringArrayInitializer(Collections.singletonList(entityListenerClassName), null, ".class"), null);
        if (text == null) {
            return;
        }
        PsiAnnotation psiNewAnnotation = JavaPsiFacade.getInstance((Project)member.getProject()).getElementFactory().createAnnotationFromText(text, (PsiElement)member);
        PsiElement element = curAnnotation != null ? curAnnotation.replace((PsiElement)psiNewAnnotation) : member.getModifierList().addAfter((PsiElement)psiNewAnnotation, null);
        JavaCodeStyleManager.getInstance((Project)member.getProject()).shortenClassReferences(element);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.entity.listener.bindings"), (int)0, (int)0, null, null));
        this.myDefaultEntityListener = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.default.entity.listener"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class PersistenceEntityBaseTreeView
    extends JamTreeTableView {
        private final PersistenceFacet myFacet;
        private final Map<PersistentEntityBase, String> targetMembers;

        public PersistenceEntityBaseTreeView(final Project project, PersistenceFacet facet, Map<PersistentEntityBase, String> targetMembers) {
            super(project, new PersistenceFacetNodeDescriptor(facet, null, new JamTreeParameters(false)){

                @Override
                public JamNodeDescriptor[] getChildren() {
                    if (DumbService.isDumb((Project)project)) {
                        return EMPTY_ARRAY;
                    }
                    1 parentNodeDescriptor = this;
                    List nodeDescriptors = (List)PersistenceCommonUtil.mapPersistenceRoles(new ArrayList(), (Project)((PersistenceFacet)this.getElement()).getModule().getProject(), (PersistenceFacet)((PersistenceFacet)this.getElement()), null, role -> {
                        if (role.getPersistentObject() instanceof PersistentEntityBase) {
                            return new PersistentObjectNodeDescriptor<PersistentEntityBase>((PersistentEntityBase)role.getPersistentObject(), (NodeDescriptor)parentNodeDescriptor, this.getParameters());
                        }
                        return null;
                    });
                    return nodeDescriptors.toArray(new JamNodeDescriptor[nodeDescriptors.size()]);
                }
            });
            this.myFacet = facet;
            this.targetMembers = targetMembers;
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing(new Dimension(1, 0));
            this.init();
            new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
        }

        @Override
        protected boolean isShowTree() {
            return !((ArrayList)PersistenceCommonUtil.mapPersistenceRoles(new ArrayList(), (Project)this.myFacet.getModule().getProject(), (PersistenceFacet)this.myFacet, null, persistenceClassRole -> persistenceClassRole.getPersistentObject() instanceof PersistentEntityBase ? (PersistentEntityBase)persistenceClassRole.getPersistentObject() : null)).isEmpty();
        }

        @Override
        @NotNull
        protected String getEmptyPaneText() {
            String string = JpaMessages.message((String)"message.text.no.entity.bases.in.this.module.no.entity.listeners", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/view/EntityListenerBindingsPanel$PersistenceEntityBaseTreeView", "getEmptyPaneText"));
            }
            return string;
        }

        @Override
        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new TreeColumnInfo(JpaMessages.message((String)"column.name.persistence.entity.tree.name", (Object[])new Object[0])), new ColumnInfo<JamNodeDescriptor, Boolean>(JpaMessages.message((String)"column.name.persistence.entity.tree.listen", (Object[])new Object[0])){

                public boolean isCellEditable(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PersistentEntityBase;
                }

                public TableCellEditor getEditor(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PersistentEntityBase ? new BooleanTableCellEditor() : null;
                }

                public TableCellRenderer getRenderer(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PersistentEntityBase ? new BooleanTableCellRenderer() : null;
                }

                public void setValue(JamNodeDescriptor o, Boolean aValue) {
                    String entityBaseClassName = this.getEntityBaseClassNameForNodeDescriptor(o);
                    Object element = o.getElement();
                    assert (element instanceof PersistentEntityBase);
                    PersistentEntityBase entityBase = (PersistentEntityBase)element;
                    if (Boolean.TRUE.equals(aValue)) {
                        targetMembers.put(entityBase, entityBaseClassName);
                    } else {
                        targetMembers.remove(entityBase);
                    }
                }

                public Boolean valueOf(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    if (element instanceof PersistencePackage) {
                        return null;
                    }
                    assert (element instanceof PersistentEntityBase) : element;
                    return targetMembers.containsKey((PersistentEntityBase)element);
                }

                @Nullable
                private String getEntityBaseClassNameForNodeDescriptor(JamNodeDescriptor node) {
                    for (JamNodeDescriptor curNode = node; curNode != null; curNode = (JamNodeDescriptor)curNode.getParentDescriptor()) {
                        Object element = curNode.getElement();
                        if (!(element instanceof PersistentEntityBase)) continue;
                        PersistentEntityBase entityBase = (PersistentEntityBase)element;
                        return entityBase.getClazz().getStringValue();
                    }
                    assert (false);
                    return null;
                }
            }};
        }
    }
}

