/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.createnew;

import com.intellij.CommonBundle;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.util.PathUtils;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.LibrariesNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNode;
import java.io.File;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddNewElementAction<T extends PackageNode>
extends AnAction {
    private final Class<T> nodeClass;

    protected AddNewElementAction(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeClass", "com/intellij/tapestry/intellij/actions/createnew/AddNewElementAction", "<init>"));
        }
        this.nodeClass = nodeClass;
    }

    public void update(AnActionEvent event) {
        DefaultMutableTreeNode element;
        boolean enabled = false;
        Presentation presentation = event.getPresentation();
        Module module = null;
        try {
            module = (Module)event.getDataContext().getData(LangDataKeys.MODULE.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!TapestryUtils.isTapestryModule(module)) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        TapestryProjectViewPane pane = TapestryProjectViewPane.getInstance(module.getProject());
        DefaultMutableTreeNode defaultMutableTreeNode = element = pane != null ? pane.getSelectedNode() : null;
        if (element == null) {
            PsiElement eventPsiElement = (PsiElement)event.getDataContext().getData(CommonDataKeys.PSI_ELEMENT.getName());
            TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
            if (tapestryProject == null) {
                presentation.setEnabled(false);
                presentation.setVisible(false);
                return;
            }
            String aPackage = this.getElementsRootPackage(tapestryProject);
            if (aPackage == null) {
                presentation.setEnabled(false);
                presentation.setVisible(false);
                return;
            }
            PsiPackage eventPackage = IdeaUtils.getPackage(eventPsiElement);
            if (eventPackage != null) {
                PsiPackage elementsRootPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(aPackage);
                if (elementsRootPackage != null && eventPackage.getQualifiedName().startsWith(elementsRootPackage.getQualifiedName()) && TapestryUtils.isTapestryModule(module)) {
                    enabled = true;
                }
            } else {
                if (JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(aPackage) == null) {
                    presentation.setEnabled(false);
                    return;
                }
                WebFacet webFacet = IdeaUtils.getWebFacet(module);
                if (eventPsiElement instanceof PsiDirectory && webFacet != null && WebUtil.isInsideWebRoots((VirtualFile)((PsiDirectory)eventPsiElement).getVirtualFile(), (List)webFacet.getWebRoots())) {
                    enabled = true;
                }
            }
        } else if (element.getUserObject() instanceof PackageNode && (IdeaUtils.findFirstParent(element, this.nodeClass) != null || this.nodeClass.isInstance(element.getUserObject())) && IdeaUtils.findFirstParent(element, LibrariesNode.class) == null) {
            enabled = true;
        }
        presentation.setVisible(true);
        presentation.setEnabled(enabled);
    }

    @Nullable
    protected abstract String getElementsRootPackage(@NotNull TapestryProject var1);

    @Nullable
    protected String getDefaultElementPath(AnActionEvent event, Module module) {
        PsiElement eventPsiElement = (PsiElement)event.getDataContext().getData(CommonDataKeys.PSI_ELEMENT.getName());
        PsiPackage psiPackage = IdeaUtils.getPackage(eventPsiElement);
        String defaultPagePath = "";
        if (psiPackage != null) {
            String eventPackage = psiPackage.getQualifiedName();
            TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
            if (tapestryProject == null) {
                AddNewElementAction.showError();
                return null;
            }
            String basePagesPackage = this.getElementsRootPackage(TapestryModuleSupportLoader.getTapestryProject(module));
            if (basePagesPackage == null) {
                AddNewElementAction.showError();
                return null;
            }
            try {
                defaultPagePath = PathUtils.packageIntoPath(eventPackage.substring(basePagesPackage.length() + 1), true);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (eventPsiElement != null && psiPackage == null) {
            WebFacet webFacet = IdeaUtils.getWebFacet(module);
            WebRoot webRoot = WebUtil.findParentWebRoot((VirtualFile)((PsiDirectory)eventPsiElement).getVirtualFile(), (List)webFacet.getWebRoots());
            defaultPagePath = ((PsiDirectory)eventPsiElement).getVirtualFile().getPath().replaceFirst(webRoot.getFile().getPath(), "") + "/";
            if (defaultPagePath.startsWith(File.separator)) {
                defaultPagePath = defaultPagePath.substring(1);
            }
            if (defaultPagePath.equals("/")) {
                defaultPagePath = "";
            }
        }
        return defaultPagePath;
    }

    protected static Module getModule(AnActionEvent event) {
        return (Module)event.getDataContext().getData(LangDataKeys.MODULE.getName());
    }

    private static void showError() {
        Messages.showErrorDialog((String)"Can't create element. Please check if this module is a valid Tapestry application!", (String)CommonBundle.getErrorTitle());
    }
}

