/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view.nodes;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.AbstractModuleNode;
import com.intellij.tapestry.intellij.view.nodes.LibrariesNode;
import com.intellij.tapestry.intellij.view.nodes.LibraryNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNodesComparator;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class ModuleNode
extends AbstractModuleNode {
    public ModuleNode(@NotNull Module module, AbstractTreeBuilder treeBuilder) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/view/nodes/ModuleNode", "<init>"));
        }
        super(module, treeBuilder);
    }

    @Override
    public SimpleNode[] getChildren() {
        TreeSet<TapestryNode> children = new TreeSet<TapestryNode>(PackageNodesComparator.getInstance());
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)((Module)this.getElement())).getFileIndex();
        moduleFileIndex.iterateContent(virtualfile -> {
            if (virtualfile.isDirectory() && moduleFileIndex.isInSourceContent(virtualfile)) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(virtualfile);
                PsiPackage aPackage = IdeaUtils.getPackage((PsiElement)psiDirectory);
                if (TapestryProjectViewPane.getInstance(this.myProject).isFromBasePackage()) {
                    if (aPackage.getName() != null && aPackage.getQualifiedName().equals(TapestryModuleSupportLoader.getTapestryProject(this._module).getApplicationLibrary().getBasePackage())) {
                        children.add(new LibraryNode(TapestryModuleSupportLoader.getTapestryProject(this._module).getApplicationLibrary(), psiDirectory, this._module, this._treeBuilder));
                    }
                } else if (aPackage.getName() != null && (aPackage.getParentPackage() == null || aPackage.getParentPackage().getName() == null)) {
                    children.add(new PackageNode(PsiManager.getInstance((Project)this.myProject).findDirectory(virtualfile), (Module)this.getElement(), this._treeBuilder));
                }
            }
            return true;
        });
        if (TapestryProjectViewPane.getInstance(this.myProject).isShowLibraries()) {
            children.add(new LibrariesNode(this._module, this._treeBuilder));
        }
        return children.toArray(new TapestryNode[children.size()]);
    }
}

