/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.annotations.NotNull;

public class IconsGeneratedSourcesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/internal/IconsGeneratedSourcesFilter", "isGeneratedSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/internal/IconsGeneratedSourcesFilter", "isGeneratedSource"));
        }
        if (file.getName().endsWith("Icons.java")) {
            return (Boolean)ReadAction.compute(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/internal/IconsGeneratedSourcesFilter", "lambda$isGeneratedSource$0"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/internal/IconsGeneratedSourcesFilter", "lambda$isGeneratedSource$0"));
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile instanceof PsiJavaFile) {
                    for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                        if (!aClass.hasModifierProperty("public")) continue;
                        PsiDocComment comment = aClass.getDocComment();
                        return comment != null && comment.getText().contains("run build/scripts/icons.gant instead");
                    }
                }
                return false;
            });
        }
        return false;
    }
}

