/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.javascript.flex.css.FlexInputFilter;
import com.intellij.javascript.flex.css.FlexStyleIndexInfo;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStyleIndex
extends FileBasedIndexExtension<String, Set<FlexStyleIndexInfo>> {
    public static final ID<String, Set<FlexStyleIndexInfo>> INDEX_ID = ID.create((String)"js.style.index");
    private static final int VERSION = 18;
    private final DataExternalizer<Set<FlexStyleIndexInfo>> myDataExternalizer = new DataExternalizer<Set<FlexStyleIndexInfo>>(){

        public void save(@NotNull DataOutput out, Set<FlexStyleIndexInfo> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/javascript/flex/css/FlexStyleIndex$1", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (FlexStyleIndexInfo info : value) {
                FlexStyleIndex.writeUTF(out, info.getClassOrFileName());
                FlexStyleIndex.writeUTF(out, info.getAttributeName());
                FlexStyleIndex.writeUTF(out, info.getInherit());
                FlexStyleIndex.writeUTF(out, info.getType());
                FlexStyleIndex.writeUTF(out, info.getArrayType());
                FlexStyleIndex.writeUTF(out, info.getFormat());
                FlexStyleIndex.writeUTF(out, info.getEnumeration());
                out.writeBoolean(info.isInClass());
            }
        }

        public Set<FlexStyleIndexInfo> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/javascript/flex/css/FlexStyleIndex$1", "read"));
            }
            int size = DataInputOutputUtil.readINT((DataInput)in);
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            for (int i = 0; i < size; ++i) {
                String className = FlexStyleIndex.readUTF(in);
                assert (className != null);
                String attributeName = FlexStyleIndex.readUTF(in);
                assert (attributeName != null);
                String inherit = FlexStyleIndex.readUTF(in);
                assert (inherit != null);
                String type = FlexStyleIndex.readUTF(in);
                String arrayType = FlexStyleIndex.readUTF(in);
                String format = FlexStyleIndex.readUTF(in);
                String enumeration = FlexStyleIndex.readUTF(in);
                boolean inClass = in.readBoolean();
                result.add(new FlexStyleIndexInfo(className, attributeName, inherit, type, arrayType, format, enumeration, inClass));
            }
            return result;
        }
    };

    @NotNull
    public ID<String, Set<FlexStyleIndexInfo>> getName() {
        ID<String, Set<FlexStyleIndexInfo>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getName"));
        }
        return iD;
    }

    @Nullable
    private static String readUTF(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/javascript/flex/css/FlexStyleIndex", "readUTF"));
        }
        String s = IOUtil.readUTF((DataInput)in);
        return s.length() == 0 ? null : s;
    }

    private static void writeUTF(@NotNull DataOutput out, @Nullable String s) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/javascript/flex/css/FlexStyleIndex", "writeUTF"));
        }
        IOUtil.writeUTF((DataOutput)out, (String)(s != null ? s : ""));
    }

    private static <TKey, TValue> void addElement(Map<TKey, Set<TValue>> map, TKey key, TValue value) {
        LinkedHashSet list = map.get(key);
        if (list == null) {
            list = ContainerUtil.newLinkedHashSet();
            map.put(key, list);
        }
        list.add(value);
    }

    @NotNull
    private static String getQualifiedNameByMxmlFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/FlexStyleIndex", "getQualifiedNameByMxmlFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/css/FlexStyleIndex", "getQualifiedNameByMxmlFile"));
        }
        String name = FileUtil.getNameWithoutExtension((String)file.getName());
        String packageName = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file, (Project)project);
        if (packageName != null && packageName.length() > 0) {
            String string = packageName + "." + name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getQualifiedNameByMxmlFile"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getQualifiedNameByMxmlFile"));
        }
        return string;
    }

    private static void indexMxmlFile(@NotNull XmlFile file, @NotNull VirtualFile virtualFile, final @NotNull Map<String, Set<FlexStyleIndexInfo>> map) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/FlexStyleIndex", "indexMxmlFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javascript/flex/css/FlexStyleIndex", "indexMxmlFile"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/javascript/flex/css/FlexStyleIndex", "indexMxmlFile"));
        }
        XmlTag rootTag = FlexStyleIndex.getRootTag(file);
        if (rootTag != null) {
            final String classQName = FlexStyleIndex.getQualifiedNameByMxmlFile(virtualFile, file.getProject());
            JSResolveUtil.JSInjectedFilesVisitor jsFilesVisitor = new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    FlexStyleIndex.indexAttributes((PsiElement)file, classQName, true, map);
                }
            };
            FlexUtils.processMxmlTags(rootTag, false, jsFilesVisitor);
        }
    }

    @Nullable
    private static XmlTag getRootTag(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document != null) {
            return document.getRootTag();
        }
        return null;
    }

    @NotNull
    public DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent> getIndexer() {
        DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent> dataIndexer = new DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent>(){

            @NotNull
            public Map<String, Set<FlexStyleIndexInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/javascript/flex/css/FlexStyleIndex$3", "map"));
                }
                THashMap map = new THashMap();
                if (JavaScriptSupportLoader.isFlexMxmFile((String)inputData.getFileName())) {
                    PsiFile file = inputData.getPsiFile();
                    VirtualFile virtualFile = inputData.getFile();
                    if (file instanceof XmlFile) {
                        FlexStyleIndex.indexMxmlFile((XmlFile)file, virtualFile, (Map)map);
                    }
                } else {
                    StubTree tree = JSPackageIndex.getStubTree((FileContent)inputData);
                    if (tree != null) {
                        for (StubElement e : tree.getPlainList()) {
                            PsiElement psiElement;
                            if (e instanceof JSClassStub) {
                                psiElement = e.getPsi();
                                if (!(psiElement instanceof JSClass)) continue;
                                String qName = ((JSClass)psiElement).getQualifiedName();
                                FlexStyleIndex.indexAttributes(psiElement, qName, true, (Map)map);
                                continue;
                            }
                            if (!(e instanceof PsiFileStub) || !((psiElement = e.getPsi()) instanceof JSFile)) continue;
                            String name = ((JSFile)psiElement).getName();
                            FlexStyleIndex.indexAttributes(psiElement, name, false, (Map)map);
                        }
                    }
                }
                THashMap tHashMap = map;
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex$3", "map"));
                }
                return tHashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    private static void indexAttributes(PsiElement element, final String classQName, final boolean inClass, final Map<String, Set<FlexStyleIndexInfo>> map) {
        ActionScriptResolveUtil.processMetaAttributesForClass((PsiElement)element, (ActionScriptResolveUtil.MetaDataProcessor)new ActionScriptResolveUtil.MetaDataProcessor(){

            public boolean process(@NotNull JSAttribute jsAttribute) {
                if (jsAttribute == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/javascript/flex/css/FlexStyleIndex$4", "process"));
                }
                String attrName = jsAttribute.getName();
                if (attrName != null && "Style".equals(attrName)) {
                    FlexStyleIndexInfo info;
                    String propertyName;
                    JSAttributeNameValuePair pair = jsAttribute.getValueByName("name");
                    String string = propertyName = pair != null ? pair.getSimpleValue() : null;
                    if (propertyName != null && classQName != null && (info = FlexStyleIndexInfo.create(classQName, propertyName, jsAttribute, inClass)) != null) {
                        FlexStyleIndex.addElement(map, propertyName, info);
                        String classicPropertyName = FlexCssUtil.toClassicForm(propertyName);
                        if (!propertyName.equals(classicPropertyName)) {
                            FlexStyleIndex.addElement(map, classicPropertyName, info);
                        }
                    }
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
                return true;
            }
        }, (boolean)false);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<FlexStyleIndexInfo>> getValueExternalizer() {
        DataExternalizer<Set<FlexStyleIndexInfo>> dataExternalizer = this.myDataExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FlexInputFilter flexInputFilter = FlexInputFilter.getInstance();
        if (flexInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndex", "getInputFilter"));
        }
        return flexInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 18;
    }
}

