/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.AnyXmlElementWithAnyChildrenDescriptor;
import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.javascript.flex.mxml.schema.MxmlLanguageTagsUtil;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationBackedDescriptorImpl
extends BasicXmlAttributeDescriptor
implements Validator<XmlElement>,
AnnotationBackedDescriptor,
XmlElementDescriptorAwareAboutChildren {
    private static final String[] DEFERRED_IMMEDIATE = new String[]{"deferred", "immediate"};
    private static final String[] AUTO_NEVER = new String[]{"auto", "never"};
    private static final String[] E4X_XML = new String[]{"e4x", "xml"};
    private static final String[] TRUE_FALSE = new String[]{"true", "false"};
    private static final String CLEAR_DIRECTIVE = "@Clear()";
    private static final String I_STYLE_CLIENT_CLASS = "mx.styles.IStyleClient";
    private static final String[] COLOR_ALIASES = new String[]{"black", "blue", "green", "gray", "silver", "lime", "olive", "white", "yellow", "maroon", "magenta", "navy", "red", "purple", "teal", "fuchsia", "aqua", "cyan", "halogreen", "haloblue", "haloorange", "halosilver"};
    protected final String name;
    protected final ClassBackedElementDescriptor parentDescriptor;
    protected final boolean predefined;
    protected String type;
    protected String format;
    private boolean myEnumerated;
    private boolean myEnumeratedValuesCaseSensitive = true;
    private String[] myEnumeratedValues;
    private final String arrayElementType;
    @NonNls
    private static final String ENUMERATION_ATTR_NAME = "enumeration";
    @NonNls
    private static final String FORMAT_ATTR_NAME = "format";
    @NonNls
    private static final String TYPE_ATTR_NAME = "type";
    private String percentProxy;
    private boolean myScriptable;
    private boolean myProperty = false;
    private String myAnnotationName;
    @NotNull
    private final OriginatingElementType myOriginatingElementType;
    private boolean myRichTextContent;
    private boolean myCollapseWhiteSpace;
    private final boolean myDeferredInstance;
    private boolean myIsRequired = false;

    protected AnnotationBackedDescriptorImpl(String _name, ClassBackedElementDescriptor _parentDescriptor, boolean _predefined, String _type, String _arrayElementType, boolean deferredInstance, PsiElement originatingElement) {
        this.name = _name;
        this.parentDescriptor = _parentDescriptor;
        this.predefined = _predefined;
        this.type = _type;
        this.arrayElementType = _arrayElementType;
        this.myDeferredInstance = deferredInstance;
        if (originatingElement instanceof JSAttributeNameValuePair) {
            this.myOriginatingElementType = OriginatingElementType.Metadata;
            JSAttribute attribute = (JSAttribute)originatingElement.getParent();
            this.initFromAttribute(attribute);
        } else if (originatingElement instanceof JSAttributeListOwner) {
            this.myOriginatingElementType = OriginatingElementType.VarOrFunction;
            this.myProperty = originatingElement instanceof JSFunction || originatingElement instanceof JSVariable;
            JSAttribute attribute = AnnotationBackedDescriptorImpl.findInspectableAttr(originatingElement);
            this.initFromAttribute(attribute);
            attribute = AnnotationBackedDescriptorImpl.findAttr((JSAttributeListOwner)originatingElement, "PercentProxy");
            if (attribute != null) {
                JSAttributeNameValuePair[] values = attribute.getValues();
                String string = this.percentProxy = values.length > 0 ? values[0].getSimpleValue() : "";
            }
            if (this.type == null) {
                this.type = ClassBackedElementDescriptor.getPropertyType((JSNamedElement)originatingElement);
            }
            this.initFromType();
            this.initRichTextContentAndCollapseWhiteSpace((JSAttributeListOwner)originatingElement);
        } else {
            this.myOriginatingElementType = originatingElement instanceof XmlAttribute && "id".equals(((XmlAttribute)originatingElement).getName()) ? OriginatingElementType.IdAttribute : OriginatingElementType.Other;
        }
        if (this.predefined) {
            if ("itemCreationPolicy".equals(this.name)) {
                this.myEnumerated = true;
                this.myEnumeratedValues = DEFERRED_IMMEDIATE;
            } else if ("itemDestructionPolicy".equals(this.name)) {
                this.myEnumerated = true;
                this.myEnumeratedValues = AUTO_NEVER;
            } else if (FORMAT_ATTR_NAME.equals(this.name) && "XML".equals(this.parentDescriptor.getName())) {
                this.myEnumerated = true;
                this.myEnumeratedValues = E4X_XML;
                this.myEnumeratedValuesCaseSensitive = false;
            } else if ("twoWay".equals(this.name) && "Binding".equals(this.parentDescriptor.getName())) {
                this.myEnumerated = true;
                this.myEnumeratedValues = TRUE_FALSE;
                this.myEnumeratedValuesCaseSensitive = false;
            }
        }
    }

    protected AnnotationBackedDescriptorImpl(String name, ClassBackedElementDescriptor parentDescriptor, boolean predefined, String type, String arrayElementType, PsiElement originatingElement) {
        this(name, parentDescriptor, predefined, type, arrayElementType, false, originatingElement);
    }

    protected AnnotationBackedDescriptorImpl(String _name, ClassBackedElementDescriptor _parentDescriptor, AnnotationBackedDescriptorImpl originalDescriptor, JSNamedElement originatingElement) {
        JSAttribute attribute;
        if (originalDescriptor.myOriginatingElementType != OriginatingElementType.VarOrFunction) {
            Logger.getInstance((String)AnnotationBackedDescriptorImpl.class.getName()).error((Object)originalDescriptor.myOriginatingElementType);
        }
        this.myOriginatingElementType = originalDescriptor.myOriginatingElementType;
        this.name = _name;
        this.parentDescriptor = _parentDescriptor;
        this.predefined = originalDescriptor.predefined;
        this.type = originalDescriptor.type;
        this.arrayElementType = originalDescriptor.arrayElementType;
        this.myEnumerated = originalDescriptor.myEnumerated;
        this.myEnumeratedValues = originalDescriptor.getEnumeratedValues();
        this.myScriptable = originalDescriptor.myScriptable;
        this.percentProxy = originalDescriptor.percentProxy;
        this.type = originalDescriptor.type;
        this.format = originalDescriptor.format;
        this.myAnnotationName = originalDescriptor.myAnnotationName;
        this.myProperty = originalDescriptor.myProperty;
        this.myCollapseWhiteSpace = originalDescriptor.myCollapseWhiteSpace;
        this.myRichTextContent = originalDescriptor.myRichTextContent;
        this.myDeferredInstance = originalDescriptor.myDeferredInstance;
        if (originatingElement instanceof JSFunction) {
            this.initRichTextContentAndCollapseWhiteSpace((JSAttributeListOwner)((JSFunction)originatingElement));
        }
        if (originatingElement instanceof JSAttributeListOwner && (attribute = AnnotationBackedDescriptorImpl.findAttr((JSAttributeListOwner)originatingElement, "PercentProxy")) != null && this.percentProxy == null) {
            JSAttributeNameValuePair[] values = attribute.getValues();
            this.percentProxy = values.length > 0 ? values[0].getSimpleValue() : "";
        }
    }

    private void initRichTextContentAndCollapseWhiteSpace(JSAttributeListOwner attributeListOwner) {
        if (!this.myEnumerated) {
            if (this.contentIsArrayable()) {
                boolean bl = this.myRichTextContent = AnnotationBackedDescriptorImpl.findAttr(attributeListOwner, "RichTextContent") != null;
            }
            if ("String".equals(this.type)) {
                this.myCollapseWhiteSpace = AnnotationBackedDescriptorImpl.findAttr(attributeListOwner, "CollapseWhiteSpace") != null;
            }
        }
    }

    @NonNls
    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    @NotNull
    OriginatingElementType getOriginatingElementType() {
        OriginatingElementType originatingElementType = this.myOriginatingElementType;
        if (originatingElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "getOriginatingElementType"));
        }
        return originatingElementType;
    }

    boolean isPreferredTo(@NotNull AnnotationBackedDescriptorImpl other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "isPreferredTo"));
        }
        assert (Comparing.strEqual((String)this.name, (String)other.name));
        if ("Event".equals(this.myAnnotationName) && !"Event".equals(other.myAnnotationName)) {
            return true;
        }
        return this.myOriginatingElementType != OriginatingElementType.Metadata && other.myOriginatingElementType == OriginatingElementType.Metadata;
    }

    @Nullable
    public PsiElement getDeclaration() {
        JSClass clazz;
        JSClass[] classes;
        boolean b;
        PsiElement parentDescriptorDeclaration;
        final PsiElement[] result = new PsiElement[1];
        PsiElement element = parentDescriptorDeclaration = this.parentDescriptor.getDeclaration();
        if (this.predefined) {
            return element;
        }
        if (this.myOriginatingElementType == OriginatingElementType.IdAttribute) {
            return this.findDeclarationByIdAttributeValue(parentDescriptorDeclaration, (Set<JSClass>)new THashSet());
        }
        while (element instanceof XmlFile) {
            XmlTag rootTag = ((XmlFile)element).getDocument().getRootTag();
            if (!((element = JSResolveUtil.getClassFromTagNameInMxml((PsiElement)rootTag.getFirstChild())) instanceof XmlBackedJSClassImpl)) continue;
            element = element.getParent().getContainingFile();
        }
        JSNamedElement jsClass = (JSNamedElement)element;
        final ClassBackedElementDescriptor.AttributedItemsProcessor itemsProcessor = new ClassBackedElementDescriptor.AttributedItemsProcessor(){

            @Override
            public boolean process(JSNamedElement jsNamedElement, boolean isPackageLocalVisibility) {
                if (AnnotationBackedDescriptorImpl.this.myOriginatingElementType != OriginatingElementType.Metadata && AnnotationBackedDescriptorImpl.this.name.equals(jsNamedElement.getName())) {
                    result[0] = jsNamedElement;
                    return false;
                }
                return true;
            }

            @Override
            public boolean process(JSAttributeNameValuePair pair, String annotationName, boolean included) {
                if (AnnotationBackedDescriptorImpl.this.myOriginatingElementType == OriginatingElementType.Metadata && AnnotationBackedDescriptorImpl.this.name.equals(pair.getSimpleValue()) && included) {
                    result[0] = pair;
                    return false;
                }
                return true;
            }
        };
        boolean bl = b = jsClass == null || ClassBackedElementDescriptor.processAttributes((PsiElement)jsClass, itemsProcessor);
        if (b && jsClass instanceof JSClass && (classes = (clazz = (JSClass)jsClass).getSuperClasses()).length > 0 && clazz.getName().equals(classes[0].getName()) && clazz != classes[0]) {
            b = ClassBackedElementDescriptor.processAttributes((PsiElement)classes[0], itemsProcessor);
        }
        if (b && parentDescriptorDeclaration instanceof XmlFile) {
            JSResolveUtil.JSInjectedFilesVisitor injectedFilesVisitor = new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    ClassBackedElementDescriptor.processAttributes((PsiElement)file, itemsProcessor);
                }
            };
            element = parentDescriptorDeclaration;
            while (element instanceof XmlFile) {
                XmlTag rootTag = ((XmlFile)element).getDocument().getRootTag();
                FlexUtils.processMxmlTags(rootTag, true, injectedFilesVisitor);
                if (result[0] != null) break;
                element = JSResolveUtil.getClassFromTagNameInMxml((PsiElement)rootTag.getFirstChild());
                if (!(element instanceof XmlBackedJSClassImpl)) continue;
                element = element.getParent().getContainingFile();
            }
        }
        return result[0];
    }

    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        for (String s : this.getEnumeratedValues()) {
            if (!Comparing.equal((String)s, (String)value, (boolean)this.myEnumeratedValuesCaseSensitive)) continue;
            return this.getDeclaration();
        }
        return null;
    }

    @Nullable
    private XmlAttributeValue findDeclarationByIdAttributeValue(PsiElement descriptorDeclaration, Set<JSClass> visited) {
        Ref resultRef = new Ref(null);
        if (descriptorDeclaration instanceof XmlFile) {
            XmlBackedJSClass jsClass;
            XmlTag rootTag;
            XmlDocument document = ((XmlFile)descriptorDeclaration).getDocument();
            XmlTag xmlTag = rootTag = document == null ? null : document.getRootTag();
            if (rootTag != null) {
                ClassBackedElementDescriptor.processClassBackedTagsWithIdAttribute(rootTag, (Processor<Pair<XmlAttribute, String>>)((Processor)idAttributeAndItsType -> {
                    XmlAttributeValue xmlAttributeValue = ((XmlAttribute)idAttributeAndItsType.first).getValueElement();
                    if (xmlAttributeValue != null && xmlAttributeValue.getValue().equals(this.name)) {
                        resultRef.set((Object)xmlAttributeValue);
                        return false;
                    }
                    return true;
                }));
            }
            if (resultRef.isNull() && (jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)descriptorDeclaration))) != null) {
                return this.findDeclarationByIdAttributeValueInSuperClass((JSClass)jsClass, visited);
            }
        } else if (descriptorDeclaration instanceof JSClass) {
            return this.findDeclarationByIdAttributeValueInSuperClass((JSClass)descriptorDeclaration, visited);
        }
        return (XmlAttributeValue)resultRef.get();
    }

    @Nullable
    private XmlAttributeValue findDeclarationByIdAttributeValueInSuperClass(@NotNull JSClass jsClass, Set<JSClass> visited) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "findDeclarationByIdAttributeValueInSuperClass"));
        }
        if (!visited.add(jsClass)) {
            return null;
        }
        for (JSClass superClass : jsClass.getSuperClasses()) {
            if (superClass instanceof XmlBackedJSClassImpl) {
                XmlAttributeValue result;
                PsiFile psiFile = superClass.getContainingFile();
                if (!(psiFile instanceof XmlFile) || (result = this.findDeclarationByIdAttributeValue((PsiElement)psiFile, visited)) == null) continue;
                return result;
            }
            return this.findDeclarationByIdAttributeValueInSuperClass(superClass, visited);
        }
        return null;
    }

    public void init(PsiElement element) {
    }

    private void initFromAttribute(JSAttribute attribute) {
        if (attribute == null) {
            return;
        }
        this.myEnumerated = attribute.getValueByName(ENUMERATION_ATTR_NAME) != null;
        JSAttributeNameValuePair pair = attribute.getValueByName(TYPE_ATTR_NAME);
        if (pair != null) {
            this.type = pair.getSimpleValue();
        }
        if ((pair = attribute.getValueByName(FORMAT_ATTR_NAME)) != null) {
            this.format = pair.getSimpleValue();
        }
        this.myAnnotationName = attribute.getName();
        this.myScriptable = "Event".equals(this.myAnnotationName);
        this.initFromType();
    }

    private void initFromType() {
        if ("Boolean".equals(this.type)) {
            this.myEnumerated = true;
        }
        if ("Function".equals(this.type)) {
            this.myScriptable = true;
        }
    }

    public void setRequired(boolean isRequired) {
        this.myIsRequired = isRequired;
    }

    public boolean isRequired() {
        return this.myIsRequired;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return "id".equals(this.name);
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return this.myEnumerated;
    }

    public String[] getEnumeratedValues(@Nullable XmlElement context) {
        if (context instanceof XmlAttribute && !this.myEnumerated && "id".equals(this.name)) {
            String tagName;
            String value = ((XmlAttribute)context).getValue();
            int index = value.indexOf("IntellijIdeaRulezzz ");
            value = index == -1 ? value : value.substring(0, index);
            PsiElement parent = context.getParent();
            String string = tagName = parent instanceof XmlTag ? ((XmlTag)parent).getLocalName() : null;
            if (StringUtil.isNotEmpty((String)tagName)) {
                String[] suggestedIds = AnnotationBackedDescriptorImpl.suggestIdValues(value, tagName);
                return AnnotationBackedDescriptorImpl.makeUnique(suggestedIds, AnnotationBackedDescriptorImpl.getNamedElementsVisibleAt((PsiElement)context));
            }
        }
        return super.getEnumeratedValues(context);
    }

    public String[] getEnumeratedValues() {
        String[] enumerationValues = this.myEnumeratedValues;
        if (enumerationValues == null) {
            enumerationValues = ArrayUtil.EMPTY_STRING_ARRAY;
            if (this.myEnumerated) {
                if ("Boolean".equals(this.type)) {
                    enumerationValues = TRUE_FALSE;
                } else {
                    String simpleValue;
                    JSAttribute inspectableAttr;
                    PsiElement element = this.getDeclaration();
                    JSAttributeNameValuePair pair = null;
                    if (element instanceof JSAttributeNameValuePair) {
                        pair = ((JSAttribute)element.getParent()).getValueByName(ENUMERATION_ATTR_NAME);
                    } else if (element instanceof JSAttributeListOwner && (inspectableAttr = AnnotationBackedDescriptorImpl.findInspectableAttr(element)) != null) {
                        pair = inspectableAttr.getValueByName(ENUMERATION_ATTR_NAME);
                    }
                    if (pair != null && (simpleValue = pair.getSimpleValue()) != null) {
                        StringTokenizer tokenizer = new StringTokenizer(simpleValue, ", ");
                        enumerationValues = new String[tokenizer.countTokens()];
                        int i = 0;
                        while (tokenizer.hasMoreElements()) {
                            enumerationValues[i++] = tokenizer.nextElement();
                        }
                    }
                }
            }
            this.myEnumeratedValues = enumerationValues;
        }
        return enumerationValues;
    }

    @Nullable
    public static JSAttribute findInspectableAttr(PsiElement element) {
        return AnnotationBackedDescriptorImpl.findAttr((JSAttributeListOwner)element, "Inspectable");
    }

    @Nullable
    private static JSAttribute findAttr(JSAttributeListOwner attributeListOwner, @NotNull @NonNls String name) {
        JSAttribute attribute;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "findAttr"));
        }
        JSAttributeList attributeList = attributeListOwner != null ? attributeListOwner.getAttributeList() : null;
        JSAttribute[] attrs = attributeList != null ? attributeList.getAttributesByName(name) : null;
        JSAttribute jSAttribute = attribute = attrs != null && attrs.length > 0 ? attrs[0] : null;
        if (attribute == null && attributeList != null && attributeListOwner instanceof JSFunction && ((JSFunction)attributeListOwner).isSetProperty()) {
            PsiElement grandParent = attributeListOwner.getParent();
            String propName = attributeListOwner.getName();
            if (grandParent instanceof JSClass && propName != null) {
                SinkResolveProcessor processor = new SinkResolveProcessor(propName, (ResultSink)new ResolveResultSink(null, propName));
                processor.setToProcessHierarchy(false);
                grandParent.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), grandParent, (PsiElement)attributeListOwner);
                List elementList = processor.getResults();
                if (elementList != null && elementList.size() == 2) {
                    PsiElement firstElement = (PsiElement)elementList.get(0);
                    PsiElement secondElement = (PsiElement)elementList.get(1);
                    JSAttributeListOwner chosedElement = null;
                    if (firstElement instanceof JSFunction && ((JSFunction)firstElement).isGetProperty()) {
                        chosedElement = (JSAttributeListOwner)firstElement;
                    } else if (secondElement instanceof JSFunction && ((JSFunction)secondElement).isGetProperty()) {
                        chosedElement = (JSAttributeListOwner)secondElement;
                    }
                    if (chosedElement != null) {
                        return AnnotationBackedDescriptorImpl.findAttr(chosedElement, name);
                    }
                }
            }
        }
        return attribute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String validateValue(XmlElement context, String value) {
        PsiElement parent;
        PsiElement psiElement = parent = context instanceof XmlAttributeValue ? context.getParent() : null;
        if (parent instanceof XmlAttribute && "id".equals(((XmlAttribute)parent).getName())) {
            NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
            if (namesValidator.isIdentifier(value, context.getProject())) {
                return null;
            }
            String string = JSBundle.message((String)"invalid.identifier.value", (Object[])new Object[0]);
            return string;
        }
        if (value.indexOf(123) != -1) {
            return null;
        }
        if (value.trim().startsWith("@Resource")) {
            return null;
        }
        if (this.myAnnotationName != null && CLEAR_DIRECTIVE.equals(value)) {
            return AnnotationBackedDescriptorImpl.checkClearDirectiveContext(context);
        }
        if (this.isAllowsPercentage() && value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
        }
        boolean uint = false;
        if ("int".equals(this.type) || (uint = "uint".equals(this.type))) {
            try {
                boolean startWithSharp = value.startsWith("#");
                if (startWithSharp || value.startsWith("0x")) {
                    if (uint) {
                        long l = Long.parseLong(value.substring(startWithSharp ? 1 : 2), 16);
                        if (l < 0L) throw new NumberFormatException("value out of range");
                        if (l <= 0xFFFFFFFFL) return null;
                        throw new NumberFormatException("value out of range");
                    }
                    Integer.parseInt(value.substring(startWithSharp ? 1 : 2), 16);
                    return null;
                }
                if ("Color".equals(this.format) && !StringUtil.isEmptyOrSpaces((String)value) && !Character.isDigit(value.charAt(0))) {
                    return AnnotationBackedDescriptorImpl.checkColorAlias(value);
                }
                if (uint) {
                    long l = Long.parseLong(value);
                    if (l < 0L) throw new NumberFormatException("value out of range");
                    if (l <= 0xFFFFFFFFL) return null;
                    throw new NumberFormatException("value out of range");
                }
                Integer.parseInt(value);
                return null;
            }
            catch (NumberFormatException ex) {
                return FlexBundle.message("flex.invalid.integer.value", new Object[0]);
            }
        }
        if (!"Number".equals(this.type)) return null;
        try {
            boolean startWithSharp;
            if (value != null && ((startWithSharp = value.startsWith("#")) || value.startsWith("0x"))) {
                Integer.parseInt(value.substring(startWithSharp ? 1 : 2), 16);
                return null;
            } else {
                Double.parseDouble(value);
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return FlexBundle.message("flex.invalid.number.value", new Object[0]);
        }
    }

    @Nullable
    private static String checkColorAlias(String s) {
        if (!ArrayUtil.contains((String)s.toLowerCase(), (String[])COLOR_ALIASES)) {
            return FlexBundle.message("unknown.color.error", s);
        }
        return null;
    }

    @Nullable
    private static String checkClearDirectiveContext(XmlElement context) {
        String name;
        XmlElement attributeOrTag;
        Object object = attributeOrTag = context instanceof XmlAttributeValue ? context.getParent() : context;
        String string = attributeOrTag instanceof XmlAttribute ? ((XmlAttribute)attributeOrTag).getName() : (name = attributeOrTag instanceof XmlTag ? ((XmlTag)attributeOrTag).getName() : null);
        if (name != null && !name.contains(".")) {
            return FlexBundle.message("clear.directive.state.specific.error", new Object[0]);
        }
        PsiElement parent = attributeOrTag.getParent();
        XmlElementDescriptor descriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        PsiElement declaration = descriptor instanceof ClassBackedElementDescriptor ? descriptor.getDeclaration() : null;
        PsiElement iStyleClient = ActionScriptClassResolver.findClassByQNameStatic(I_STYLE_CLIENT_CLASS, (PsiElement)attributeOrTag);
        if (!(declaration instanceof JSClass && iStyleClient instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)((JSClass)declaration), (JSClass)((JSClass)iStyleClient)))) {
            return FlexBundle.message("clear.directive.IStyleClient.error", new Object[0]);
        }
        return null;
    }

    @NonNls
    public String getName(PsiElement context) {
        String namespaceByPrefix;
        XmlTag tag = (XmlTag)context;
        if (tag.getName().indexOf("Rulezz") != -1 && (namespaceByPrefix = tag.getPrefixByNamespace(this.parentDescriptor.context.namespace)) != null && !namespaceByPrefix.isEmpty()) {
            return namespaceByPrefix + ":" + this.getName();
        }
        return this.getName();
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "getDependences"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        if (context.getDescriptor() instanceof ClassBackedElementDescriptor) {
            return this.parentDescriptor.getElementsDescriptors(context);
        }
        if (this.arrayElementType != null && ActionScriptClassResolver.findClassByQNameStatic(this.arrayElementType, (PsiElement)context) != null) {
            return this.parentDescriptor.getElementDescriptorsInheritedFromGivenType(this.arrayElementType);
        }
        if (this.type != null && ClassBackedElementDescriptor.isAdequateType(this.type)) {
            return this.parentDescriptor.getElementDescriptorsInheritedFromGivenType(this.type);
        }
        if ("IFactory".equals(ClassBackedElementDescriptor.className(this.type))) {
            return EMPTY_ARRAY;
        }
        return this.parentDescriptor.context.getDescriptorsWithAllowedDeclaration();
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        PsiElement element;
        XmlNSDescriptor nsdescriptor;
        if (MxmlJSClass.isTagThatAllowsAnyXmlContent(contextTag)) {
            return new AnyXmlElementWithAnyChildrenDescriptor();
        }
        String namespace = childTag.getNamespace();
        XmlElementDescriptor descriptor = !ClassBackedElementDescriptor.sameNs(namespace, this.parentDescriptor.context.namespace) ? ((nsdescriptor = childTag.getNSDescriptor(namespace, true)) != null ? nsdescriptor.getElementDescriptor(childTag) : null) : this.parentDescriptor.context.getElementDescriptor(childTag.getLocalName(), childTag);
        if (this.arrayElementType != null) {
            if (descriptor == null || AnnotationBackedDescriptorImpl.isVectorType(this.type) && AnnotationBackedDescriptorImpl.isVectorDescriptor(descriptor) || "Array".equals(this.type) && AnnotationBackedDescriptorImpl.isArrayDescriptor(descriptor) || ActionScriptClassResolver.findClassByQNameStatic(this.arrayElementType, (PsiElement)childTag) == null) {
                return descriptor;
            }
            return ClassBackedElementDescriptor.checkValidDescriptorAccordingToType(this.arrayElementType, descriptor);
        }
        if (this.type != null && ClassBackedElementDescriptor.isAdequateType(this.type)) {
            return ClassBackedElementDescriptor.checkValidDescriptorAccordingToType(this.type, descriptor);
        }
        if (!(!"IFactory".equals(ClassBackedElementDescriptor.className(this.type)) || "Component".equals(childTag.getLocalName()) && JavaScriptSupportLoader.isLanguageNamespace((String)childTag.getNamespace()))) {
            return null;
        }
        if (descriptor == null && (element = this.getDeclaration()) instanceof JSNamedElement) {
            element = new ClassBackedElementDescriptor(ClassBackedElementDescriptor.getPropertyType((JSNamedElement)element), this.parentDescriptor.context, this.parentDescriptor.project, true).getDeclaration();
            return this.parentDescriptor.getClassIfDynamic(childTag.getLocalName(), element);
        }
        return descriptor;
    }

    private static boolean isVectorType(String type) {
        return type != null && (type.equals("Vector") || type.startsWith("Vector.<"));
    }

    private static boolean isVectorDescriptor(XmlElementDescriptor descriptor) {
        return descriptor instanceof ClassBackedElementDescriptor && "Vector".equals(descriptor.getName()) && "http://ns.adobe.com/mxml/2009".equals(((ClassBackedElementDescriptor)descriptor).context.namespace);
    }

    private static boolean isArrayDescriptor(XmlElementDescriptor descriptor) {
        return descriptor instanceof ClassBackedElementDescriptor && "Array".equals(descriptor.getName()) && "http://ns.adobe.com/mxml/2009".equals(((ClassBackedElementDescriptor)descriptor).context.namespace);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return XmlAttributeDescriptor.EMPTY;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        return ClassBackedElementDescriptor.isPrivateAttribute(attributeName, context) ? new AnyXmlAttributeDescriptor(attributeName) : null;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    public void validate(@NotNull XmlElement context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "validate"));
        }
        if (context instanceof XmlTag && FlexSdkUtils.isFlex4Sdk(FlexUtils.getSdkForActiveBC(this.parentDescriptor.context.module))) {
            MxmlLanguageTagsUtil.checkFlex4Attributes((XmlTag)context, host, false);
        }
        if (this.predefined) {
            return;
        }
        String value = context instanceof XmlTag ? ((XmlTag)context).getValue().getTrimmedText() : ((XmlAttribute)context).getDisplayValue();
        String message = this.validateValue(context, value);
        if (message != null) {
            XmlText[] textElements;
            XmlElement errorElement = context;
            if (context instanceof XmlTag && (textElements = ((XmlTag)context).getValue().getTextElements()).length == 1 && !StringUtil.isEmptyOrSpaces((String)textElements[0].getText())) {
                errorElement = textElements[0];
            }
            host.addMessage((PsiElement)errorElement, message, Validator.ValidationHost.ErrorType.ERROR);
        }
        if (context instanceof XmlTag && "states".equals(((XmlTag)context).getLocalName()) && FlexUtils.isMxmlNs(((XmlTag)context).getNamespace())) {
            XmlTag[] tags = ((XmlTag)context).findSubTags("State", ((XmlTag)context).getNamespace());
            XmlUtil.doDuplicationCheckForElements((PsiElement[])tags, new HashMap(tags.length), (XmlUtil.DuplicationInfoProvider)new XmlUtil.DuplicationInfoProvider<XmlTag>(){

                public String getName(@NotNull XmlTag xmlTag) {
                    if (xmlTag == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getName"));
                    }
                    return xmlTag.getAttributeValue("name");
                }

                @NotNull
                public String getNameKey(@NotNull XmlTag xmlTag, @NotNull String name) {
                    if (xmlTag == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getNameKey"));
                    }
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getNameKey"));
                    }
                    String string = this.getName(xmlTag);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getNameKey"));
                    }
                    return string;
                }

                @NotNull
                public PsiElement getNodeForMessage(@NotNull XmlTag xmlTag) {
                    if (xmlTag == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getNodeForMessage"));
                    }
                    XmlAttributeValue xmlAttributeValue = xmlTag.getAttribute("name").getValueElement();
                    if (xmlAttributeValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$3", "getNodeForMessage"));
                    }
                    return xmlAttributeValue;
                }
            }, (Validator.ValidationHost)host);
        }
    }

    public boolean requiresCdataBracesInContext(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "requiresCdataBracesInContext"));
        }
        return this.myScriptable;
    }

    public String getType() {
        return this.type;
    }

    public String getArrayType() {
        return this.arrayElementType;
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }

    public String getTypeName() {
        return this.myProperty ? "Function" : this.myAnnotationName;
    }

    public Icon getIcon() {
        if (this.myProperty) {
            return PlatformIcons.PROPERTY_ICON;
        }
        if (this.myAnnotationName == null) {
            return null;
        }
        if (this.myAnnotationName.equals("Event")) {
            return PlatformIcons.EXCEPTION_CLASS_ICON;
        }
        if (this.myAnnotationName.equals("Style")) {
            return AllIcons.FileTypes.Css;
        }
        if (this.myAnnotationName.equals("Effect")) {
            return AllIcons.Actions.Lightning;
        }
        return null;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public boolean isAllowsPercentage() {
        return this.percentProxy != null;
    }

    public String getPercentProxy() {
        return this.percentProxy;
    }

    public boolean isStyle() {
        return this.myAnnotationName != null && !this.myScriptable && this.myAnnotationName.equals("Style");
    }

    public boolean isRichTextContent() {
        return this.myRichTextContent;
    }

    public boolean isCollapseWhiteSpace() {
        return this.myCollapseWhiteSpace;
    }

    public boolean isDeferredInstance() {
        return this.myDeferredInstance;
    }

    public boolean contentIsArrayable() {
        return this.type != null && (this.type.equals("Array") || this.type.equals("Object") || this.type.equals("*"));
    }

    public static String[] suggestIdValues(String value, String type) {
        String[] typeParts = AnnotationBackedDescriptorImpl.getTypeParts(type);
        String[] result = new String[typeParts.length];
        for (int i = 0; i < result.length; ++i) {
            String s;
            int j;
            String lowercasedStart = AnnotationBackedDescriptorImpl.lowercaseStart(typeParts[i]);
            if (value.isEmpty() || lowercasedStart.startsWith(value)) {
                result[i] = lowercasedStart;
                continue;
            }
            for (j = 0; j < value.length() && !typeParts[i].startsWith(s = value.substring(j)); ++j) {
            }
            int commonTextLength = value.length() - j;
            result[i] = value.substring(0, value.length() - commonTextLength) + typeParts[i];
        }
        return result;
    }

    private static String[] getTypeParts(String type) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(Character.toUpperCase(type.charAt(0)) + (type.length() > 1 ? type.substring(1) : ""));
        for (int i = 1; i < type.length() - 1; ++i) {
            if (!Character.isUpperCase(type.charAt(i)) || Character.isUpperCase(type.charAt(i + 1))) continue;
            result.add(type.substring(i));
        }
        return result.toArray(new String[result.size()]);
    }

    private static String lowercaseStart(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isUpperCase(s.charAt(i)); ++i) {
        }
        i = i <= 1 ? 1 : (i == s.length() ? i : i - 1);
        return s.substring(0, i).toLowerCase() + s.substring(i);
    }

    private static Set<String> getNamedElementsVisibleAt(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl", "getNamedElementsVisibleAt"));
        }
        HashSet names = new HashSet();
        ResolveProcessor processor = new ResolveProcessor(null, (Set)names){
            final /* synthetic */ Set val$names;
            {
                this.val$names = set;
                super(arg0);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$4", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/flex/mxml/schema/AnnotationBackedDescriptorImpl$4", "execute"));
                }
                if (element instanceof JSNamedElementBase) {
                    this.val$names.add(((JSNamedElementBase)element).getName());
                }
                return true;
            }
        };
        processor.setLocalResolve(true);
        JSResolveUtil.treeWalkUp((JSResolveProcessor)processor, (PsiElement)context, (PsiElement)context.getParent(), (PsiElement)context);
        return names;
    }

    private static String[] makeUnique(String[] names, Set<String> existingNames) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int postfix = 2;
            while (existingNames.contains(name)) {
                name = names[i] + postfix++;
            }
            names[i] = name;
        }
        return names;
    }

    static enum OriginatingElementType {
        Metadata,
        VarOrFunction,
        IdAttribute,
        Other;

    }
}

