/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.run.FlashRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;

public class FlexImplicitUsageProvider
implements ImplicitUsageProvider,
Condition<PsiElement> {
    public boolean isImplicitUsage(PsiElement element) {
        JSParameter[] params;
        JSFunction function;
        if (element instanceof XmlAttribute && ((XmlAttribute)element).isNamespaceDeclaration() && JavaScriptSupportLoader.isLanguageNamespace((String)((XmlAttribute)element).getValue())) {
            return true;
        }
        if (element instanceof JSClass) {
            JSClass clazz = (JSClass)element;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
            if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
                return false;
            }
            if (FlashRunConfigurationProducer.isAcceptedMainClass(clazz, module)) {
                return true;
            }
            if (ActionScriptClassResolver.isParentClass(clazz, "mx.modules.ModuleBase")) {
                return true;
            }
            FlexUnitSupport flexUnitSupport = FlexUnitSupport.getSupport(module);
            if (flexUnitSupport != null && flexUnitSupport.isTestClass(clazz, true)) {
                return true;
            }
        } else if (element instanceof JSFunction) {
            if (FlexImplicitUsageProvider.isTestMethod((JSFunction)element)) {
                return true;
            }
            if (FlexImplicitUsageProvider.isAnnotatedByUnknownAttribute((JSAttributeListOwner)element)) {
                return true;
            }
        } else if (element instanceof JSVariable) {
            JSAttributeList varAttrList;
            if (FlexImplicitUsageProvider.isAnnotatedByUnknownAttribute((JSAttributeListOwner)element)) {
                return true;
            }
            if (JSResolveUtil.findParent((PsiElement)element) instanceof JSClass && (varAttrList = ((JSVariable)element).getAttributeList()) != null && varAttrList.findAttributeByName("Embed") != null) {
                return true;
            }
        }
        if (element instanceof JSParameter && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class)) != null && (params = function.getParameterVariables()).length == 1 && element == params[0]) {
            String type = ((JSParameter)element).getTypeString();
            if (type != null) {
                type = JSImportHandlingUtil.resolveTypeName((String)type, (PsiElement)element);
            }
            if (type != null) {
                if ("flash.events.Event".equals(type) || "starling.events.Event".equals(type)) {
                    return true;
                }
                boolean b = JSResolveUtil.processHierarchy((String)type, (PsiFile)element.getContainingFile(), jsClass -> !"flash.events.Event".equals(jsClass.getQualifiedName()) && !"starling.events.Event".equals(jsClass.getQualifiedName()), (boolean)false);
                if (!b) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isTestMethod(JSFunction function) {
        Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)function);
        FlexUnitSupport flexUnitSupport = FlexUnitSupport.getSupport(moduleForPsiElement);
        return flexUnitSupport != null && flexUnitSupport.isTestMethod(function);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }

    public boolean value(PsiElement psiNamedElement) {
        if (psiNamedElement instanceof JSFunction) {
            if (FlexImplicitUsageProvider.isTestMethod((JSFunction)psiNamedElement)) {
                return true;
            }
            if (FlexImplicitUsageProvider.isAnnotatedByUnknownAttribute((JSAttributeListOwner)psiNamedElement)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAnnotatedByUnknownAttribute(JSAttributeListOwner namedElement) {
        JSAttributeList attributeList = namedElement.getAttributeList();
        if (attributeList != null) {
            JSAttribute[] attributes;
            for (JSAttribute a : attributes = attributeList.getAttributes()) {
                if ("Deprecated".equals(a.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

