/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexBuildTargetType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.lang.javascript.flex.build.FlexResourceBuildTargetScopeProvider;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class FlexBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static final Logger LOG = Logger.getInstance((String)FlexBuildTargetScopeProvider.class.getName());

    static Collection<Pair<Module, FlexBuildConfiguration>> getModulesAndBCsToCompile(CompileScope scope) throws ConfigurationException {
        HashSet<Pair<Module, FlexBuildConfiguration>> result;
        block5: {
            block6: {
                RunConfiguration runConfiguration;
                block4: {
                    result = new HashSet<Pair<Module, FlexBuildConfiguration>>();
                    Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile = FlexResourceBuildTargetScopeProvider.getBCsToCompileForPackaging(scope);
                    runConfiguration = CompileStepBeforeRun.getRunConfiguration((CompileScope)scope);
                    if (modulesAndBCsToCompile == null) break block4;
                    for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCsToCompile) {
                        if (((FlexBuildConfiguration)moduleAndBC.second).isSkipCompile()) continue;
                        FlexBuildConfiguration bcWithForcedDebugStatus = FlexBuildTargetScopeProvider.forceDebugStatus(((Module)moduleAndBC.first).getProject(), (FlexBuildConfiguration)moduleAndBC.second);
                        result.add((Pair<Module, FlexBuildConfiguration>)Pair.create((Object)moduleAndBC.first, (Object)bcWithForcedDebugStatus));
                        FlexBuildTargetScopeProvider.appendBCDependencies(result, (Module)moduleAndBC.first, (FlexBuildConfiguration)moduleAndBC.second);
                    }
                    break block5;
                }
                if (!(runConfiguration instanceof FlashRunConfiguration) && !(runConfiguration instanceof FlexUnitRunConfiguration)) break block6;
                BCBasedRunnerParameters params = runConfiguration instanceof FlashRunConfiguration ? ((FlashRunConfiguration)runConfiguration).getRunnerParameters() : ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters();
                Ref exceptionRef = new Ref();
                Pair moduleAndBC = (Pair)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
                    try {
                        return params.checkAndGetModuleAndBC(runConfiguration.getProject());
                    }
                    catch (RuntimeConfigurationError e) {
                        exceptionRef.set((Object)e);
                        return null;
                    }
                }));
                if (!exceptionRef.isNull()) {
                    throw new ConfigurationException(((RuntimeConfigurationError)((Object)exceptionRef.get())).getMessage(), FlexBundle.message("run.configuration.0", runConfiguration.getName()));
                }
                if (((FlexBuildConfiguration)moduleAndBC.second).isSkipCompile()) break block5;
                result.add((Pair<Module, FlexBuildConfiguration>)moduleAndBC);
                FlexBuildTargetScopeProvider.appendBCDependencies(result, (Module)moduleAndBC.first, (FlexBuildConfiguration)moduleAndBC.second);
                break block5;
            }
            for (Module module : scope.getAffectedModules()) {
                if (module.isDisposed() || ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
                for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                    if (bc.isSkipCompile()) continue;
                    result.add((Pair<Module, FlexBuildConfiguration>)Pair.create((Object)module, (Object)bc));
                }
            }
        }
        return result;
    }

    private static FlexBuildConfiguration forceDebugStatus(Project project, FlexBuildConfiguration bc) {
        boolean debug = FlexBuildTargetScopeProvider.getForcedDebugStatus(project, bc);
        ModifiableFlexBuildConfiguration result = Factory.getCopy(bc);
        String additionalOptions = FlexCommonUtils.removeOptions((String)bc.getCompilerOptions().getAdditionalOptions(), (String[])new String[]{"debug", "compiler.debug"});
        result.getCompilerOptions().setAdditionalOptions(additionalOptions + " -debug=" + String.valueOf(debug));
        return result;
    }

    public static boolean getForcedDebugStatus(Project project, FlexBuildConfiguration bc) {
        boolean debug;
        if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            AirPackageProjectParameters params = AirPackageProjectParameters.getInstance(project);
            debug = bc.getAndroidPackagingOptions().isEnabled() ? params.androidPackageType != AirPackageProjectParameters.AndroidPackageType.Release : params.iosPackageType == AirPackageProjectParameters.IOSPackageType.DebugOverNetwork;
        } else {
            debug = false;
        }
        return debug;
    }

    private static void appendBCDependencies(Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs, Module module, FlexBuildConfiguration bc) throws ConfigurationException {
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            FlexBuildConfiguration dependencyBC;
            if (!(entry instanceof BuildConfigurationEntry)) continue;
            BuildConfigurationEntry bcEntry = (BuildConfigurationEntry)entry;
            Module dependencyModule = bcEntry.findModule();
            FlexBuildConfiguration flexBuildConfiguration = dependencyBC = dependencyModule == null ? null : bcEntry.findBuildConfiguration();
            if (dependencyModule == null || dependencyBC == null) {
                throw new ConfigurationException(FlexBundle.message("bc.dependency.does.not.exist", bcEntry.getBcName(), bcEntry.getModuleName(), bc.getName(), module.getName()));
            }
            Pair dependencyModuleAndBC = Pair.create((Object)dependencyModule, (Object)dependencyBC);
            if (dependencyBC.isSkipCompile() || !modulesAndBCs.add((Pair<Module, FlexBuildConfiguration>)dependencyModuleAndBC)) continue;
            FlexBuildTargetScopeProvider.appendBCDependencies(modulesAndBCs, dependencyModule, dependencyBC);
        }
    }

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull CompilerFilter filter, @NotNull Project project, boolean forceBuild) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/lang/javascript/flex/build/FlexBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/flex/build/FlexBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/build/FlexBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        RunConfiguration runConfiguration = CompileStepBeforeRun.getRunConfiguration((CompileScope)baseScope);
        Collection<Pair<Module, FlexBuildConfiguration>> bcsToCompileForPackaging = FlexResourceBuildTargetScopeProvider.getBCsToCompileForPackaging(baseScope);
        ArrayList<String> targetIds = new ArrayList<String>();
        try {
            for (Pair<Module, FlexBuildConfiguration> moduleAndBC : FlexBuildTargetScopeProvider.getModulesAndBCsToCompile(baseScope)) {
                Module module = (Module)moduleAndBC.first;
                FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
                if (bcsToCompileForPackaging != null && FlexBuildTargetScopeProvider.contains(bcsToCompileForPackaging, module, bc)) {
                    boolean forcedDebugStatus = FlexBuildTargetScopeProvider.getForcedDebugStatus(project, bc);
                    targetIds.add(FlexCommonUtils.getBuildTargetId((String)module.getName(), (String)bc.getName(), (Boolean)forcedDebugStatus));
                    continue;
                }
                if (bc.isTempBCForCompilation()) {
                    LOG.assertTrue(runConfiguration instanceof FlashRunConfiguration || runConfiguration instanceof FlexUnitRunConfiguration, (Object)bc.getName());
                    BCBasedRunnerParameters params = runConfiguration instanceof FlashRunConfiguration ? ((FlashRunConfiguration)runConfiguration).getRunnerParameters() : ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters();
                    LOG.assertTrue(params.getModuleName().equals(module.getName()), (Object)("Module name in run config: " + params.getModuleName() + ", expected: " + module.getName()));
                    LOG.assertTrue(params.getBCName().equals(bc.getName()), (Object)("BC name in run config: " + params.getBCName() + ", expected: " + bc.getName()));
                    targetIds.add(FlexCommonUtils.getBuildTargetIdForRunConfig((String)runConfiguration.getType().getId(), (String)runConfiguration.getName()));
                    continue;
                }
                targetIds.add(FlexCommonUtils.getBuildTargetId((String)module.getName(), (String)bc.getName(), null));
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
        if (targetIds.isEmpty()) {
            List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexBuildTargetScopeProvider", "getBuildTargetScopes"));
            }
            return list;
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.singletonList(CmdlineProtoUtil.createTargetsScope((String)FlexBuildTargetType.INSTANCE.getTypeId(), targetIds, (boolean)forceBuild));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        return list;
    }

    private static boolean contains(Collection<Pair<Module, FlexBuildConfiguration>> bcs, Module module, FlexBuildConfiguration bc) {
        for (Pair<Module, FlexBuildConfiguration> pair : bcs) {
            if (!((Module)pair.first).getName().equals(module.getName()) || !((FlexBuildConfiguration)pair.second).getName().equals(bc.getName())) continue;
            return true;
        }
        return false;
    }
}

