/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.BuiltInFlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.CompilerMessagesBuffer;
import com.intellij.lang.javascript.flex.build.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerDependenciesCache;
import com.intellij.lang.javascript.flex.build.ValidateFlashConfigurationsPrecompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitAfterCompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitPrecompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationChangeListener;
import com.intellij.lang.javascript.flex.projectStructure.ui.ActiveBuildConfigurationWidget;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringTokenizer;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompilerHandler
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)FlexCompilerHandler.class.getName());
    private final FlexCompilerDependenciesCache myCompilerDependenciesCache;
    private BuiltInFlexCompilerHandler myBuiltInFlexCompilerHandler;
    private final TObjectIntHashMap<String> commandToIdMap = new TObjectIntHashMap();
    private final Map<FlexBuildConfiguration.Type, ModuleOrFacetCompileCache> myCompileCache = new EnumMap<FlexBuildConfiguration.Type, ModuleOrFacetCompileCache>(FlexBuildConfiguration.Type.class);
    @NonNls
    private static final String FCSH_ASSIGNED_MARKER = "fcsh: Assigned ";
    private boolean mySavingConfigOurselves;
    private boolean myRequestedQuit;
    public static Key<FlexBuildConfiguration> OVERRIDE_BUILD_CONFIG = Key.create((String)"OVERRIDE_FLEX_BUILD_CONFIG");
    private ActiveBuildConfigurationWidget myWidget;
    private String myLastCompilationMessages;
    private Process process;
    private OutputStream is;
    private InputStreamReader out;
    private LineNumberReader err;
    private final char[] buf = new char[8192];
    private volatile boolean myCancelledReadErrStream;
    private final Alarm myReadErrStreamAlarm;

    public String getLastCompilationMessages() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myLastCompilationMessages;
    }

    public void setLastCompilationMessages(String lastCompilationMessages) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myLastCompilationMessages = lastCompilationMessages;
    }

    public FlexCompilerHandler(final Project project) {
        super(project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                FlexCompilerHandler.this.quitCompilerShell();
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$2", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$2", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$2", "modulesRenamed"));
                }
                for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    if (runConfiguration instanceof FlashRunConfiguration) {
                        ((FlashRunConfiguration)runConfiguration).getRunnerParameters().handleModulesRename(modules, oldNameProvider);
                        continue;
                    }
                    if (!(runConfiguration instanceof FlexUnitRunConfiguration)) continue;
                    ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters().handleModulesRename(modules, oldNameProvider);
                }
            }
        });
        connection.subscribe(FlexBuildConfigurationChangeListener.TOPIC, (Object)new FlexBuildConfigurationChangeListener(){

            @Override
            public void buildConfigurationsRenamed(Map<Pair<String, String>, String> renames) {
                for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    if (runConfiguration instanceof FlashRunConfiguration) {
                        ((FlashRunConfiguration)runConfiguration).getRunnerParameters().handleBuildConfigurationsRename(renames);
                        continue;
                    }
                    if (!(runConfiguration instanceof FlexUnitRunConfiguration)) continue;
                    ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters().handleBuildConfigurationsRename(renames);
                }
            }
        });
        this.myCompilerDependenciesCache = new FlexCompilerDependenciesCache(project);
        final MyVirtualFileListener myFileListener = new MyVirtualFileListener();
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)myFileListener);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)myFileListener);
            }
        });
        this.myReadErrStreamAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public FlexCompilerDependenciesCache getCompilerDependenciesCache() {
        return this.myCompilerDependenciesCache;
    }

    public BuiltInFlexCompilerHandler getBuiltInFlexCompilerHandler() {
        if (this.myBuiltInFlexCompilerHandler == null) {
            this.myBuiltInFlexCompilerHandler = new BuiltInFlexCompilerHandler(this.myProject);
        }
        return this.myBuiltInFlexCompilerHandler;
    }

    private ModuleOrFacetCompileCache getCache(FlexBuildConfiguration.Type type) {
        ModuleOrFacetCompileCache cache = this.myCompileCache.get((Object)type);
        if (cache == null) {
            cache = new ModuleOrFacetCompileCache();
            this.myCompileCache.put(type, cache);
        }
        return cache;
    }

    @NotNull
    public String getComponentName() {
        if ("FlexCompilerHandler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler", "getComponentName"));
        }
        return "FlexCompilerHandler";
    }

    public static FlexCompilerHandler getInstance(Project project) {
        return (FlexCompilerHandler)((Object)project.getComponent(FlexCompilerHandler.class));
    }

    public void projectOpened() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        if (compilerManager != null) {
            compilerManager.addBeforeTask((CompileTask)new ValidateFlashConfigurationsPrecompileTask());
            compilerManager.addBeforeTask((CompileTask)new FlexUnitPrecompileTask(this.myProject));
            compilerManager.addAfterTask((CompileTask)new FlexUnitAfterCompileTask());
            compilerManager.setValidationEnabled((ModuleType)FlexModuleType.getInstance(), false);
        }
        this.myWidget = new ActiveBuildConfigurationWidget(this.myProject);
    }

    public void projectClosed() {
        if (this.myBuiltInFlexCompilerHandler != null) {
            this.myBuiltInFlexCompilerHandler.stopCompilerProcess();
        }
        this.quitCompilerShell();
        this.myCompilerDependenciesCache.clear();
        FlexCommonUtils.deleteTempFlexConfigFiles((String)this.myProject.getName());
        FlexCompilationUtils.deleteUnzippedANEFiles();
        this.myWidget.destroy();
    }

    public void quitCompilerShell() {
        this.doQuit();
        this.clearFcshRelatedCache();
    }

    private void doQuit() {
        if (!this.processIsAlive()) {
            return;
        }
        this.myRequestedQuit = true;
        try {
            this.sendCommand("quit", new CompilerMessagesBuffer(null, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clearFcshRelatedCache() {
        for (ModuleOrFacetCompileCache compileCache : this.myCompileCache.values()) {
            compileCache.moduleOrFacetToAutoGeneratedConfig.clear();
            compileCache.moduleOrFacetToCommand.clear();
            compileCache.configFileToTimestamp.clear();
        }
        this.commandToIdMap.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compileFlexModuleOrAllFlexFacets(Module module, CompileContext context) throws IOException {
        FlexBuildConfiguration overriddenConfig = (FlexBuildConfiguration)context.getUserData(OVERRIDE_BUILD_CONFIG);
        if (overriddenConfig != null && module == null) {
            Pair validationResultWithMessage = Pair.create((Object)true, null);
            if (!((Boolean)validationResultWithMessage.first).booleanValue()) {
                if (validationResultWithMessage.second == null) return;
                context.addMessage(CompilerMessageCategory.ERROR, (String)validationResultWithMessage.second, null, -1, -1);
                return;
            }
            this.compileModuleOrFacet(module, context, overriddenConfig, false);
            return;
        } else {
            boolean nothingChangedSincePreviousCompilation = false;
            if (ModuleType.get((Module)module) instanceof FlexModuleType) {
                Pair<Boolean, List<VirtualFile>> compilationResult = this.compileModuleOrFacet(module, context, null, false);
                if (((Boolean)compilationResult.first).booleanValue() && ((List)compilationResult.second).isEmpty()) return;
            }
            boolean wasFailure = false;
            ArrayList allConfigFiles = new ArrayList();
            if (!wasFailure && allConfigFiles.isEmpty()) return;
        }
    }

    private Pair<Boolean, List<VirtualFile>> compileModuleOrFacet(Module module, CompileContext context, @NotNull FlexBuildConfiguration config, boolean nothingChangedSincePreviousCompilation) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler", "compileModuleOrFacet"));
        }
        if (context.getProgressIndicator().isCanceled()) {
            return Pair.create((Object)false, Collections.emptyList());
        }
        if (!config.DO_BUILD) {
            return Pair.create((Object)true, Collections.emptyList());
        }
        if (context.isMake() && nothingChangedSincePreviousCompilation) {
            context.addMessage(CompilerMessageCategory.STATISTICS, FlexBundle.message("compilation.skipped.because.nothing.changed.in", module.getName()), null, -1, -1);
            return Pair.create((Object)true, Collections.emptyList());
        }
        context.getProgressIndicator().setText(FlexBundle.message("compiling.module", module.getName()));
        Module moduleOrFacet = module;
        ModuleOrFacetCompileCache compileCache = this.getCache(config.getType());
        if (!context.isMake()) {
            this.dropIncrementalCompilation(moduleOrFacet, compileCache);
        }
        Sdk flexSdk = FlexUtils.getSdkForActiveBC(module);
        assert (flexSdk != null);
        List<VirtualFile> configFiles = Collections.emptyList();
        if (FlexCompilerHandler.updateTimestamps(configFiles, compileCache, moduleOrFacet)) {
            this.dropIncrementalCompilation(moduleOrFacet, compileCache);
        }
        this.launchFcshIfNeeded(context, flexSdk);
        boolean compilationSuccessful = true;
        for (String string : config.CSS_FILES_LIST) {
        }
        String command = this.buildCommand(configFiles, config, flexSdk);
        String s = (String)compileCache.moduleOrFacetToCommand.get((Object)moduleOrFacet);
        int previousCommandId = this.commandToIdMap.get((Object)command);
        if (!config.USE_CUSTOM_CONFIG_FILE) {
            FlexCompilationUtils.ensureOutputFileWritable(this.myProject, "config.getOutputFileFullPath()");
        }
        if (s == null || !s.equals(command)) {
            if (s != null && previousCommandId > 0) {
                this.sendCommand("clear " + previousCommandId, new CompilerMessagesBuffer(context, false));
                this.commandToIdMap.remove((Object)command);
            }
            compileCache.moduleOrFacetToCommand.put((Object)moduleOrFacet, (Object)command);
            compilationSuccessful &= this.sendCompilationCommand(context, flexSdk, command);
        } else {
            compilationSuccessful &= this.sendCompilationCommand(context, flexSdk, previousCommandId > 0 ? "compile " + previousCommandId : null, command);
        }
        if (config.getType() != FlexBuildConfiguration.Type.Default || !compilationSuccessful) {
            // empty if block
        }
        if (!compilationSuccessful) {
            this.dropIncrementalCompilation(moduleOrFacet, compileCache);
        }
        return Pair.create((Object)compilationSuccessful, configFiles);
    }

    private void dropIncrementalCompilation(Object moduleOrFacet, ModuleOrFacetCompileCache compileCache) throws IOException {
        String removedCommand = (String)compileCache.moduleOrFacetToCommand.remove(moduleOrFacet);
        int commandId = this.commandToIdMap.remove((Object)removedCommand);
        if (commandId > 0) {
            this.sendCommand("clear " + commandId, new CompilerMessagesBuffer(null, false));
        }
    }

    private static boolean updateTimestamps(List<VirtualFile> configFiles, ModuleOrFacetCompileCache compileCache, Object moduleOrFacet) {
        boolean result = false;
        for (VirtualFile configFile : configFiles) {
            long currentTimestamp = configFile.getModificationCount();
            Long previousTimestamp = (Long)compileCache.configFileToTimestamp.get((Object)configFile);
            if (previousTimestamp != null && previousTimestamp.equals(currentTimestamp)) continue;
            if (previousTimestamp != null) {
                result = true;
            }
            compileCache.configFileToTimestamp.put((Object)configFile, (Object)currentTimestamp);
        }
        return result;
    }

    private boolean sendCompilationCommand(CompileContext context, Sdk flexSdk, String fullCommand) throws IOException {
        return this.sendCompilationCommand(context, flexSdk, null, fullCommand, true);
    }

    private boolean sendCompilationCommand(CompileContext context, Sdk flexSdk, @Nullable String incrementalCommand, String fullCommand) throws IOException {
        return this.sendCompilationCommand(context, flexSdk, incrementalCommand, fullCommand, true);
    }

    private boolean sendCompilationCommand(CompileContext context, Sdk flexSdk, @Nullable String incrementalCommand, String fullCommand, boolean relaunchIfOutOfMemory) throws IOException {
        CompilerMessagesBuffer messagesBuffer;
        Result result = this.sendCommand(incrementalCommand != null ? incrementalCommand : fullCommand, messagesBuffer = new CompilerMessagesBuffer(context, true));
        if (result != Result.OUT_OF_MEMORY && messagesBuffer.containsOutOfMemoryError()) {
            result = Result.OUT_OF_MEMORY;
        }
        switch (result) {
            case OK: {
                messagesBuffer.flush();
                return !messagesBuffer.containsErrors();
            }
            case TARGET_NOT_FOUND: {
                messagesBuffer.flush();
                this.commandToIdMap.remove((Object)fullCommand);
                return this.sendCompilationCommand(context, flexSdk, null, fullCommand, true);
            }
            case NEED_TO_REPEAT_COMMAND: {
                messagesBuffer.flush();
                this.consumeOutput(null, messagesBuffer);
                return this.sendCompilationCommand(context, flexSdk, null, fullCommand, true);
            }
            case OUT_OF_MEMORY: {
                this.quitCompilerShell();
                messagesBuffer.removeErrorsAndStackTrace();
                messagesBuffer.flush();
                FlexCompilerHandler.addOutOfMemoryMessage(context, relaunchIfOutOfMemory);
                if (relaunchIfOutOfMemory) {
                    this.launchFcshIfNeeded(context, flexSdk);
                    return this.sendCompilationCommand(context, flexSdk, null, fullCommand, false);
                }
                return false;
            }
        }
        return false;
    }

    private static void addOutOfMemoryMessage(CompileContext context, boolean willBeRestarted) {
        if (willBeRestarted) {
            context.addMessage(CompilerMessageCategory.WARNING, FlexBundle.message("fcsh.out.of.memory.and.restarted", CommonBundle.settingsActionPath()), null, -1, -1);
        } else {
            context.addMessage(CompilerMessageCategory.ERROR, FlexCommonBundle.message((String)"increase.flex.compiler.heap", (Object[])new Object[]{CommonBundle.settingsActionPath()}), null, -1, -1);
        }
    }

    private void launchFcshIfNeeded(CompileContext context, Sdk flexSdk) throws IOException {
        if (!this.processIsAlive() || this.myRequestedQuit) {
            StringBuilder classpath = new StringBuilder();
            classpath.append(FlexCommonUtils.getPathToBundledJar((String)"idea-flex-compiler-fix.jar"));
            classpath.append(File.pathSeparatorChar);
            classpath.append(FlexCommonUtils.getPathToBundledJar((String)"idea-fcsh-fix.jar"));
            if (!(flexSdk.getSdkType() instanceof FlexmojosSdkType)) {
                classpath.append(File.pathSeparator).append(FileUtil.toSystemDependentName((String)(flexSdk.getHomePath() + "/lib/fcsh.jar")));
            }
            List<String> cmdLineParams = FlexSdkUtils.getCommandLineForSdkTool(this.myProject, flexSdk, classpath.toString(), "com.intellij.flex.FcshLauncher", null);
            context.addMessage(CompilerMessageCategory.INFORMATION, StringUtil.join(cmdLineParams, (String)" "), null, -1, -1);
            ProcessBuilder builder = new ProcessBuilder(cmdLineParams);
            builder.directory(new File(FlexUtils.getFlexCompilerWorkDirPath(this.myProject, flexSdk)));
            this.process = builder.start();
            this.is = this.process.getOutputStream();
            this.out = new InputStreamReader(this.process.getInputStream());
            this.err = new LineNumberReader(new InputStreamReader(this.process.getErrorStream()));
            this.consumeOutput(null, new CompilerMessagesBuffer(context, false));
            this.clearFcshRelatedCache();
            this.myRequestedQuit = false;
        }
    }

    private boolean processIsAlive() {
        boolean processIsAlive;
        boolean bl = processIsAlive = this.process != null;
        if (processIsAlive) {
            try {
                this.process.exitValue();
                processIsAlive = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return processIsAlive;
    }

    @NonNls
    @NotNull
    private String buildCommand(List<VirtualFile> configFiles, FlexBuildConfiguration config, Sdk flexSdk) {
        StringBuilder configsParam = new StringBuilder();
        String workDirPathWithSlash = FlexUtils.getFlexCompilerWorkDirPath(this.myProject, flexSdk) + "/";
        for (VirtualFile configFile : configFiles) {
            String relativePathToConfig = configFile.getPath();
            if (configFile.getPath().startsWith(workDirPathWithSlash)) {
                relativePathToConfig = configFile.getPath().substring(workDirPathWithSlash.length());
            }
            if (relativePathToConfig.indexOf(32) >= 0) {
                relativePathToConfig = "\"" + relativePathToConfig + "\"";
            }
            if (configsParam.length() > 0) {
                configsParam.append(",");
            }
            boolean useSdkConfig = config.USE_DEFAULT_SDK_CONFIG_FILE && !(flexSdk.getSdkType() instanceof FlexmojosSdkType);
            configsParam.append(" -load-config").append(useSdkConfig ? "+=" : "=").append(relativePathToConfig);
        }
        String s = config.OUTPUT_TYPE.equals("Application") ? "mxmlc" : "compc";
        s = s + configsParam;
        if (config.ADDITIONAL_COMPILER_OPTIONS != null && config.ADDITIONAL_COMPILER_OPTIONS.length() > 0) {
            s = s + " " + FlexUtils.replacePathMacros(config.ADDITIONAL_COMPILER_OPTIONS, null, flexSdk.getHomePath());
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler", "buildCommand"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile getRealFile(VirtualFile libFile) {
        if (libFile.getFileSystem() instanceof JarFileSystem) {
            return JarFileSystem.getInstance().getVirtualFileForJar(libFile);
        }
        return libFile;
    }

    private Result sendCommand(@NonNls String command, final CompilerMessagesBuffer messagesBuffer) throws IOException {
        FlexCompilerHandler.trace(TraceType.IN, command);
        messagesBuffer.addMessage(CompilerMessageCategory.INFORMATION, command, null, -1, -1);
        if (this.processIsAlive()) {
            this.is.write((command + "\n").getBytes());
            this.is.flush();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (FlexCompilerHandler.this.myCancelledReadErrStream) {
                        return;
                    }
                    FlexCompilerHandler.this.scanErrorStream(messagesBuffer);
                    FlexCompilerHandler.this.myReadErrStreamAlarm.addRequest((Runnable)this, 100);
                }
            };
            if ("quit".equals(command)) {
                return Result.OK;
            }
            this.myCancelledReadErrStream = false;
            this.myReadErrStreamAlarm.addRequest(runnable, 100);
        }
        return this.consumeOutput(command, messagesBuffer);
    }

    private void scanErrorStream(CompilerMessagesBuffer messagesBuffer) {
        try {
            int available;
            while ((available = this.process.getErrorStream().available()) > 2 || this.err.ready()) {
                String errLine = this.err.readLine();
                FlexCompilerHandler.trace(TraceType.ERR, errLine);
                if (errLine == null || errLine.length() == 0) continue;
                ApplicationManager.getApplication().runReadAction(() -> FlexCompilerHandler.dispatchError(errLine, messagesBuffer));
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    private static void dispatchError(String errLine, CompilerMessagesBuffer messagesBuffer) {
        Matcher matcher = FlexCommonUtils.ERROR_PATTERN.matcher(errLine);
        if (matcher.matches()) {
            String file = matcher.group(1);
            String additionalInfo = matcher.group(2);
            String line = matcher.group(3);
            String column = matcher.group(4);
            String type = matcher.group(5);
            String message = matcher.group(6);
            CompilerMessageCategory messageCategory = "Warning".equals(type) ? CompilerMessageCategory.WARNING : CompilerMessageCategory.ERROR;
            VirtualFile relativeFile = VfsUtil.findRelativeFile((String)file, null);
            StringBuilder fullMessage = new StringBuilder();
            if (relativeFile == null) {
                fullMessage.append(file).append(": ");
            }
            if (additionalInfo != null) {
                fullMessage.append(additionalInfo).append(' ');
            }
            fullMessage.append(message);
            messagesBuffer.addMessage(messageCategory, fullMessage.toString(), relativeFile != null ? relativeFile.getUrl() : null, line != null ? Integer.parseInt(line) : 0, column != null ? Integer.parseInt(column) : 0);
        } else if (FlexCompilerHandler.isErrorMessage(errLine)) {
            String errorPrefix = "Error: ";
            String errorText = errLine.startsWith("Error: ") ? errLine.substring("Error: ".length()) : errLine;
            messagesBuffer.addMessage(CompilerMessageCategory.ERROR, errorText, null, -1, -1);
        } else {
            messagesBuffer.addMessage(CompilerMessageCategory.INFORMATION, errLine, null, -1, -1);
        }
    }

    private static boolean isErrorMessage(String errLine) {
        return errLine.startsWith("Error: ") || errLine.startsWith("Exception in thread \"main\" ");
    }

    private Result consumeOutput(String command, @Nullable CompilerMessagesBuffer messagesBuffer) throws IOException {
        Result result = Result.OK;
        String lastRead = "";
        block0: while (true) {
            int read;
            if ((read = this.out.read(this.buf)) == -1) {
                read = this.err.read(this.buf);
                if (read <= 0) break;
                messagesBuffer.addMessage(CompilerMessageCategory.ERROR, new String(this.buf, 0, read), null, -1, -1);
                break;
            }
            String output = lastRead + new String(this.buf, 0, read);
            FlexCompilerHandler.trace(TraceType.OUT, output);
            StringTokenizer tokenizer = new StringTokenizer(output, "\r\n");
            while (true) {
                if (!tokenizer.hasMoreElements()) continue block0;
                String s = tokenizer.nextElement().trim();
                if (s.length() == 0) continue;
                if (s.startsWith("(fcsh)")) {
                    if (s.indexOf("need to repeat command") != -1) {
                        result = Result.NEED_TO_REPEAT_COMMAND;
                    } else if (s.indexOf("out of memory") != -1) {
                        result = Result.OUT_OF_MEMORY;
                    }
                    this.myCancelledReadErrStream = true;
                    this.myReadErrStreamAlarm.cancelAllRequests();
                    this.scanErrorStream(messagesBuffer);
                    break block0;
                }
                if (s.startsWith(FCSH_ASSIGNED_MARKER) && command != null) {
                    int id = Integer.parseInt(s.substring(FCSH_ASSIGNED_MARKER.length(), s.indexOf(32, FCSH_ASSIGNED_MARKER.length())));
                    this.commandToIdMap.put((Object)command, id);
                    continue;
                }
                if (s.startsWith("fcsh: Target") && s.indexOf("not found") != -1) {
                    result = Result.TARGET_NOT_FOUND;
                    continue;
                }
                if (!tokenizer.hasMoreElements() && tokenizer.getCurrentPosition() == output.length()) {
                    lastRead = s + "\n";
                    continue block0;
                }
                messagesBuffer.addMessage(CompilerMessageCategory.INFORMATION, s, null, -1, -1);
            }
            break;
        }
        return result;
    }

    private static void trace(TraceType type, String message) {
        System.out.println(type.toString() + ":" + message);
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "propertyChanged"));
            }
            this.handleVirtualFileEvent(event.getFile());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "contentsChanged"));
            }
            this.handleVirtualFileEvent(event.getFile(), true);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "fileCreated"));
            }
            this.handleVirtualFileEvent(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "fileDeleted"));
            }
            this.handleVirtualFileEvent(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "fileMoved"));
            }
            this.handleVirtualFileEvent(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$MyVirtualFileListener", "fileCopied"));
            }
            this.handleVirtualFileEvent(event.getFile());
        }

        private void handleVirtualFileEvent(VirtualFile file) {
            this.handleVirtualFileEvent(file, false);
        }

        private void handleVirtualFileEvent(VirtualFile file, boolean contentsChanged) {
            if (file == null) {
                return;
            }
            FlexCompilerHandler.this.myCompilerDependenciesCache.markModuleDirtyIfInSourceRoot(file);
        }
    }

    static enum TraceType {
        IN,
        OUT,
        ERR;

    }

    static enum Result {
        OK,
        TARGET_NOT_FOUND,
        NEED_TO_REPEAT_COMMAND,
        OUT_OF_MEMORY;

    }

    private static class ModuleOrFacetCompileCache {
        public final THashMap<Object, String> moduleOrFacetToCommand = new THashMap();
        public final BidirectionalMap<Object, VirtualFile> moduleOrFacetToAutoGeneratedConfig = new BidirectionalMap();
        public final THashMap<VirtualFile, Long> configFileToTimestamp = new THashMap();

        private ModuleOrFacetCompileCache() {
        }
    }
}

