/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.Collection;

public class UpdateSelectionJob
extends Job {
    private AbstractSelectionGroup oldSelectionGroup;
    private final AbstractSelectionGroup newSelectionGroup;

    public UpdateSelectionJob(AbstractSelectionGroup group, EditorController editorController) {
        super(editorController);
        this.newSelectionGroup = group;
    }

    public UpdateSelectionJob(FXOMObject newSelectedObject, EditorController editorController) {
        super(editorController);
        assert (newSelectedObject != null);
        ArrayList<FXOMObject> newSelectedObjects = new ArrayList<FXOMObject>();
        newSelectedObjects.add(newSelectedObject);
        this.newSelectionGroup = new ObjectSelectionGroup(newSelectedObjects, newSelectedObject, null);
    }

    public UpdateSelectionJob(Collection<FXOMObject> newSelectedObjects, EditorController editorController) {
        super(editorController);
        assert (newSelectedObjects != null);
        this.newSelectionGroup = newSelectedObjects.isEmpty() ? null : new ObjectSelectionGroup(newSelectedObjects, newSelectedObjects.iterator().next(), null);
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        Selection selection = this.getEditorController().getSelection();
        try {
            this.oldSelectionGroup = selection.getGroup() == null ? null : selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Bug", x);
        }
        this.redo();
    }

    @Override
    public void undo() {
        Selection selection = this.getEditorController().getSelection();
        selection.select(this.oldSelectionGroup);
        assert (selection.isValid(this.getEditorController().getFxomDocument()));
    }

    @Override
    public void redo() {
        Selection selection = this.getEditorController().getSelection();
        selection.select(this.newSelectionGroup);
        assert (selection.isValid(this.getEditorController().getFxomDocument()));
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

