/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.DiscardGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.image.Image;

public abstract class AbstractHandles<T>
extends AbstractDecoration<T> {
    public static final String SELECTION_RECT = "selection-rect";
    public static final String SELECTION_WIRE = "selection-wire";
    public static final String SELECTION_HANDLES = "selection-handles";
    public static final String SELECTION_HANDLES_DIM = "selection-handles-dim";
    public static final double SELECTION_HANDLES_SIZE = 10.0;
    private static Image squareHandleImage = null;
    private static Image sideHandleImage = null;
    private static Image squareHandleDimImage = null;
    private static Image sideHandleDimImage = null;
    private boolean enabled = true;
    private static final String HANDLES = "HANDLES";

    public AbstractHandles(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphClass) {
        super(contentPanelController, fxomObject, sceneGraphClass);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enabledDidChange();
    }

    public AbstractGesture findEnabledGesture(Node node) {
        AbstractGesture result = this.enabled ? this.findGesture(node) : new DiscardGesture(this.getContentPanelController());
        return result;
    }

    public abstract AbstractGesture findGesture(Node var1);

    public abstract void enabledDidChange();

    public static AbstractHandles<?> lookupHandles(Node node) {
        AbstractHandles result;
        assert (node != null);
        assert (!node.isMouseTransparent());
        Object value = node.getProperties().get((Object)HANDLES);
        if (value instanceof AbstractHandles) {
            result = (AbstractHandles)value;
        } else {
            assert (value == null);
            result = null;
        }
        return result;
    }

    public static void attachHandles(Node node, AbstractHandles<?> handles) {
        assert (node != null);
        assert (!node.isMouseTransparent());
        assert (AbstractHandles.lookupHandles(node) == null);
        if (handles == null) {
            node.getProperties().remove((Object)HANDLES);
        } else {
            node.getProperties().put((Object)HANDLES, handles);
        }
    }

    public static synchronized Image getCornerHandleImage() {
        if (squareHandleImage == null) {
            URL url = AbstractHandles.class.getResource("corner-handle.png");
            squareHandleImage = new Image(url.toString());
        }
        return squareHandleImage;
    }

    public static synchronized Image getSideHandleImage() {
        if (sideHandleImage == null) {
            URL url = AbstractHandles.class.getResource("side-handle.png");
            sideHandleImage = new Image(url.toString());
        }
        return sideHandleImage;
    }

    public static synchronized Image getCornerHandleDimImage() {
        if (squareHandleDimImage == null) {
            URL url = AbstractHandles.class.getResource("corner-handle-dim.png");
            squareHandleDimImage = new Image(url.toString());
        }
        return squareHandleDimImage;
    }

    public static synchronized Image getSideHandleDimImage() {
        if (sideHandleDimImage == null) {
            URL url = AbstractHandles.class.getResource("side-handle-dim.png");
            sideHandleDimImage = new Image(url.toString());
        }
        return sideHandleDimImage;
    }
}

