/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.sampledata;

import com.oracle.javafx.scenebuilder.kit.fxom.sampledata.AbstractSampleData;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

class TreeTableViewSampleData
extends AbstractSampleData {
    private final TreeItem<SampleDataItem> sampleRoot;

    public TreeTableViewSampleData() {
        int i = 0;
        this.sampleRoot = new TreeItem((Object)new SampleDataItem(i++));
        this.sampleRoot.setExpanded(true);
        for (int j = 0; j < 10; ++j) {
            Rectangle r = new Rectangle(10.0, 10.0);
            r.setFill((Paint)TreeTableViewSampleData.color(i));
            TreeItem child = new TreeItem((Object)new SampleDataItem(i++));
            child.setExpanded(true);
            child.setGraphic((Node)r);
            for (int k = 0; k < 3; ++k) {
                TreeItem child2 = new TreeItem((Object)new SampleDataItem(i++));
                child2.setExpanded(true);
                Circle c = new Circle(5.0);
                c.setFill((Paint)TreeTableViewSampleData.color(i));
                child2.setGraphic((Node)c);
                child.getChildren().add((Object)child2);
            }
            this.sampleRoot.getChildren().add((Object)child);
        }
    }

    public static boolean canApplyTo(TreeTableView<?> treeTableView) {
        boolean result;
        if (treeTableView.getRoot() != null) {
            result = false;
        } else {
            TreeTableColumn tc;
            ArrayList columns = new ArrayList();
            columns.addAll(treeTableView.getColumns());
            while (!columns.isEmpty() && (tc = (TreeTableColumn)columns.get(0)).getCellValueFactory() == null) {
                columns.remove(0);
                columns.addAll(tc.getColumns());
            }
            result = columns.isEmpty();
        }
        return result;
    }

    @Override
    public void applyTo(Object sceneGraphObject) {
        assert (sceneGraphObject instanceof TreeTableView);
        TreeTableView tableView = (TreeTableView)sceneGraphObject;
        tableView.setRoot(this.sampleRoot);
        ArrayList columns = new ArrayList(tableView.getColumns());
        while (!columns.isEmpty()) {
            TreeTableColumn ttc = (TreeTableColumn)columns.get(0);
            ttc.setCellValueFactory(SampleDataItem.FACTORY);
            columns.remove(0);
            columns.addAll(ttc.getColumns());
        }
    }

    @Override
    public void removeFrom(Object sceneGraphObject) {
        assert (sceneGraphObject instanceof TreeTableView);
        TreeTableView tableView = (TreeTableView)TreeTableView.class.cast(sceneGraphObject);
        tableView.setRoot(null);
        ArrayList columns = new ArrayList();
        columns.addAll(tableView.getColumns());
        while (!columns.isEmpty()) {
            TreeTableColumn tc = (TreeTableColumn)columns.get(0);
            tc.setCellValueFactory(null);
            columns.remove(0);
            columns.addAll(tc.getColumns());
        }
    }

    public static class SampleDataItem {
        int index;
        public static final TreeItemPropertyValueFactory<SampleDataItem, String> FACTORY = new TreeItemPropertyValueFactory("prop");

        public SampleDataItem(int index) {
            this.index = index;
        }

        public String getProp() {
            return TreeTableViewSampleData.lorem(this.index);
        }
    }
}

