/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.quickfix.AddParamBase;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class CreateParameterFix
extends AddParamBase {
    private final XPathVariableReference myReference;

    public CreateParameterFix(XPathVariableReference reference) {
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        String string = "Create parameter '" + this.myReference.getReferencedName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/CreateParameterFix", "getText"));
        }
        return string;
    }

    @Override
    protected String getParamName() {
        return this.myReference.getReferencedName();
    }

    @Override
    protected XmlTag findTemplateTag() {
        return XsltCodeInsightUtil.getTemplateTag(this.myReference, true);
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/CreateParameterFix", "isAvailableImpl"));
        }
        return this.myReference.isValid() && XsltCodeInsightUtil.getTemplateTag(this.myReference, true) != null;
    }
}

