/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteFile;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteProcessUtil {
    public static Pair<String[], String> buildRemoteCommandLine(@NotNull AbstractPathMapper pathMapper, @NotNull String[] command, @Nullable String workingDir, @NotNull String interpreterPath) {
        if (pathMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMapper", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "buildRemoteCommandLine"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "buildRemoteCommandLine"));
        }
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "buildRemoteCommandLine"));
        }
        command = Arrays.copyOf(command, command.length);
        for (int i = 0; i < command.length; ++i) {
            if (pathMapper.canReplaceLocal(command[i])) {
                command[i] = RemoteFile.detectSystemByPath((String)interpreterPath).createRemoteFile(pathMapper.convertToRemote(command[i])).getPath();
            }
            if (!RemoteProcessUtil.isPathList(command[i])) continue;
            command[i] = RemoteProcessUtil.remapPathsList(command[i], (PathMapper)pathMapper, interpreterPath);
        }
        command[1] = pathMapper.convertToRemote(command[1]);
        command[0] = interpreterPath;
        if (workingDir != null) {
            workingDir = RemoteFile.detectSystemByPath((String)command[0]).createRemoteFile(workingDir).getPath();
        }
        return Pair.create((Object)command, (Object)workingDir);
    }

    public static String[] buildRemoteCommand(@NotNull AbstractPathMapper pathMapper, @NotNull Collection<String> commands) {
        if (pathMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMapper", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "buildRemoteCommand"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "buildRemoteCommand"));
        }
        return ArrayUtil.toStringArray((Collection)pathMapper.convertToRemote(commands));
    }

    @NotNull
    public static String remapPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathsValue", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "remapPathsList"));
        }
        if (pathMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMapper", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "remapPathsList"));
        }
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "remapPathsList"));
        }
        boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
        ArrayList paths = Lists.newArrayList((Object[])pathsValue.split(File.pathSeparator));
        ArrayList mappedPaths = Lists.newArrayList();
        for (String path : paths) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        String string = Joiner.on((char)(isWin ? (char)';' : ':')).join((Iterable)mappedPaths);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteProcessUtil", "remapPathsList"));
        }
        return string;
    }

    private static boolean isPathList(String value) {
        ArrayList paths = Lists.newArrayList((Object[])value.split(File.pathSeparator));
        if (paths.size() > 1) {
            for (String p : paths) {
                if (!new File(p).exists()) continue;
                return true;
            }
        }
        return false;
    }
}

