/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.jcraft.jsch.JSchException;
import com.jetbrains.plugins.remotesdk.RemoteRunUserInfo;
import com.jetbrains.plugins.remotesdk.transport.JschExecProcess;
import com.jetbrains.plugins.remotesdk.transport.JschShellProcess;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.transport.ExecChannel;
import com.jetbrains.plugins.webDeployment.transport.ExecChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import com.jetbrains.plugins.webDeployment.transport.SftpChannel;
import com.jetbrains.plugins.webDeployment.transport.SftpChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.ShellChannel;
import com.jetbrains.plugins.webDeployment.transport.ShellChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionService;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshRemoteSession {
    private static final Logger LOG = Logger.getInstance(SshRemoteSession.class);
    private static final int DEFAULT_SFTP_CONNECTION_TIMEOUT = 60;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    private final RemoteCredentials myData;

    public SshRemoteSession(@NotNull ConnectionOwner connectionOwner, RemoteCredentials data, ProgressIndicator pi) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        this(connectionOwner, data);
    }

    public SshRemoteSession(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteCredentials data) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "<init>"));
        }
        this.myConnectionOwner = connectionOwner;
        this.myData = data;
    }

    public String toString() {
        return this.myData.getUserName() + "@" + this.myData.getHost() + ":" + this.myData.getPort();
    }

    @NotNull
    public JschExecProcess exec(@NotNull String command) throws IOException, SshTransportException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        JschExecProcess jschExecProcess = this.exec(command, 0);
        if (jschExecProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        return jschExecProcess;
    }

    @NotNull
    public JschExecProcess exec(@NotNull String command, int timeout) throws IOException, SshTransportException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        JschExecProcess jschExecProcess = this.exec(command, timeout, false);
        if (jschExecProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        return jschExecProcess;
    }

    @NotNull
    public JschExecProcess exec(@NotNull String command, int timeout, boolean allocatePty) throws IOException, SshTransportException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        SessionConfig config = this.createSessionConfig(timeout);
        ExecChannelConfig channelConfig = new ExecChannelConfig(command, allocatePty, true, (long)timeout, TimeUnit.SECONDS);
        ExecChannel channel = SshConnectionService.Companion.getInstance().exec(config, channelConfig);
        JschExecProcess jschExecProcess = new JschExecProcess(channel, allocatePty);
        if (jschExecProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "exec"));
        }
        return jschExecProcess;
    }

    @NotNull
    private SessionConfig createSessionConfig() {
        SessionConfig sessionConfig = this.createSessionConfig(0);
        if (sessionConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "createSessionConfig"));
        }
        return sessionConfig;
    }

    @NotNull
    private SessionConfig createSessionConfig(int timeout) {
        SessionConfig sessionConfig = SshConnectionServiceUtil.INSTANCE.remoteCredentialsToSessionConfig(this.myData, timeout, TimeUnit.SECONDS, this.createUserInfo());
        if (sessionConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "createSessionConfig"));
        }
        return sessionConfig;
    }

    @NotNull
    private RemoteRunUserInfo createUserInfo() {
        RemoteRunUserInfo remoteRunUserInfo = this.createUserInfo(null);
        if (remoteRunUserInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "createUserInfo"));
        }
        return remoteRunUserInfo;
    }

    @NotNull
    private RemoteRunUserInfo createUserInfo(@Nullable ProgressIndicator pi) {
        RemoteRunUserInfo remoteRunUserInfo = new RemoteRunUserInfo(this.myConnectionOwner, this.myData, pi);
        if (remoteRunUserInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "createUserInfo"));
        }
        return remoteRunUserInfo;
    }

    @NotNull
    public JschShellProcess shell() throws IOException, SshTransportException {
        ShellChannelConfig channelConfig = new ShellChannelConfig(true, true, 0L, TimeUnit.SECONDS);
        ShellChannel channel = SshConnectionService.Companion.getInstance().shell(this.createSessionConfig(), channelConfig);
        JschShellProcess jschShellProcess = new JschShellProcess(channel);
        if (jschShellProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "shell"));
        }
        return jschShellProcess;
    }

    public boolean isConnected() {
        try {
            this.getOrCreateSession(1);
            return true;
        }
        catch (Exception e) {
            LOG.debug("Failed to establish the connection", (Throwable)e);
            return false;
        }
    }

    @NotNull
    public SftpChannel sftp() throws SshTransportException {
        SftpChannelConfig config = new SftpChannelConfig(null, false, 60L, TimeUnit.SECONDS);
        SftpChannel sftpChannel = SshConnectionService.Companion.getInstance().sftp(this.createSessionConfig(), config);
        if (sftpChannel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "sftp"));
        }
        return sftpChannel;
    }

    public String getHost() {
        return this.myData.getHost();
    }

    public String getCredentialsString() {
        return RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)this.myData);
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) {
        this.getOrCreateSession().addRemoteTunnel(remotePort, host, localPort);
    }

    public void addLocalTunnel(int localPort, String host, int remotePort) {
        this.getOrCreateSession().addLocalTunnel(localPort, host, remotePort);
    }

    @Deprecated
    public void delPortForwardingL(int port) throws JSchException {
        this.getOrCreateSession().delPortForwardingL(port);
    }

    public void removeLocalTunnel(int port) {
        this.getOrCreateSession().removeLocalTunnel(port);
    }

    @NotNull
    private SshSession getOrCreateSession() {
        SshSession sshSession = this.getOrCreateSession(0);
        if (sshSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "getOrCreateSession"));
        }
        return sshSession;
    }

    @NotNull
    private SshSession getOrCreateSession(int timeout) {
        SessionConfig config = SshConnectionServiceUtil.INSTANCE.remoteCredentialsToSessionConfig(this.myData, timeout, TimeUnit.SECONDS, this.createUserInfo());
        SshSession sshSession = SshConnectionService.Companion.getInstance().connect(config);
        if (sshSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshRemoteSession", "getOrCreateSession"));
        }
        return sshSession;
    }
}

