/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.config;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.config.CfmlMappingsConfig;
import com.intellij.coldFusion.UI.config.CfmlProjectConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.ValidatingTableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;

public class CfmlMappingsForm {
    private JPanel myContentPanel;
    private JPanel myTablePanel;
    private JComboBox myLanguageLevel;
    private JLabel myMessageLabel;
    private ValidatingTableEditor<Item> myTableEditor;
    private final Project myProject;

    public JComponent getContentPane() {
        return this.myContentPanel;
    }

    public CfmlMappingsForm(Map<String, String> defaultMappings, Project project) {
        this(project);
        this.setItems(defaultMappings);
    }

    public CfmlMappingsForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myTableEditor = new ValidatingTableEditor<Item>(){

            protected Item cloneOf(Item item) {
                return new Item(item.myDirectoryPath, item.myLogicalPath);
            }

            @Nullable
            protected String validate(Item item) {
                if (StringUtil.isEmpty((String)item.myDirectoryPath)) {
                    return CfmlBundle.message("directory.path.is.empty", new Object[0]);
                }
                if (StringUtil.isEmpty((String)item.myLogicalPath)) {
                    return CfmlBundle.message("logical.path.is.empty", new Object[0]);
                }
                if (!item.myLogicalPath.startsWith("/") && !item.myLogicalPath.startsWith("\\")) {
                    return CfmlBundle.message("incorrect.logical.path", new Object[0]);
                }
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(item.myDirectoryPath);
                if (file == null || !file.isValid() || !file.isDirectory()) {
                    return CfmlBundle.message("directory.path.is.not.found", item.myDirectoryPath);
                }
                return null;
            }

            protected Item createItem() {
                return new Item("", "");
            }
        };
        this.myTableEditor.getEmptyText().setText(CfmlBundle.message("no.mapping", new Object[0]));
        this.myTablePanel.add(this.myTableEditor.getContentPane(), "Center");
        this.myLanguageLevel.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if ("cf8_tags.xml".equals(value)) {
                    this.setText("ColdFusion 8");
                } else if ("tags.xml".equals(value)) {
                    this.setText("ColdFusion 9");
                } else if ("cf10_tags.xml".equals(value)) {
                    this.setText("ColdFusion 10");
                } else if ("cf11_tags.xml".equals(value)) {
                    this.setText("ColdFusion 11");
                } else if ("Railo_tags.xml".equals(value)) {
                    this.setText("Railo");
                }
            }
        });
        this.myLanguageLevel.addItem("cf8_tags.xml");
        this.myLanguageLevel.addItem("tags.xml");
        this.myLanguageLevel.addItem("cf10_tags.xml");
        this.myLanguageLevel.addItem("cf11_tags.xml");
        this.myLanguageLevel.addItem("Railo_tags.xml");
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myMessageLabel.setVisible(false);
    }

    public void setItems(Map<String, String> paths) {
        ArrayList<Item> items = new ArrayList<Item>(paths.size());
        for (Map.Entry<String, String> entry : paths.entrySet()) {
            items.add(new Item(FileUtil.toSystemDependentName((String)entry.getValue()), entry.getKey()));
        }
        this.myTableEditor.setModel(new ColumnInfo[]{new DirectoryPathColumnInfo(), new LogicalPathColumnInfo()}, items);
    }

    private Map<String, String> getPaths() {
        List items = this.myTableEditor.getItems();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Item item : items) {
            if (item.isEmpty()) continue;
            result.put(item.myLogicalPath, FileUtil.toSystemIndependentName((String)item.myDirectoryPath));
        }
        return result;
    }

    public void reset(CfmlProjectConfiguration.State state) {
        this.setItems(state != null ? state.getMapps().getServerMappings() : Collections.emptyMap());
        String newLanguageLevel = state != null ? state.getLanguageLevel() : "cf10_tags.xml";
        this.myLanguageLevel.setSelectedItem(newLanguageLevel);
    }

    public void applyTo(CfmlProjectConfiguration.State state) {
        state.setMapps(new CfmlMappingsConfig(this.getPaths()));
        state.setLanguageLevel((String)this.myLanguageLevel.getSelectedItem());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Server Mappings", (int)0, (int)0, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Reopen editor for changes to take effect");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myLanguageLevel = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Language version:");
        jLabel2.setDisplayedMnemonic('L');
        jLabel2.setDisplayedMnemonicIndex(0);
        ((Component)jLabel2).setEnabled(true);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private class DirectoryPathColumnInfo
    extends ColumnInfo<Item, String>
    implements ValidatingTableEditor.RowHeightProvider {
        public DirectoryPathColumnInfo() {
            super(CfmlBundle.message("directory.path.column.info", new Object[0]));
        }

        public String valueOf(Item item) {
            return item.myDirectoryPath;
        }

        public void setValue(Item item, String value) {
            item.myDirectoryPath = FileUtil.toSystemDependentName((String)value);
        }

        public boolean isCellEditable(Item item) {
            return true;
        }

        public TableCellEditor getEditor(Item o) {
            return new LocalPathCellEditor(CfmlMappingsForm.this.myProject);
        }

        public int getRowHeight() {
            return new JTextField().getPreferredSize().height + 1;
        }
    }

    private static class LogicalPathColumnInfo
    extends ColumnInfo<Item, String>
    implements ValidatingTableEditor.RowHeightProvider {
        public LogicalPathColumnInfo() {
            super(CfmlBundle.message("logical.path.column.info", new Object[0]));
        }

        public String valueOf(Item item) {
            return item.myLogicalPath;
        }

        public void setValue(Item item, String value) {
            item.myLogicalPath = value;
        }

        public boolean isCellEditable(Item item) {
            return true;
        }

        public int getRowHeight() {
            return new JTextField().getPreferredSize().height + 1;
        }

        public TableCellEditor getEditor(Item o) {
            return new AbstractTableCellEditor(){
                JTextField myComponent;

                public Object getCellEditorValue() {
                    return this.myComponent.getText();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myComponent = new JTextField();
                    this.myComponent.setText((String)value);
                    return this.myComponent;
                }
            };
        }
    }

    private static class Item {
        public String myDirectoryPath;
        public String myLogicalPath;

        public Item(String directoryPath, String logicalPath) {
            this.myDirectoryPath = FileUtil.toSystemDependentName((String)directoryPath);
            this.myLogicalPath = logicalPath;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty((String)this.myDirectoryPath) && StringUtil.isEmpty((String)this.myLogicalPath);
        }
    }
}

