/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.info;

import com.intellij.coldFusion.model.info.CfmlAttributeDescription;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.info.CfmlTagDescription;
import com.intellij.coldFusion.model.info.CfmlTypesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CfmlTagsDescriptionsParser
extends DefaultHandler {
    private boolean myIsTagHelpSection = false;
    private boolean myIsFunctionHelpSection = false;
    private Map<String, CfmlTagDescription> myTags;
    private Map<String, CfmlFunctionDescription> myFunctions;
    private Map<String, Integer> myPredefinedVariables = new HashMap<String, Integer>();
    private CfmlTagDescription myCurrentTag = null;
    private CfmlFunctionDescription myCurrentFunction = null;
    private CfmlAttributeDescription myCurrentAttribute = null;
    private List<String> myFunctionUpperCased = new LinkedList<String>();
    private String myCurrentScope = "";
    private static final int TAG_STATE = 0;
    private static final int FUNCTION_STATE = 1;
    private static final int SCOPE_STATE = 2;
    private static final int PREDEFINED_VARIABLE_STATE = 3;
    private int myState;
    private final Pattern myPattern = Pattern.compile("\\s{2,}");

    @Override
    public void startDocument() throws SAXException {
        this.myTags = new HashMap<String, CfmlTagDescription>();
        this.myFunctions = new HashMap<String, CfmlFunctionDescription>();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.myIsTagHelpSection && !this.myIsFunctionHelpSection) {
            return;
        }
        String description = new String(ch, start, length);
        description = this.myPattern.matcher(description).replaceAll(" ");
        if (this.myIsTagHelpSection && this.myCurrentTag != null) {
            String previousDescription = this.myCurrentTag.getDescription();
            this.myCurrentTag.setDescription(StringUtil.isEmpty((String)previousDescription) ? description : previousDescription + "\n" + description);
        } else if (this.myIsFunctionHelpSection && this.myCurrentFunction != null) {
            String previousDescription = this.myCurrentFunction.getDescription();
            this.myCurrentFunction.setDescription(StringUtil.isEmpty((String)previousDescription) ? description : previousDescription + "\n" + description);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        if (localName.equals("tags")) {
            this.myState = 0;
        } else if (localName.equals("functions")) {
            this.myState = 1;
        } else if (localName.equals("cfscopes")) {
            this.myState = 2;
        } else if (localName.equals("scopes")) {
            this.myState = 3;
        } else if (this.myState == 0) {
            this.myIsTagHelpSection = false;
            if (localName.equals("tag")) {
                String isSingle = attr.getValue("single");
                String isEndtagrequired = attr.getValue("endtagrequired");
                this.myCurrentTag = new CfmlTagDescription(attr.getValue("name"), Boolean.valueOf(isSingle), Boolean.valueOf(isEndtagrequired));
            } else if (localName.equals("help")) {
                this.myIsTagHelpSection = true;
            } else if (localName.equals("parameter")) {
                String aName = attr.getValue("name");
                int aType = CfmlTypesInfo.getTypeByString(attr.getValue("type"));
                boolean aRequired = Boolean.valueOf(attr.getValue("required"));
                String aDescription = "";
                this.myCurrentAttribute = new CfmlAttributeDescription(aName, aType, aRequired, aDescription);
            } else if (localName.equals("value") && this.myCurrentAttribute != null) {
                this.myCurrentAttribute.addValue(attr.getValue("option"));
            }
        } else if (this.myState == 1) {
            this.myIsFunctionHelpSection = false;
            if (localName.equals("function")) {
                this.myCurrentFunction = new CfmlFunctionDescription(attr.getValue("name"), attr.getValue("returns"));
            } else if (localName.equals("parameter") && this.myCurrentFunction != null) {
                String aName = attr.getValue("name");
                String aType = attr.getValue("type");
                boolean aRequired = Boolean.valueOf(attr.getValue("required"));
                this.myCurrentFunction.addParameter(new CfmlFunctionDescription.CfmlParameterDescription(aName, aType, aRequired));
            } else if (localName.equals("help")) {
                this.myIsFunctionHelpSection = true;
            }
        } else if (this.myState == 3) {
            if (localName.equals("scope")) {
                int aType = CfmlTypesInfo.getTypeByString(attr.getValue("type"));
                String aName = attr.getValue("value");
                this.myPredefinedVariables.put(aName.toLowerCase(), aType);
            }
        } else if (this.myState == 2 && localName.equals("scopevar")) {
            if (!StringUtil.isEmpty((String)this.myCurrentScope) && this.myCurrentScope.charAt(this.myCurrentScope.length() - 1) != '.') {
                this.myCurrentScope = this.myCurrentScope + ".";
            }
            this.myCurrentScope = this.myCurrentScope + attr.getValue("name");
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("tag") && this.myCurrentTag != null) {
            this.myTags.put(this.myCurrentTag.getName(), this.myCurrentTag);
            this.myCurrentTag = null;
        } else if (localName.equals("function") && this.myCurrentFunction != null) {
            String functioName = this.myCurrentFunction.getName();
            this.myFunctionUpperCased.add(functioName);
            this.myFunctions.put(functioName.toLowerCase(), this.myCurrentFunction);
            this.myCurrentFunction = null;
        } else if (localName.equals("parameter") && this.myCurrentTag != null && this.myCurrentAttribute != null) {
            this.myCurrentTag.addAttribute(this.myCurrentAttribute);
            this.myCurrentAttribute = null;
        } else if (localName.equals("scopevar") && !StringUtil.isEmpty((String)this.myCurrentScope)) {
            if (this.myCurrentScope.charAt(this.myCurrentScope.length() - 1) != '.') {
                this.myPredefinedVariables.put(this.myCurrentScope.toLowerCase(), 11);
            } else {
                this.myCurrentScope = this.myCurrentScope.substring(0, this.myCurrentScope.length() - 1);
            }
            int i = this.myCurrentScope.lastIndexOf(46);
            this.myCurrentScope = i != -1 ? this.myCurrentScope.substring(0, i + 1) : "";
        }
    }

    public Map<String, CfmlFunctionDescription> getFunctions() {
        return this.myFunctions;
    }

    public String[] getFunctionsList() {
        return ArrayUtil.toStringArray(this.myFunctionUpperCased);
    }

    public String[] getFunctionsListLowerCased() {
        return ArrayUtil.toStringArray(this.myFunctions.keySet());
    }

    public Map<String, Integer> getPredefinedVariables() {
        return this.myPredefinedVariables;
    }

    public Map<String, CfmlTagDescription> getTags() {
        return this.myTags;
    }
}

