/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.PropertyFileGenerator;
import com.intellij.compiler.ant.taskdefs.Delete;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.ant.CompileGwtTarget;
import com.intellij.gwt.ant.GwtBuildProperties;
import com.intellij.gwt.ant.RunGwtCompilerTarget;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;

public class GwtBuildExtension
extends ChunkBuildExtension {
    @NotNull
    public String[] getTargets(ModuleChunk chunk) {
        ArrayList<String> targets = new ArrayList<String>();
        for (Module module : chunk.getModules()) {
            GwtFacet gwtFacet = GwtFacet.getInstance(module);
            if (gwtFacet == null) continue;
            targets.add(GwtBuildProperties.getCompileGwtTargetName(gwtFacet));
        }
        String[] stringArray = ArrayUtil.toStringArray(targets);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/ant/GwtBuildExtension", "getTargets"));
        }
        return stringArray;
    }

    public void generateProperties(PropertyFileGenerator generator, Project project, GenerationOptions options) {
        MultiValuesMap<String, GwtFacet> gwtSdkPaths = GwtBuildExtension.getGwtSdkPaths(project);
        Set paths = gwtSdkPaths.keySet();
        if (paths.size() == 1) {
            generator.addProperty(GwtBuildProperties.getGwtSdkHomeProperty(), (String)paths.iterator().next());
        } else {
            for (String path : gwtSdkPaths.keySet()) {
                Collection facets = gwtSdkPaths.get((Object)path);
                if (facets == null) continue;
                for (GwtFacet facet : facets) {
                    generator.addProperty(GwtBuildProperties.getGwtSdkHomeProperty(facet), path);
                }
            }
        }
        boolean systemDependentSdkJarUsed = false;
        for (GwtFacet facet : GwtBuildExtension.getGwtFacets(project)) {
            systemDependentSdkJarUsed |= !facet.getSdkVersion().isUseSystemIndependentGwtDevJar();
        }
        if (systemDependentSdkJarUsed) {
            generator.addProperty(GwtBuildProperties.getSystemDependentGwtSdkDevJarNameProperty(), GwtSdkPathUtil.getSystemDependentDevJarName());
        }
    }

    public static MultiValuesMap<String, GwtFacet> getGwtSdkPaths(Project project) {
        Module[] modules;
        MultiValuesMap gwtSdkPaths = new MultiValuesMap(true);
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            GwtFacet gwtFacet = GwtFacet.getInstance(module);
            if (gwtFacet == null) continue;
            gwtSdkPaths.put((Object)VfsUtil.urlToPath((String)((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk().getHomeDirectoryUrl()), (Object)gwtFacet);
        }
        return gwtSdkPaths;
    }

    public void process(Project project, ModuleChunk chunk, GenerationOptions genOptions, CompositeGenerator generator) {
        Module[] modules;
        for (Module module : modules = chunk.getModules()) {
            ReadAction.run(() -> {
                GwtFacet facet = GwtFacet.getInstance(module);
                if (facet != null) {
                    String outputDir = BuildProperties.propertyRef((String)BuildProperties.getModuleBasedirProperty((Module)facet.getModule())) + "/GWTCompilerOutput_" + BuildProperties.convertName((String)facet.getModule().getName());
                    generator.add((Generator)new Property(GwtBuildProperties.getGwtCompilerOutputPropertyName(facet), outputDir), 1);
                    Comment comment = new Comment(GwtBundle.message("ant.target.comment.run.gwt.compiler.for.gwt.module.0", BuildProperties.propertyRef((String)GwtBuildProperties.getGwtModuleParameter())));
                    generator.add((Generator)comment, 1);
                    generator.add((Generator)new RunGwtCompilerTarget(facet, genOptions));
                    generator.add((Generator)CompileGwtTarget.create(facet, genOptions), 1);
                }
            });
        }
    }

    public void generateProjectTargets(Project project, GenerationOptions genOptions, CompositeGenerator generator) {
        if (!GwtBuildExtension.getGwtFacets(project).isEmpty()) {
            List<GwtFacet> facets = GwtBuildExtension.getGwtFacets(project);
            Target target = new Target(GwtBuildProperties.getGwtCleanTargetName(), null, "Clean GWT Compiler output directories", null);
            for (GwtFacet facet : facets) {
                target.add((Generator)new Delete(BuildProperties.propertyRef((String)GwtBuildProperties.getGwtCompilerOutputPropertyName(facet))));
            }
            generator.add((Generator)target, 1);
        }
    }

    private static List<GwtFacet> getGwtFacets(Project project) {
        return ProjectFacetManager.getInstance((Project)project).getFacets(GwtFacetType.ID);
    }

    public List<String> getCleanTargetNames(Project project, GenerationOptions genOptions) {
        if (!GwtBuildExtension.getGwtFacets(project).isEmpty()) {
            return Collections.singletonList(GwtBuildProperties.getGwtCleanTargetName());
        }
        return Collections.emptyList();
    }
}

