/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.gwt.clientBundle.jam.ClientBundleMethodJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceClassJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceMethodJamElement;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssClassDefinitionSearcher
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "execute"));
        }
        return ContainerUtil.process(CssClassDefinitionSearcher.getDefinitions(sourceElement), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Collection<? extends PsiElement> getDefinitions(PsiElement sourceElement) {
        CssResourceClassJamElement element;
        AccessToken token = ReadAction.start();
        if (sourceElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)sourceElement;
            CssResourceMethodJamElement element2 = CssResourceMethodJamElement.getJamElement(method);
            if (element2 != null) {
                List<CssElement> list = element2.findCssElements();
                List<CssElement> list2 = list;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "getDefinitions"));
                }
                return list2;
            }
            ClientBundleMethodJamElement clientBundleMethod = ClientBundleMethodJamElement.getElement(method);
            if (clientBundleMethod != null) {
                List<PsiFile> list = clientBundleMethod.getSourceFiles(true);
                List<PsiFile> list3 = list;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "getDefinitions"));
                }
                return list3;
            }
        } else if (sourceElement instanceof PsiClass && (element = CssResourceClassJamElement.getJamElement((PsiClass)sourceElement)) != null) {
            Set<StylesheetFile> set = element.findStylesheetFiles(true, true);
            Set<StylesheetFile> set2 = set;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "getDefinitions"));
            }
            return set2;
        }
        List list = Collections.emptyList();
        List list4 = list;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/CssClassDefinitionSearcher", "getDefinitions"));
        }
        return list4;
        finally {
            token.finish();
        }
    }
}

