/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class GwtCompilerPaths {
    private GwtCompilerPaths() {
    }

    public static File getTestGenDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestGenDirectory"));
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "gen");
    }

    public static File getTestOutputDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestOutputDirectory"));
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "www");
    }

    private static File getTestOutputRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestOutputRoot"));
        }
        return new File(GwtCompilerPaths.getOutputRoot(module), "test");
    }

    public static File getOutputRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getOutputRoot"));
        }
        return GwtCompilerPaths.getProjectOutputRoot(module.getProject()).resolve(GwtCompilerPaths.getOutputDirectoryName(module)).toFile();
    }

    @NotNull
    public static Path getProjectOutputRoot(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtCompilerPaths", "getProjectOutputRoot"));
        }
        Path path = ProjectUtil.getProjectCachePath((Project)project, (Path)GwtCompilerPaths.getOutputRoot(), (boolean)true);
        if (path == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/make/GwtCompilerPaths", "getProjectOutputRoot"));
        }
        return path;
    }

    @NotNull
    public static Path getOutputRoot() {
        Path path = PathManagerEx.getAppSystemDir().resolve("gwt");
        if (path == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/make/GwtCompilerPaths", "getOutputRoot"));
        }
        return path;
    }

    private static String getOutputDirectoryName(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getOutputDirectoryName"));
        }
        String moduleName = module.getName();
        String modulePath = module.getModuleFilePath();
        return moduleName.replace(' ', '_') + "." + Integer.toHexString(modulePath.hashCode());
    }

    public static File getCompileReportInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtCompilerPaths", "getCompileReportInfo"));
        }
        return GwtCompilerPaths.getProjectOutputRoot(project).resolve("compile-reports-v2.xml").toFile();
    }

    public static File getGwtSourcePaths(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtCompilerPaths", "getGwtSourcePaths"));
        }
        return GwtCompilerPaths.getProjectOutputRoot(project).resolve("gwt-source-paths.xml").toFile();
    }

    public static File getGwtDependencies(Project project) {
        return new File(BuildManager.getInstance().getProjectSystemDirectory(project), "gwt-dependencies.xml");
    }
}

