/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.sdk.impl.GwtSdkBase;
import com.intellij.gwt.sdk.impl.GwtVersionDetector;
import com.intellij.gwt.sdk.impl.GwtVersionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtMavenSdkPaths;

public class GwtMavenSdk
extends GwtSdkBase {
    private final String myVersion;

    public GwtMavenSdk(String homeDirectoryPath, String version) {
        super((GwtSdkPaths)new GwtMavenSdkPaths(homeDirectoryPath, version));
        this.myVersion = version;
    }

    @Override
    @NotNull
    protected GwtVersion detectVersion() {
        GwtVersionImpl gwtVersionImpl = GwtVersionDetector.getGwtVersionFromString(this.myVersion);
        if (gwtVersionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/maven/GwtMavenSdk", "detectVersion"));
        }
        return gwtVersionImpl;
    }

    @NotNull
    public GwtMavenSdkPaths getGwtSdkPaths() {
        GwtMavenSdkPaths gwtMavenSdkPaths = (GwtMavenSdkPaths)this.myPaths;
        if (gwtMavenSdkPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/maven/GwtMavenSdk", "getGwtSdkPaths"));
        }
        return gwtMavenSdkPaths;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

