/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.MemberFilterWithNameMappings;

final class JavaToJavaScriptDebugAware
extends JavaScriptDebugAware {
    private static final Pattern POSTFIX_PATTERN = Pattern.compile("_\\d+_g\\$$");

    JavaToJavaScriptDebugAware() {
    }

    @NotNull
    public Class<? extends XLineBreakpointType<?>> getBreakpointTypeClass() {
        if (JavaLineBreakpointType.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getBreakpointTypeClass"));
        }
        return JavaLineBreakpointType.class;
    }

    @Nullable
    public MemberFilter createMemberFilter(final @Nullable NameMapper nameMapper, @NotNull PsiElement element, int end) {
        Map rawNameToSource;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "createMemberFilter"));
        }
        if (nameMapper == null || element.getContainingFile().getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (method == null) {
            return null;
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            nameMapper.map((PsiElement)parameter);
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitLocalVariable(PsiLocalVariable variable) {
                    nameMapper.map((PsiElement)variable);
                }
            });
        }
        return (rawNameToSource = nameMapper.getRawNameToSource()) == null ? null : new MemberFilterWithNameMappings(rawNameToSource);
    }

    @Nullable
    public PsiElement getNavigationElementForSourcemapInspector(@NotNull PsiFile file) {
        PsiClass[] classes;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getNavigationElementForSourcemapInspector"));
        }
        if (file instanceof PsiJavaFile && (classes = ((PsiJavaFile)file).getClasses()).length > 0) {
            return classes[0].getNavigationElement();
        }
        return null;
    }

    @Nullable
    protected LanguageFileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    @NotNull
    public Promise<ExpressionInfo> getEvaluationInfo(@NotNull PsiElement element, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (expressionInfoFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfoFactory", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (element instanceof PsiIdentifier) {
            Promise promise = expressionInfoFactory.create(element, document);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getEvaluationInfo"));
            }
            return promise;
        }
        Promise promise = Promise.resolve(null);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "getEvaluationInfo"));
        }
        return promise;
    }

    @NotNull
    public String normalizeMemberName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "normalizeMemberName"));
        }
        Matcher matcher = POSTFIX_PATTERN.matcher(name);
        if (matcher.find()) {
            String string = name.substring(0, matcher.start());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "normalizeMemberName"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/JavaToJavaScriptDebugAware", "normalizeMemberName"));
        }
        return string;
    }
}

