/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.gwt.uiBinder.GwtUiXmlSchemaProvider;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.Query;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class GwtComponentTagCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, result);
        if (!parameters.isExtendedCompletion() || !XmlCompletionContributor.isXmlNameCompletion((CompletionParameters)parameters)) {
            return;
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof XmlFile) || !UiBinderUtil.isUiXmlFile((XmlFile)file)) {
            return;
        }
        Query search = (Query)ReadAction.compute(() -> {
            GlobalSearchScope scope = file.getResolveScope();
            PsiClass widgetBaseClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("com.google.gwt.user.client.ui.IsWidget", scope);
            if (widgetBaseClass != null) {
                return ClassInheritorsSearch.search((PsiClass)widgetBaseClass, (SearchScope)scope, (boolean)true);
            }
            return null;
        });
        if (search == null) {
            return;
        }
        search.forEach(psiClass -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "lambda$fillCompletionVariants$1"));
            }
            String name = psiClass.getName();
            if (name == null || !result.getPrefixMatcher().prefixMatches(name)) {
                return true;
            }
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return true;
            }
            String packageName = StringUtil.getPackageName((String)qualifiedName);
            String namespace = "urn:import:" + packageName;
            if (GwtUiXmlSchemaProvider.isDefaultSchema(namespace)) {
                return true;
            }
            LookupElement element = XmlCompletionContributor.createLookupElement((XmlExtension.TagInfo)new XmlExtension.TagInfo(name, namespace), (String)packageName, null);
            result.addElement(element);
            return true;
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        int endOffset;
        XmlToken startTagNameElement;
        PsiElement element;
        XmlTag xmlTag;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "beforeCompletion"));
        }
        super.beforeCompletion(context);
        PsiFile file = context.getFile();
        if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file) && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(context.getStartOffset())), XmlTag.class, (boolean)true)) != null && !xmlTag.getNamespacePrefix().isEmpty() && (startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)xmlTag)) != null && (endOffset = startTagNameElement.getTextRange().getEndOffset()) >= context.getSelectionEndOffset()) {
            context.setReplacementOffset(endOffset);
        }
    }
}

