/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.cassandra.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.semantic.SemKey;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScanArchetype;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EnableReactiveCassandraRepositories
extends SpringJamComponentScanArchetype {
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_REACTIVE_CASSANDRA_REPOSITORIES_KEY = Key.create((String)"ALL_REACTIVE_CASSANDRA_REPOSITORIES_KEY");
    private static final JamStringAttributeMeta.Single<SpringBeanPointer> CASSANDRA_TEMPLATE_REF_ATTRIBUTE = JamAttributeMeta.singleString((String)"reactiveCassandraTemplateRef", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.data.cassandra.core.ReactiveCassandraTemplate"));
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.data.cassandra.repository.config.EnableReactiveCassandraRepositories", ARCHETYPE, META_KEY).addAttribute(CASSANDRA_TEMPLATE_REF_ATTRIBUTE);
    public static final SemKey<EnableReactiveCassandraRepositories> JAM_KEY = COMPONENT_SCAN_JAM_KEY.subKey("EnableReactiveCassandraRepositories", new SemKey[0]);
    public static final JamClassMeta<EnableReactiveCassandraRepositories> META = new JamClassMeta(null, EnableReactiveCassandraRepositories.class, JAM_KEY).addAnnotation(ANNO_META);

    public EnableReactiveCassandraRepositories(@NotNull PsiClass psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/cassandra/jam/EnableReactiveCassandraRepositories", "<init>"));
        }
        super(psiElement);
    }

    @NotNull
    protected JamAnnotationMeta getAnnotationMeta() {
        JamAnnotationMeta jamAnnotationMeta = ANNO_META;
        if (jamAnnotationMeta == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/cassandra/jam/EnableReactiveCassandraRepositories", "getAnnotationMeta"));
        }
        return jamAnnotationMeta;
    }

    @NotNull
    protected Set<CommonSpringBean> getScannedBeans(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/cassandra/jam/EnableReactiveCassandraRepositories", "getScannedBeans"));
        }
        List<CommonSpringBean> repositories = RepositoriesSearchUtil.getAllRepositories(module, ALL_REACTIVE_CASSANDRA_REPOSITORIES_KEY, "org.springframework.data.repository.Repository");
        Set set = SpringJamUtils.getInstance().filterComponentScannedStereotypes(module, (SpringBeansPackagesScan)this, repositories);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/cassandra/jam/EnableReactiveCassandraRepositories", "getScannedBeans"));
        }
        return set;
    }
}

