/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.utils.SpringDataBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataRepositoryMethodReturnTypeInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        PsiTypeElement identifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "checkRepositoryMethod"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "checkRepositoryMethod"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "checkRepositoryMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "checkRepositoryMethod"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "checkRepositoryMethod"));
        }
        PsiClass domainType = (PsiClass)typePair.first;
        if (domainType == null) {
            return;
        }
        if (!SpringDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(domainType, repositoryClass, psiMethod) && (identifier = psiMethod.getReturnTypeElement()) != null) {
            holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("incorrect.method.return.type", domainType.getName()), new LocalQuickFix[0]);
        }
    }

    public static boolean isAssignableReturnType(@NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod) {
        String name;
        PartTree partTree;
        PartTree.Subject subject;
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableReturnType"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableReturnType"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableReturnType"));
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)returnType) != null) {
            return true;
        }
        PsiClassType type = PsiTypesUtil.getClassType((PsiClass)domainClass);
        if (returnType == null) {
            return false;
        }
        if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, returnType, repositoryClass)) {
            return true;
        }
        PsiType genericType = SpringDataRepositoryMethodReturnTypeInspection.substituteGeoResultsTypeParameter(returnType);
        genericType = genericType != null ? genericType : PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false);
        PsiType psiType = genericType = genericType != null ? genericType : SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType);
        if (genericType != null) {
            if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, genericType, repositoryClass)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, iterableTypeParameter, repositoryClass)) {
                return true;
            }
        }
        if ((subject = (partTree = new PartTree(name = psiMethod.getName(), domainClass)).getSubject()).isDelete().booleanValue() || subject.isCountProjection()) {
            return returnType.isAssignableFrom((PsiType)PsiType.LONG);
        }
        return false;
    }

    public static boolean isAssignableTypeOrProjectionType(@NotNull PsiClassType domainType, @NotNull PsiType methodReturnType, @NotNull PsiClass repositoryClass) {
        if (domainType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainType", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableTypeOrProjectionType"));
        }
        if (methodReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReturnType", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableTypeOrProjectionType"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "isAssignableTypeOrProjectionType"));
        }
        if (methodReturnType.isAssignableFrom((PsiType)domainType)) {
            return true;
        }
        if (methodReturnType instanceof PsiClassType) {
            PsiClass projectionClass = ((PsiClassType)methodReturnType).resolve();
            PsiClass domainClass = domainType.resolve();
            if (projectionClass != null && domainClass != null) {
                if (projectionClass instanceof PsiTypeParameter) {
                    return true;
                }
                if (!projectionClass.isInterface()) {
                    return false;
                }
                if (InheritanceUtil.isInheritor((PsiClass)projectionClass, (String)"java.lang.Iterable")) {
                    return false;
                }
                if (SpringDataProjectionUtil.isExplicitProjectionType(projectionClass, domainClass, repositoryClass)) {
                    return true;
                }
                if (SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType substituteGeoResultsTypeParameter(PsiType returnType) {
        return SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType, "org.springframework.data.geo.GeoResults");
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType, "java.util.Optional", "java.util.stream.Stream", "com.google.common.base.Optional", "com.google.common.util.concurrent.ListenableFuture", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture", "org.springframework.util.concurrent.ListenableFuture", "org.springframework.data.geo.GeoResult", "org.springframework.data.geo.GeoPage", "rx.Observable", "rx.Single", "reactor.core.publisher.Mono", "reactor.core.publisher.Flux");
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataRepositoryMethodReturnTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection", "getShortName"));
        }
        return "SpringDataRepositoryMethodReturnTypeInspection";
    }
}

