/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view.panels;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.data.commons.view.SpringRepositoriesView;
import com.intellij.spring.data.commons.view.panels.SpringRepositoryMethodPanel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRepositoriesPanel
extends FinderRecursivePanel<SpringBeanPointer> {
    private final Module[] myModules;
    private DocumentationComponent myDocumentationComponent;

    public SpringRepositoriesPanel(Project project) {
        super(project, "SpringRepository");
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
    }

    public SpringRepositoriesPanel(FinderRecursivePanel<Module> parent, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/view/panels/SpringRepositoriesPanel", "<init>"));
        }
        super(parent);
        this.myModules = new Module[]{module};
    }

    @NotNull
    protected List<SpringBeanPointer> getListItems() {
        HashSet allModulePointers = ContainerUtil.newHashSet();
        for (Module module : this.myModules) {
            ContainerUtil.addAllNotNull((Collection)allModulePointers, SpringRepositoriesView.getRepositoryPointers(module));
        }
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>(allModulePointers);
        Collections.sort(pointers, Comparator.comparing(this::getItemText));
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/view/panels/SpringRepositoriesPanel", "getListItems"));
        }
        return arrayList;
    }

    @NotNull
    protected String getItemText(SpringBeanPointer springBeanPointer) {
        String string = springBeanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)springBeanPointer) : "<invalid>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/view/panels/SpringRepositoriesPanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringBeanPointer springBeanPointer) {
        if (!springBeanPointer.isValid()) {
            return null;
        }
        CommonSpringBean bean = springBeanPointer.getSpringBean();
        if (bean instanceof JamPsiClassSpringBean) {
            return ((JamPsiClassSpringBean)bean).getPsiElement().getIcon(2);
        }
        return springBeanPointer.isValid() ? SpringPresentationProvider.getSpringIcon((Object)springBeanPointer) : null;
    }

    protected boolean hasChildren(SpringBeanPointer springBeanPointer) {
        return SpringRepositoriesPanel.hasRepositoryMethods(springBeanPointer);
    }

    private static boolean hasRepositoryMethods(SpringBeanPointer springBeanPointer) {
        PsiClass psiClass = springBeanPointer.getBeanClass();
        return psiClass != null && SpringRepositoryMethodPanel.getRepositoryMethods(psiClass).size() > 0;
    }

    @Nullable
    protected VirtualFile getContainingFile(SpringBeanPointer springBeanPointer) {
        return springBeanPointer.isValid() ? springBeanPointer.getContainingFile().getVirtualFile() : null;
    }

    protected boolean performEditAction() {
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)this.getSelectedValue();
        if (springBeanPointer == null) {
            return true;
        }
        PsiElement navigationElement = springBeanPointer.getPsiElement();
        if (navigationElement != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)navigationElement);
        }
        return true;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, SpringBeanPointer value, int index, boolean selected, boolean hasFocus) {
        if (!value.isValid()) {
            return;
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        PsiClass beanClass = value.getBeanClass();
        CommonSpringBean bean = value.getSpringBean();
        if (beanClass != null && bean instanceof JamPsiClassSpringBean && beanClass.getQualifiedName() != null) {
            String qualifiedName = beanClass.getQualifiedName();
            comp.append(StringUtilRt.getShortName((String)qualifiedName));
            if (StringUtil.isNotEmpty((String)qualifiedName)) {
                comp.append(" (" + StringUtil.getPackageName((String)qualifiedName) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else {
            comp.append(this.getItemText(value));
            comp.append(" (" + value.getContainingFile().getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    protected JComponent createRightComponent(SpringBeanPointer springBeanPointer) {
        PsiClass beanClass = springBeanPointer.getBeanClass();
        if (beanClass == null) {
            return super.createRightComponent((Object)springBeanPointer);
        }
        if (SpringRepositoriesPanel.hasRepositoryMethods(springBeanPointer)) {
            return new SpringRepositoryMethodPanel(this, beanClass);
        }
        return this.getDocumentationComponent((PsiElement)beanClass);
    }

    public DocumentationComponent getDocumentationComponent(PsiElement element) {
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
        if (this.myDocumentationComponent == null) {
            this.myDocumentationComponent = new DocumentationComponent(manager);
            Disposer.register((Disposable)this, (Disposable)this.myDocumentationComponent);
        }
        manager.fetchDocInfo(element, this.myDocumentationComponent);
        return this.myDocumentationComponent;
    }
}

