/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesSearchUtil {
    public static List<CommonSpringBean> getAllRepositories(@NotNull Module module, @NotNull Key<CachedValue<List<CommonSpringBean>>> cachedValueKey, @NotNull String repositoryBaseClassName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (cachedValueKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedValueKey", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (repositoryBaseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBaseClassName", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, cachedValueKey, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "lambda$getAllRepositories$0"));
            }
            if (repositoryBaseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBaseClassName", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "lambda$getAllRepositories$0"));
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List<CommonSpringBean> resultElements = RepositoriesSearchUtil.getAllRepositories(scope, module.getProject(), repositoryBaseClassName);
            return CachedValueProvider.Result.create(resultElements, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    public static List<CommonSpringBean> getAllRepositories(@NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull String repositoryBaseClassName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (repositoryBaseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBaseClassName", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        PsiClass repositoryClass = JavaPsiFacade.getInstance((Project)project).findClass(repositoryBaseClassName, GlobalSearchScope.allScope((Project)project));
        return repositoryClass == null ? Collections.emptyList() : RepositoriesSearchUtil.getRepositoriesCustomBeans(scope, repositoryClass, project);
    }

    private static List<CommonSpringBean> getRepositoriesCustomBeans(@NotNull GlobalSearchScope scope, @NotNull PsiClass repositoryClass, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        ArrayList<CommonSpringBean> beans = new ArrayList<CommonSpringBean>();
        beans.addAll(RepositoriesSearchUtil.getRepositoryInterfaceInheritors(scope, repositoryClass));
        beans.addAll(RepositoriesSearchUtil.getRepositoryDefinitions(scope, project));
        return beans;
    }

    private static List<CommonSpringBean> getRepositoryInterfaceInheritors(GlobalSearchScope scope, PsiClass repositoryClass) {
        CommonProcessors.CollectProcessor<PsiClass> collectProcessor = new CommonProcessors.CollectProcessor<PsiClass>(){

            protected boolean accept(PsiClass psiClass) {
                return !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.NoRepositoryBean", (boolean)false);
            }
        };
        ClassInheritorsSearch.search((PsiClass)repositoryClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)collectProcessor);
        return ContainerUtil.map((Collection)collectProcessor.getResults(), CustomSpringComponent::new);
    }

    @NotNull
    public static List<SpringRepositoryDefinition> getRepositoryDefinitions(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoryDefinitions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoryDefinitions"));
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamClassElements(SpringRepositoryDefinition.META, "org.springframework.data.repository.RepositoryDefinition", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/utils/model/RepositoriesSearchUtil", "getRepositoryDefinitions"));
        }
        return list;
    }
}

