/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.VtlMacroImpl;
import com.intellij.velocity.psi.files.VtlFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlImplicitVariable
extends RenameableFakePsiElement
implements VtlVariable {
    @Nullable
    private final PsiElement myComment;
    private final String myName;
    private String myType;
    private final VtlFile myScopeFile;
    private PsiType myPsiType;

    public VtlImplicitVariable(@NotNull PsiElement parent, @Nullable PsiElement comment, @NotNull String name, @Nullable VtlFile scopeFile) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/velocity/psi/VtlImplicitVariable", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlImplicitVariable", "<init>"));
        }
        super(parent);
        this.myComment = comment;
        this.myName = name;
        this.myScopeFile = scopeFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlImplicitVariable", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        VtlParameterDeclaration parameter;
        PsiElement parent = this.getParent();
        if (parent instanceof VtlMacroImpl && (parameter = ((VtlMacroImpl)parent).findParameter(this.getName())) != null) {
            VtlParameterDeclaration vtlParameterDeclaration = parameter;
            if (vtlParameterDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlImplicitVariable", "getNavigationElement"));
            }
            return vtlParameterDeclaration;
        }
        PsiElement psiElement = this.myComment != null ? this.myComment : parent;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlImplicitVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    public boolean isValid() {
        return this.myComment == null || super.isValid();
    }

    public PsiElement getParent() {
        return this.myComment;
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.variable", new Object[0]);
    }

    public String toString() {
        return "ImplicitVariable " + this.myName;
    }

    public void setType(String type) {
        this.myType = type;
    }

    public void setPsiType(PsiType psiType) {
        this.myPsiType = psiType;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        if (this.myPsiType != null && this.myPsiType.isValid()) {
            return this.myPsiType;
        }
        if (this.myType == null) {
            return null;
        }
        try {
            PsiTypeCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)this.getProject()).createTypeCodeFragment(this.myType, null, false);
            fragment.forceResolveScope(this.getResolveScope());
            return fragment.getType();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        catch (PsiTypeCodeFragment.IncorrectTypeException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    public boolean isVisibleIn(@Nullable VtlFile placeFile) {
        return placeFile == null || this.myScopeFile == null || placeFile.isEquivalentTo(this.myScopeFile);
    }

    @Nullable
    public static VtlImplicitVariable findImplicitCounterpart(VtlVariable variable) {
        final String name = variable.getName();
        if (name == null) {
            return null;
        }
        final Ref ref = Ref.create(null);
        variable.getContainingFile().processDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/psi/VtlImplicitVariable$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/VtlImplicitVariable$1", "execute"));
                }
                if (element instanceof VtlImplicitVariable && name.equals(((VtlImplicitVariable)element).getName())) {
                    ref.set((Object)((VtlImplicitVariable)element));
                    return false;
                }
                return true;
            }
        }, ResolveState.initial(), null, (PsiElement)variable);
        return (VtlImplicitVariable)ref.get();
    }
}

