/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityPropertiesProvider {
    private static final String VELOCIMACRO_LIBRARY_PROPERTY = "velocimacro.library";
    private static final String FILE_RESOURCE_LOADER_PATH_PROPERTY = "file.resource.loader.path";
    private final PropertiesFile myPropertiesFile;
    @Nullable
    private final VirtualFile myRuntimeRoot;

    public VelocityPropertiesProvider(@NotNull PropertiesFile file, @Nullable VirtualFile runtimeRoot) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "<init>"));
        }
        this.myPropertiesFile = file;
        this.myRuntimeRoot = runtimeRoot;
    }

    public VelocityPropertiesProvider(@NotNull PropertiesFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "<init>"));
        }
        this.myPropertiesFile = file;
        this.myRuntimeRoot = null;
    }

    @NotNull
    public List<VirtualFile> getResourceLoaderPathListBasedOn(@Nullable VirtualFile baseFile) {
        if (this.myRuntimeRoot != null) {
            baseFile = this.myRuntimeRoot;
        }
        if (baseFile == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getResourceLoaderPathListBasedOn"));
            }
            return list;
        }
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        for (String loaderPath : this.getResourceLoaderPathList()) {
            VirtualFile loaderPathFile = baseFile.findFileByRelativePath(loaderPath);
            if (loaderPathFile == null) continue;
            res.add(loaderPathFile);
        }
        ArrayList<VirtualFile> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getResourceLoaderPathListBasedOn"));
        }
        return arrayList;
    }

    public String[] getResourceLoaderPathList() {
        String[] stringArray;
        String value = this.getValue(FILE_RESOURCE_LOADER_PATH_PROPERTY);
        if (value.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".";
        } else {
            stringArray = VelocityPropertiesProvider.splitAndTrim(value);
        }
        return stringArray;
    }

    private static String[] splitAndTrim(String values) {
        String[] array = values.split(",");
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    @NotNull
    public List<VtlFile> getVelocimacroLibraryListBasedOn(@Nullable VirtualFile baseFile) {
        if (this.myRuntimeRoot != null) {
            baseFile = this.myRuntimeRoot;
        }
        String[] libNames = this.getVelocimacroLibraryNames();
        if (baseFile == null || libNames.length == 0) {
            List<VtlFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getVelocimacroLibraryListBasedOn"));
            }
            return list;
        }
        PsiManager manager = this.myPropertiesFile.getContainingFile().getManager();
        ArrayList<VtlFile> res = new ArrayList<VtlFile>();
        for (VirtualFile loaderPathFile : this.getResourceLoaderPathListBasedOn(baseFile)) {
            for (int i = libNames.length - 1; i >= 0; --i) {
                PsiFile libPsiFile;
                FileViewProvider viewProvider;
                VirtualFile libFile = loaderPathFile.findFileByRelativePath(libNames[i]);
                if (libFile == null || (viewProvider = manager.findViewProvider(libFile)) == null || !((libPsiFile = viewProvider.getPsi((Language)VtlLanguage.INSTANCE)) instanceof VtlFile)) continue;
                ContainerUtil.addIfNotNull(res, (Object)((VtlFile)libPsiFile));
            }
        }
        ArrayList<VtlFile> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getVelocimacroLibraryListBasedOn"));
        }
        return arrayList;
    }

    @NotNull
    public PropertiesFile getPropertiesFile() {
        PropertiesFile propertiesFile = this.myPropertiesFile;
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getPropertiesFile"));
        }
        return propertiesFile;
    }

    @NotNull
    public String[] getVelocimacroLibraryNames() {
        String value = this.getValue(VELOCIMACRO_LIBRARY_PROPERTY);
        String[] stringArray = value.length() == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : VelocityPropertiesProvider.splitAndTrim(value);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getVelocimacroLibraryNames"));
        }
        return stringArray;
    }

    @NotNull
    private String getValue(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getValue"));
        }
        IProperty resourceLoaderPathProp = this.myPropertiesFile.findPropertyByKey(key);
        if (resourceLoaderPathProp == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getValue"));
            }
            return "";
        }
        String val = resourceLoaderPathProp.getValue();
        String string = val != null ? val : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VelocityPropertiesProvider", "getValue"));
        }
        return string;
    }
}

