/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ManageDataSourcesAction
extends AnAction
implements DumbAware {
    static DbDataSource getDataSourceFromEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ManageDataSourcesAction", "getDataSourceFromEvent"));
        }
        PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DatabaseSystem system = (DatabaseSystem)ObjectUtils.coalesce((Object)DataGridUtil.getDatabaseSystem(dataGrid), (Object)DbImplUtil.getForcedDataSource(file), (Object)PsiTreeUtil.getParentOfType((PsiElement)element, DbDataSource.class, (boolean)false));
        return (DbDataSource)ObjectUtils.tryCast((Object)system, DbDataSource.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ManageDataSourcesAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataSourceManagerDialog.showDialog(project, ManageDataSourcesAction.getDataSourceFromEvent(e));
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        boolean mainMenu = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
        if (mainMenu) {
            e.getPresentation().setText("Data Sources...");
        } else if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText("Properties");
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
        DbDataSource dataSource = (DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element, DbDataSource.class, (boolean)false);
        boolean toolbarPlace = ActionPlaces.isToolbarPlace((String)e.getPlace());
        boolean bl = enabled = facade != null && (toolbarPlace || dataSource != null && element == dataSource);
        if (PlatformUtils.isDatabaseIDE()) {
            KeyboardShortcut shortcut;
            boolean flag = e.getProject() != null && (mainMenu || enabled);
            e.getPresentation().setEnabledAndVisible(flag);
            if (!(enabled || keyEvent == null || (shortcut = e.getActionManager().getKeyboardShortcut(e.getActionManager().getId((AnAction)this))) != null && Comparing.equal((Object)KeyStroke.getKeyStrokeForEvent(keyEvent), (Object)shortcut.getFirstKeyStroke()))) {
                e.getPresentation().setEnabled(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(enabled);
        }
    }
}

