/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliComponent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public interface CliPanelDecorator {
    public JComponent decorate(@NotNull HideableTitledPanel var1, @NotNull JComponent var2, @NotNull List<CliComponent> var3);

    public static class DefaultCliPanelDecorator
    implements CliPanelDecorator {
        private static final String EXEC_PATH = "Path to %s: ";
        private static final int WIDTH = 2;
        private static final int GAP = 6;
        private final String myName;

        public DefaultCliPanelDecorator(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "<init>"));
            }
            this.myName = name;
        }

        @Override
        public JComponent decorate(@NotNull HideableTitledPanel titledPanel, @NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
            if (titledPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titledPanel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "decorate"));
            }
            if (pathComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "decorate"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "decorate"));
            }
            JComponent hideable = this.getHideablePanel(pathComponent, components);
            JComponent visible = DefaultCliPanelDecorator.getAlwaysVisiblePanel(components);
            titledPanel.setContentComponent(hideable);
            JPanel panel = new JPanel((LayoutManager)new VerticalLayout(6));
            panel.add((Component)titledPanel);
            panel.add(visible);
            return panel;
        }

        @NotNull
        private JComponent getHideablePanel(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
            if (pathComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "getHideablePanel"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "getHideablePanel"));
            }
            JPanel panel = new JPanel(new GridBagLayout());
            JBLabel pathLabel = new JBLabel(String.format(EXEC_PATH, this.myName));
            GridBagConstraints gbc = DefaultCliPanelDecorator.createConstraints();
            DefaultCliPanelDecorator.add(panel, (JComponent)pathLabel, gbc);
            DefaultCliPanelDecorator.span(gbc);
            DefaultCliPanelDecorator.add(panel, pathComponent, gbc);
            DefaultCliPanelDecorator.addComponents(panel, gbc, ContainerUtil.filter(components, CliComponent::isHideable));
            JPanel jPanel = panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "getHideablePanel"));
            }
            return jPanel;
        }

        @NotNull
        private static JComponent getAlwaysVisiblePanel(@NotNull List<CliComponent> components) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "getAlwaysVisiblePanel"));
            }
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = DefaultCliPanelDecorator.createConstraints();
            DefaultCliPanelDecorator.addComponents(panel, gbc, ContainerUtil.filter(components, (Condition)Conditions.not(CliComponent::isHideable)));
            JPanel jPanel = panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "getAlwaysVisiblePanel"));
            }
            return jPanel;
        }

        private static void addComponents(@NotNull JPanel panel, @NotNull GridBagConstraints gbc, @NotNull List<CliComponent> components) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponents"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponents"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponents"));
            }
            for (CliComponent component : components) {
                DefaultCliPanelDecorator.addComponent(panel, component, gbc);
            }
        }

        private static GridBagConstraints createConstraints() {
            GridBagConstraints gbc = new GridBagConstraints();
            DefaultCliPanelDecorator.reset(gbc);
            return gbc;
        }

        private static void reset(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "reset"));
            }
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            DefaultCliPanelDecorator.noSpan(gbc);
        }

        private static void addComponent(@NotNull JPanel panel, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponent"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponent"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addComponent"));
            }
            if (component.getLabel() == null) {
                DefaultCliPanelDecorator.addSimple(panel, component, gbc);
                return;
            }
            DefaultCliPanelDecorator.addLabeled(panel, component, gbc);
        }

        private static void addSimple(@NotNull JPanel panel, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addSimple"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addSimple"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addSimple"));
            }
            DefaultCliPanelDecorator.noSpan(gbc);
            DefaultCliPanelDecorator.add(panel, component.getComponent(), gbc);
        }

        private static void addLabeled(@NotNull JPanel panel, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addLabeled"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addLabeled"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "addLabeled"));
            }
            DefaultCliPanelDecorator.noSpan(gbc);
            DefaultCliPanelDecorator.nextLine(gbc);
            DefaultCliPanelDecorator.add(panel, (JComponent)new JBLabel(component.getLabel() + ": "), gbc);
            DefaultCliPanelDecorator.span(gbc);
            DefaultCliPanelDecorator.add(panel, component.getComponent(), gbc);
        }

        private static void nextLine(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "nextLine"));
            }
            gbc.gridx = 0;
            ++gbc.gridy;
        }

        private static void noSpan(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "noSpan"));
            }
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
        }

        private static void span(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "span"));
            }
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
        }

        private static void nextCell(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "nextCell"));
            }
            if (gbc.gridx == 1) {
                gbc.gridx = 0;
                ++gbc.gridy;
                return;
            }
            ++gbc.gridx;
        }

        private static void add(@NotNull JPanel panel, @NotNull JComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "add"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "add"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator", "add"));
            }
            panel.add((Component)component, gbc);
            DefaultCliPanelDecorator.nextCell(gbc);
        }
    }
}

