/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliComboBox
extends CliComponent {
    private final CliArgumentGroup<DefaultValueCliArgument> myGroup;
    private final ComboBox<CliArgument> myCombo;

    public CliComboBox(@NotNull CliArgumentGroup<DefaultValueCliArgument> group2) {
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/cli/component/CliComboBox", "<init>"));
        }
        if (((DefaultValueCliArgument[])group2.getArguments()).length == 0) {
            throw new IllegalArgumentException("Empty argument group");
        }
        this.myGroup = group2;
        this.myCombo = new ComboBox(new DefaultComboBoxModel<CliArgument>(group2.getArguments()));
        this.myCombo.setRenderer((ListCellRenderer)((Object)new DumpComboRenderer()));
        this.myCombo.addItemListener(e -> this.fireComponentChanged());
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ComboBox<CliArgument> comboBox = this.myCombo;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getComponent"));
        }
        return comboBox;
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.myGroup.getUiName();
    }

    @Override
    @NotNull
    public DefaultValueCliArgument getArgument() {
        DefaultValueCliArgument defaultValueCliArgument = (DefaultValueCliArgument)this.myCombo.getSelectedItem();
        if (defaultValueCliArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getArgument"));
        }
        return defaultValueCliArgument;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliComboBox", "getFullArgument"));
        }
        String string = this.getArgument().getCommandLineArgument(cd);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getFullArgument"));
        }
        return string;
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliComboBox", "isMyLexeme"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/component/CliComboBox", "isMyLexeme"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/component/CliComboBox", "isMyLexeme"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliComboBox", "isMyLexeme"));
        }
        return !ContainerUtil.filter((Object[])this.myGroup.getArguments(), DbCliUtil.argumentFinder(text, current, next, cd)).isEmpty();
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliComboBox", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/component/CliComboBox", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/component/CliComboBox", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliComboBox", "changeState"));
        }
        CliArgument arg = (CliArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DbCliUtil.argumentFinder(text, current, next, cd));
        this.myCombo.setSelectedItem((Object)(arg == null ? this.getFirst() : arg));
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliComboBox", "reset"));
        }
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @NotNull
    public CliArgument getDefault() {
        CliArgument arg = (CliArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DefaultValueCliArgument::isOnByDefault);
        CliArgument cliArgument = arg == null ? this.getFirst() : arg;
        if (cliArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getDefault"));
        }
        return cliArgument;
    }

    @NotNull
    private CliArgument getFirst() {
        CliArgument cliArgument = (CliArgument)ObjectUtils.assertNotNull((Object)ArrayUtil.getFirstElement((Object[])this.myGroup.getArguments()));
        if (cliArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getFirst"));
        }
        return cliArgument;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myGroup.getUiName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliComboBox", "getName"));
        }
        return string;
    }

    private static class DumpComboRenderer
    extends ListCellRendererWrapper<CliArgument> {
        private DumpComboRenderer() {
        }

        public void customize(JList list, CliArgument value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.setText(value.getUiName());
            }
        }
    }
}

