/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.pg;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.PostgresConfigurationBase;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.restore.pg.PgRestoreArguments;
import com.intellij.database.cli.restore.pg.PgRestoreArgumentsGroup;
import com.intellij.database.cli.restore.pg.PgRestoreDialogValidator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgRestoreConfiguration
extends PostgresConfigurationBase {
    public static final PgRestoreConfiguration INSTANCE = new PgRestoreConfiguration();
    private static final MyFileSearcher FILE_SEARCHER = new MyFileSearcher();

    private PgRestoreConfiguration() {
        super(PgRestoreArgumentsGroup.values(), (String[])ContainerUtil.ar((Object[])new String[]{""}), "PG_RESTORE_PROPERTIES", "pg_restore");
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map = super.getInfoMap();
        PgRestoreConfiguration.put(map, "Restore definition of named index only", PgRestoreArguments.INDEX);
        PgRestoreConfiguration.put(map, "Deprecated (ignored)", PgRestoreArguments.IGNORE_VERSION);
        PgRestoreConfiguration.put(map, "List archive content", PgRestoreArguments.LIST);
        PgRestoreConfiguration.put(map, "Restore matched triggers", PgRestoreArguments.TRIGGER);
        PgRestoreConfiguration.put(map, "Restore only listed elements", PgRestoreArguments.USE_LIST);
        PgRestoreConfiguration.put(map, "Restore the named function only", PgRestoreArguments.FUNCTION);
        PgRestoreConfiguration.put(map, "Disable triggers", PgRestoreArguments.DISABLE_TRIGGERS);
        PgRestoreConfiguration.put(map, "Disable triggers", "--no-data-for-failed-tables");
        PgRestoreConfiguration.put(map, "Exit on error", PgRestoreArguments.EXIT_ON_ERROR);
        PgRestoreConfiguration.put(map, "Use conditional commands", "--if-exists");
        PgRestoreConfiguration.put(map, "Restore only the data", CommonPgArguments.DATA_ONLY);
        PgRestoreConfiguration.put(map, "Clean database before restore", CommonPgArguments.CLEAN_DATABASE);
        PgRestoreConfiguration.put(map, "Create database before restore", CommonPgArguments.CREATE_DATABASE);
        PgRestoreConfiguration.put(map, "Input format", CommonPgArguments.FORMAT);
        PgRestoreConfiguration.put(map, "Restore only matched schemas", CommonPgArguments.SCHEMA);
        PgRestoreConfiguration.put(map, "Restore only data definition", CommonPgArguments.SCHEMA_ONLY);
        PgRestoreConfiguration.put(map, "Restore matched tables", CommonPgArguments.TABLE);
        PgRestoreConfiguration.put(map, "Don't restore security labels", "--no-security-labels");
        PgRestoreConfiguration.put(map, "Restore only matched section", CommonPgArguments.SECTION);
        Map<String, String> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getInfoMap"));
        }
        return map2;
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        if ("pg_restore" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getPartOfValidationOut"));
        }
        return "pg_restore";
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + "/pg_restore";
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterSearcher getFileParameterSearcher() {
        MyFileSearcher myFileSearcher = FILE_SEARCHER;
        if (myFileSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getFileParameterSearcher"));
        }
        return myFileSearcher;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        PgRestoreDialogValidator pgRestoreDialogValidator = new PgRestoreDialogValidator();
        if (pgRestoreDialogValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getValidator"));
        }
        return pgRestoreDialogValidator;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat((List)ContainerUtil.list((Object[])new String[]{"-I", "-L"}), super.getParameterizableArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getParameterizableArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.RESTORE;
        if (operation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getOperation"));
        }
        return operation;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.DATABASE, (boolean)false))).onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).requireNotEmpty().finish().endIf().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.or((Condition)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA), (Condition)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).finish().endIf().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.SCHEMA, (boolean)false))).onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.not((Condition)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).endIf().finish();
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getObjectsPreparer"));
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getCliBuilder"));
        }
        MyBuilder myBuilder = new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName());
        if (myBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration", "getCliBuilder"));
        }
        return myBuilder;
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "<init>"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "<init>"));
            }
            if (envName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envName", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "<init>"));
            }
            super(processor, project, operation, name, envName);
        }

        @Override
        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "getArguments"));
            }
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "getArguments"));
            }
            String file = FILE_SEARCHER.search(command, parameterizable);
            if (file == null) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "getArguments"));
                }
                return list;
            }
            String withoutFile = command.replace(file, "");
            List<String> list = super.getArguments(parameterizable, withoutFile + " " + file);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder", "getArguments"));
            }
            return list;
        }
    }

    private static class MyFileSearcher
    implements CliConfiguration.CliParameterSearcher {
        private MyFileSearcher() {
        }

        @Override
        @Nullable
        public String search(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyFileSearcher", "search"));
            }
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyFileSearcher", "search"));
            }
            List lexemes = ContainerUtil.subList(DbCliUtil.filteredLexemes(command, parameterizable), (int)1);
            return Optional.ofNullable(ContainerUtil.find((Iterable)lexemes, l -> l.isParameter())).map(l -> l.getText()).orElse(null);
        }
    }
}

