/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.AbstractTableResult;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.OwnerBasedExpressionEvaluator;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.fragments.SqlCodeFragment;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsoleEvaluationSupport
extends DebuggerSupport {
    private final DebuggerActionHandler myEvaluateHandler = new ConsoleEvaluateHandler();
    private final ConsoleQuickEvaluateHandler myQuickHandler = new ConsoleQuickEvaluateHandler();
    private final BreakpointPanelProvider<?> myBreakpointProvider = new MyMockBreakpointPanelProvider();

    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        BreakpointPanelProvider<?> breakpointPanelProvider = this.myBreakpointProvider;
        if (breakpointPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "getBreakpointPanelProvider"));
        }
        return breakpointPanelProvider;
    }

    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        DebuggerActionHandler debuggerActionHandler = this.myEvaluateHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "getEvaluateHandler"));
        }
        return debuggerActionHandler;
    }

    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        ConsoleQuickEvaluateHandler consoleQuickEvaluateHandler = this.myQuickHandler;
        if (consoleQuickEvaluateHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "getQuickEvaluateHandler"));
        }
        return consoleQuickEvaluateHandler;
    }

    private static boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "isEnabled"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "isEnabled"));
        }
        return JdbcConsoleEvaluationSupport.isEnabled(project, JdbcConsole.getConsole(event));
    }

    private static boolean isEnabled(@NotNull Project project, @Nullable JdbcConsole console) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport", "isEnabled"));
        }
        DbDataSource source = console == null ? null : DbImplUtil.getDbDataSource(project, (DatabaseSystem)console.getDataSource());
        return source != null && DbImplUtil.canConnectTo((DbElement)source);
    }

    public static class PositionInfo {
        public final int offset;
        public final TextRange range;

        private PositionInfo(@Nullable TextRange range, int offset) {
            this.range = range;
            this.offset = offset;
        }

        @NotNull
        static PositionInfo forPoint(@NotNull Point point, @NotNull Editor editor) {
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "forPoint"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "forPoint"));
            }
            PositionInfo positionInfo = new PositionInfo(PositionInfo.getRange(point, editor), AbstractValueHint.calculateOffset((Editor)editor, (Point)point));
            if (positionInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "forPoint"));
            }
            return positionInfo;
        }

        @Nullable
        private static TextRange getRange(@NotNull Point point, @NotNull Editor editor) {
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "getRange"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "getRange"));
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            int offset = AbstractValueHint.calculateOffset((Editor)editor, (Point)point);
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            boolean inSelection = selectionModel.hasSelection() && start <= offset && end >= offset;
            return inSelection ? new TextRange(start, end) : null;
        }

        @NotNull
        public static PositionInfo forEditor(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "forEditor"));
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            PositionInfo positionInfo = new PositionInfo(selectionModel.hasSelection() ? new TextRange(start, end) : null, start);
            if (positionInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$PositionInfo", "forEditor"));
            }
            return positionInfo;
        }
    }

    private static class MyMockBreakpointPanelProvider
    extends BreakpointPanelProvider<Object> {
        private MyMockBreakpointPanelProvider() {
        }

        public void createBreakpointsGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        }

        public void addListener(BreakpointPanelProvider.BreakpointsListener listener, Project project, Disposable disposable) {
        }

        protected void removeListener(BreakpointPanelProvider.BreakpointsListener listener) {
        }

        public int getPriority() {
            return 0;
        }

        @Nullable
        public Object findBreakpoint(@NotNull Project project, @NotNull Document document, int offset) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyMockBreakpointPanelProvider", "findBreakpoint"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyMockBreakpointPanelProvider", "findBreakpoint"));
            }
            return null;
        }

        @Nullable
        public GutterIconRenderer getBreakpointGutterIconRenderer(Object breakpoint) {
            return null;
        }

        public void onDialogClosed(Project project) {
        }

        public void provideBreakpointItems(Project project, Collection<BreakpointItem> items) {
        }
    }

    private static enum MyInfoFactory {
        DAS_OBJECT{

            @NotNull
            MyDasInfo create(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @Nullable Disposable parent, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "create"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "create"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "create"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "create"));
                }
                Pair pair = (Pair)ObjectUtils.notNull((Object)MyInfoFactory.getDasRangePair(console, position));
                DasObject object = (DasObject)pair.getFirst();
                TextRange range = (TextRange)pair.getSecond();
                MyDasInfo myDasInfo = new MyDasInfo(console, parent, dialect, dataSource, searchPath, object, console.getProject(), range);
                if (myDasInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "create"));
                }
                return myDasInfo;
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "isEnabled"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "isEnabled"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "isEnabled"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "isEnabled"));
                }
                return MyInfoFactory.getDasRangePair(console, position) != null;
            }

            @Override
            int priority(@NotNull JdbcConsole console) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$1", "priority"));
                }
                return console.getLanguageConsole().getCurrentEditor().getSelectionModel().hasSelection() ? 2 : 1;
            }
        }
        ,
        SQL_ELEMENT{

            @NotNull
            MyPsiInfo create(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @Nullable Disposable parent, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "create"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "create"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "create"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "create"));
                }
                EditorEx editor = console.getLanguageConsole().getCurrentEditor();
                SqlExpression expression = PsiRequestor.getExpression(editor, console.getProject(), position);
                MyPsiInfo myPsiInfo = new MyPsiInfo(console, parent, dialect, dataSource, searchPath, (SqlElement)ObjectUtils.notNull((Object)expression), console.getProject());
                if (myPsiInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "create"));
                }
                return myPsiInfo;
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "isEnabled"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "isEnabled"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "isEnabled"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "isEnabled"));
                }
                return !PsiRequestor.isUnsupportedExpression(PsiRequestor.getExpression(console.getLanguageConsole().getCurrentEditor(), console.getProject(), position));
            }

            @Override
            int priority(@NotNull JdbcConsole console) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$2", "priority"));
                }
                return console.getLanguageConsole().getCurrentEditor().getSelectionModel().hasSelection() ? 3 : 2;
            }
        }
        ,
        SELECTED_CODE_FRAGMENT{

            @NotNull
            MyTextInfo create(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @Nullable Disposable parent, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "create"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "create"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "create"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "create"));
                }
                MyTextInfo myTextInfo = new MyTextInfo(console, parent, dialect, dataSource, searchPath, console.getProject());
                if (myTextInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "create"));
                }
                return myTextInfo;
            }

            @Override
            boolean isEnabled(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @NotNull PositionInfo position) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "isEnabled"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "isEnabled"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "isEnabled"));
                }
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "isEnabled"));
                }
                TextRange range = ScriptModelUtil.getSelectedStatementsRange(console);
                return range.contains(position.offset) && JdbcConsole.getQueryText(console) != null;
            }

            @Override
            int priority(@NotNull JdbcConsole console) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory$3", "priority"));
                }
                return console.getLanguageConsole().getCurrentEditor().getSelectionModel().hasSelection() ? 1 : 3;
            }
        };


        abstract int priority(@NotNull JdbcConsole var1);

        @NotNull
        abstract MyEvaluableInfo<?> create(@NotNull JdbcConsole var1, @NotNull DatabaseDialectEx var2, @NotNull DbDataSource var3, @Nullable List<DasNamespace> var4, @Nullable Disposable var5, @NotNull PositionInfo var6);

        abstract boolean isEnabled(@NotNull JdbcConsole var1, @NotNull DatabaseDialectEx var2, @NotNull DbDataSource var3, @NotNull PositionInfo var4);

        @Nullable
        static MyEvaluableInfo<?> getInfo(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @Nullable Disposable parent, @NotNull PositionInfo position) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getInfo"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getInfo"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getInfo"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getInfo"));
            }
            MyInfoFactory[] values = MyInfoFactory.values();
            Arrays.sort(values, Comparator.comparingInt(o -> {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "lambda$getInfo$0"));
                }
                return o.priority(console);
            }));
            for (MyInfoFactory mode : values) {
                MyEvaluableInfo<?> info;
                if (!mode.isEnabled(console, dialect, dataSource, position) || !(info = mode.create(console, dialect, dataSource, searchPath, parent, position)).isEnabled()) continue;
                return info;
            }
            return null;
        }

        @Nullable
        private static Pair<DasObject, TextRange> getDasRangePair(@NotNull JdbcConsole console, @NotNull PositionInfo position) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getDasRangePair"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getDasRangePair"));
            }
            EditorEx editor = console.getLanguageConsole().getCurrentEditor();
            VirtualFile vFile = editor.getVirtualFile();
            if (vFile == null) {
                return null;
            }
            PsiFile file = PsiUtilCore.getPsiFile((Project)console.getProject(), (VirtualFile)vFile);
            return MyInfoFactory.getSelectedReference(editor, file, position);
        }

        @Nullable
        private static Pair<DasObject, TextRange> getSelectedReference(@NotNull EditorEx editor, @NotNull PsiFile file, @NotNull PositionInfo position) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getSelectedReference"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getSelectedReference"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getSelectedReference"));
            }
            Pair<DasObject, TextRange> reference = MyInfoFactory.getFromElement(editor, file, SqlReferenceExpression.class, e -> e, position);
            Function function = e -> {
                SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)e, SqlAsExpression.class);
                return asExpression == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)asExpression.getExpression(), SqlReferenceExpression.class);
            };
            return reference == null ? MyInfoFactory.getFromElement(editor, file, SqlIdentifier.class, function, position) : reference;
        }

        @Nullable
        private static <T extends SqlElement> Pair<DasObject, TextRange> getFromElement(@NotNull EditorEx editor, @NotNull PsiFile file, @NotNull Class<T> clazz, @NotNull Function<T, SqlReferenceExpression> fun, @NotNull PositionInfo position) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getFromElement"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getFromElement"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getFromElement"));
            }
            if (fun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getFromElement"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyInfoFactory", "getFromElement"));
            }
            int start = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)position.offset);
            SqlElement element = position.range != null ? (SqlElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)position.range.getStartOffset(), (int)position.range.getEndOffset(), clazz) : (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), clazz);
            return element == null ? null : MyInfoFactory.fromSqlReference((SqlReferenceExpression)fun.fun((Object)element));
        }

        @Nullable
        private static Pair<DasObject, TextRange> fromSqlReference(@Nullable SqlReferenceExpression reference) {
            DasObject object = reference == null ? null : (DasObject)ObjectUtils.tryCast((Object)reference.resolve(), DasObject.class);
            return object == null ? null : Pair.create((Object)object, (Object)reference.getTextRange());
        }
    }

    private static class MyXValueHint
    extends XValueHint {
        public MyXValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider provider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (expressionInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "<init>"));
            }
            super(project, provider, editor, point, type, expressionInfo, evaluator, false);
        }

        @NotNull
        protected JComponent createHintComponent(@NotNull SimpleColoredText text, @NotNull XValuePresentation presentation, @Nullable XFullValueEvaluator evaluator) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "createHintComponent"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "createHintComponent"));
            }
            JComponent jComponent = presentation instanceof AbstractTableResult.TablePresentation ? ((AbstractTableResult.TablePresentation)presentation).presentationComponent(this.getEditor()) : super.createHintComponent(text, presentation, evaluator);
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyXValueHint", "createHintComponent"));
            }
            return jComponent;
        }
    }

    private static class MyValue
    extends XValue {
        private final DatabaseExpressionEvaluator.Result myResult;

        private MyValue(@NotNull DatabaseExpressionEvaluator.Result result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyValue", "<init>"));
            }
            this.myResult = result2;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyValue", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyValue", "computePresentation"));
            }
            this.myResult.computePresentation(node, place);
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyValue", "computeChildren"));
            }
            this.myResult.computeChildren(node);
        }
    }

    private static class MyPsiInfo
    extends MyEvaluableInfo<SqlElement> {
        private final SqlElement myElement;

        MyPsiInfo(@NotNull JdbcConsole console, @Nullable Disposable parent, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @Nullable List<DasNamespace> searchPath, @NotNull SqlElement element, @NotNull Project project) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "<init>"));
            }
            super(new OwnerBasedExpressionEvaluator.PsiExpressionEvaluator(console, dialect, source, searchPath, project, parent));
            this.myElement = element;
        }

        @Override
        @Nullable
        public String getQueryIfAny() {
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(this.myElement);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }

        @Override
        @NotNull
        SqlElement getValue(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "getValue"));
            }
            SqlElement sqlElement = this.myElement;
            if (sqlElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "getValue"));
            }
            return sqlElement;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myElement.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyPsiInfo", "getRange"));
            }
            return textRange;
        }
    }

    private static class MyDasInfo
    extends MyEvaluableInfo<DasObject> {
        private final TextRange myRange;
        private final DasObject myObject;

        public MyDasInfo(@NotNull JdbcConsole console, @Nullable Disposable parent, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @Nullable List<DasNamespace> searchPath, @NotNull DasObject object, @NotNull Project project, @NotNull TextRange range) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "<init>"));
            }
            super(new OwnerBasedExpressionEvaluator.DasObjectEvaluator(console, dialect, source, searchPath, project, parent));
            this.myObject = object;
            this.myRange = range;
        }

        @Override
        @Nullable
        String getQueryIfAny() {
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(this.myObject);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }

        @Override
        @NotNull
        DasObject getValue(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "getValue"));
            }
            DasObject dasObject = this.myObject;
            if (dasObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "getValue"));
            }
            return dasObject;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyDasInfo", "getRange"));
            }
            return textRange;
        }
    }

    private static class MyTextInfo
    extends MyEvaluableInfo<String> {
        private final Disposable myParent;
        private final DatabaseDialectEx myDialect;
        private final DbDataSource mySource;
        private final List<DasNamespace> mySearchPath;
        private final Project myProject;
        private final JdbcConsole myConsole;

        MyTextInfo(@NotNull JdbcConsole console, @Nullable Disposable parent, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @Nullable List<DasNamespace> searchPath, @NotNull Project project) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            this(new OwnerBasedExpressionEvaluator.TextExpressionEvaluator(console, dialect, source, searchPath, project, parent), console, parent, dialect, source, searchPath, project);
        }

        private MyTextInfo(@NotNull OwnerBasedExpressionEvaluator<String> evaluator, @NotNull JdbcConsole console, @Nullable Disposable parent, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @Nullable List<DasNamespace> searchPath, @NotNull Project project) {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "<init>"));
            }
            super(evaluator);
            this.myConsole = console;
            this.myParent = parent;
            this.myDialect = dialect;
            this.mySource = source;
            this.mySearchPath = searchPath;
            this.myProject = project;
        }

        @NotNull
        public MyTextInfo fixedQuery() {
            MyTextInfo myTextInfo = new MyTextInfo(new OwnerBasedExpressionEvaluator.ImmutableTextExpressionEvaluator(this.myConsole, this.myDialect, this.mySource, this.mySearchPath, this.myProject, this.myParent), this.myConsole, this.myParent, this.myDialect, this.mySource, this.mySearchPath, this.myProject);
            if (myTextInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "fixedQuery"));
            }
            return myTextInfo;
        }

        @Override
        @NotNull
        public String getValue(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "getValue"));
            }
            String string = expression;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "getValue"));
            }
            return string;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = ScriptModelUtil.getSelectedStatementsRange(this.myConsole);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyTextInfo", "getRange"));
            }
            return textRange;
        }

        @Override
        @Nullable
        public String getQueryIfAny() {
            String query = (String)ObjectUtils.notNull((Object)JdbcConsole.getQueryText(this.myConsole));
            EvaluationRequestor<DataRequest.OwnerEx> requestor = this.myEvaluator.createRequestor(query);
            return requestor.isEmpty() ? null : requestor.getQuery();
        }
    }

    private static abstract class MyEvaluableInfo<V> {
        final OwnerBasedExpressionEvaluator<V> myEvaluator;

        protected MyEvaluableInfo(@NotNull OwnerBasedExpressionEvaluator<V> evaluator) {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo", "<init>"));
            }
            this.myEvaluator = evaluator;
        }

        @NotNull
        String getQuery() {
            String string = (String)ObjectUtils.notNull((Object)this.getQueryIfAny());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo", "getQuery"));
            }
            return string;
        }

        boolean isEnabled() {
            return this.getQueryIfAny() != null;
        }

        @NotNull
        MyProxy<V> proxy() {
            MyProxy myProxy = new MyProxy<V>(this.myEvaluator){

                @Override
                @NotNull
                public V getValue(@NotNull String expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo$1", "getValue"));
                    }
                    Object v = this.getValue(expression);
                    if (v == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo$1", "getValue"));
                    }
                    return v;
                }
            };
            if (myProxy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEvaluableInfo", "proxy"));
            }
            return myProxy;
        }

        @NotNull
        abstract TextRange getRange();

        @Nullable
        abstract String getQueryIfAny();

        @NotNull
        abstract V getValue(@NotNull String var1);
    }

    private static abstract class MyProxy<V>
    extends XDebuggerEvaluator {
        final OwnerBasedExpressionEvaluator<V> myEvaluator;

        protected MyProxy(@NotNull OwnerBasedExpressionEvaluator<V> evaluator) {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "<init>"));
            }
            this.myEvaluator = evaluator;
        }

        public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "evaluate"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "evaluate"));
            }
            CompletionStage future = this.myEvaluator.evaluate((Object)this.getValue(expression));
            ((CompletableFuture)future).whenComplete((r, e) -> {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "lambda$evaluate$1"));
                }
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "lambda$evaluate$1"));
                }
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "lambda$null$0"));
                    }
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "lambda$null$0"));
                    }
                    if (r != null) {
                        callback.evaluated((XValue)new MyValue((DatabaseExpressionEvaluator.Result)r));
                        return;
                    }
                    callback.errorOccurred(e == null ? "Can't evaluate: " + expression : e.getMessage());
                });
            });
        }

        @NotNull
        public abstract V getValue(@NotNull String var1);

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }

        public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "getEvaluationMode"));
            }
            return EvaluationMode.EXPRESSION;
        }

        @Nullable
        public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "getExpressionInfoAtOffset"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyProxy", "getExpressionInfoAtOffset"));
            }
            return null;
        }
    }

    private static class MyEditorProvider
    extends XDebuggerEditorsProvider {
        private final JdbcConsole myConsole;
        private final DbDataSource mySource;

        MyEditorProvider(@NotNull JdbcConsole console, @NotNull DbDataSource source) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "<init>"));
            }
            this.myConsole = console;
            this.mySource = source;
        }

        @NotNull
        public FileType getFileType() {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "getFileType"));
            }
            return sqlFileType;
        }

        @NotNull
        public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "createDocument"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "createDocument"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "createDocument"));
            }
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((DbElement)this.mySource);
            PsiCodeFragment fragment = sqlPsiFacade.createEvaluableExpressionFragment((Language)dialect, this.mySource, DatabaseEditorHelper.findNamespaces(project, (DatabaseSystem)this.mySource, this.myConsole.getSearchPath()), text);
            ObjectUtils.consumeIfCast((Object)fragment, SqlCodeFragment.class, f -> f.setContext((PsiElement)this.myConsole.getLanguageConsole().getFile()));
            Document document = (Document)ObjectUtils.notNull((Object)PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment));
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$MyEditorProvider", "createDocument"));
            }
            return document;
        }
    }

    private static class ConsoleQuickEvaluateHandler
    extends QuickEvaluateHandler {
        private ConsoleQuickEvaluateHandler() {
        }

        public boolean isEnabled(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "isEnabled"));
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return false;
            }
            Document document = editor.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            JdbcConsole console = JdbcConsole.getConsole(project, file);
            JComponent component = console != null ? console.getLanguageConsole().getCurrentEditor().getComponent() : null;
            try {
                return JdbcConsoleEvaluationSupport.isEnabled(project, console) && component != null && component.getMousePosition(true) != null;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Nullable
        public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, ValueHintType type) {
            DbDataSource source;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "createValueHint"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "createValueHint"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "createValueHint"));
            }
            JdbcConsole console = ConsoleQuickEvaluateHandler.getConsole(project, editor);
            if (console == null || type == ValueHintType.MOUSE_OVER_HINT) {
                return null;
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console.getDataSource());
            MyTextInfo evInfo = MyInfoFactory.getInfo(console, dialect, source = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, (DatabaseSystem)console.getDataSource())), DatabaseEditorHelper.findNamespaces(project, (DatabaseSystem)source, console.getSearchPath()), null, PositionInfo.forPoint(point, editor));
            if (evInfo == null || type == ValueHintType.MOUSE_CLICK_HINT && !JdbcConsole.beforeExecuteRange(console, ((MyEvaluableInfo)evInfo).getRange())) {
                return null;
            }
            MyEditorProvider provider = new MyEditorProvider(console, source);
            ExpressionInfo info = new ExpressionInfo(((MyEvaluableInfo)evInfo).getRange(), evInfo.getQuery());
            MyTextInfo trueInfo = evInfo instanceof MyTextInfo ? ((MyTextInfo)evInfo).fixedQuery() : evInfo;
            return new MyXValueHint(project, provider, editor, point, type, info, trueInfo.proxy());
        }

        @Nullable
        private static JdbcConsole getConsole(@NotNull Project project, @NotNull Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "getConsole"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "getConsole"));
            }
            FileDocumentManager instance = FileDocumentManager.getInstance();
            VirtualFile file = instance.getFile(editor.getDocument());
            return JdbcConsole.getConsole(project, file);
        }

        public boolean canShowHint(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "canShowHint"));
            }
            return true;
        }

        public int getValueLookupDelay(Project project) {
            return 0;
        }

        public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "isEnabled"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleQuickEvaluateHandler", "isEnabled"));
            }
            return JdbcConsoleEvaluationSupport.isEnabled(project, event);
        }
    }

    private static class ConsoleEvaluateHandler
    extends DebuggerActionHandler {
        private ConsoleEvaluateHandler() {
        }

        public void perform(@NotNull Project project, AnActionEvent event) {
            EditorEx editor;
            List<DasNamespace> searchPath;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleEvaluateHandler", "perform"));
            }
            JdbcConsole console = (JdbcConsole)ObjectUtils.notNull((Object)JdbcConsole.getConsole(event));
            LocalDataSource source = console.getDataSource();
            DbDataSource dbDataSource = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, (DatabaseSystem)source));
            Disposable disposable = Disposer.newDisposable();
            DatabaseDialectEx dbDialect = DbImplUtil.getDatabaseDialect(console);
            MyEvaluableInfo<?> info = MyInfoFactory.getInfo(console, dbDialect, dbDataSource, searchPath = DatabaseEditorHelper.findNamespaces(project, (DatabaseSystem)source, console.getSearchPath()), disposable, PositionInfo.forEditor((Editor)(editor = console.getLanguageConsole().getCurrentEditor())));
            String query = info == null ? StringUtil.notNullize((String)JdbcConsole.getQueryText(console)) : info.getQuery();
            TextRange range = info == null ? ScriptModelUtil.getSelectedStatementsRange(console) : info.getRange();
            ScriptModel subModel = console.getScriptModel().subModel(range, false);
            if (!(info == null && range.isEmpty() || subModel.statements().isEmpty() || JdbcConsole.beforeExecuteRange(console, range))) {
                return;
            }
            XExpressionImpl expression = new XExpressionImpl(query, console.getLanguageConsole().getLanguage(), null);
            MyEditorProvider provider = new MyEditorProvider(console, dbDataSource);
            OwnerBasedExpressionEvaluator.TextExpressionEvaluator evaluator = new OwnerBasedExpressionEvaluator.TextExpressionEvaluator(console, dbDialect, dbDataSource, searchPath, project, disposable);
            MyProxy<String> proxy = new MyProxy<String>((OwnerBasedExpressionEvaluator)evaluator){

                @Override
                @NotNull
                public String getValue(@NotNull String expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleEvaluateHandler$1", "getValue"));
                    }
                    String string = expression;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleEvaluateHandler$1", "getValue"));
                    }
                    return string;
                }
            };
            XDebuggerEvaluationDialog dialog = new XDebuggerEvaluationDialog((XDebuggerEvaluator)proxy, project, (XDebuggerEditorsProvider)provider, (XExpression)expression, null, false);
            Disposer.register((Disposable)dialog.getDisposable(), (Disposable)disposable);
            dialog.show();
        }

        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/JdbcConsoleEvaluationSupport$ConsoleEvaluateHandler", "isEnabled"));
            }
            return JdbcConsoleEvaluationSupport.isEnabled(project, event);
        }
    }
}

