/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvRecordFormatForm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatForm
implements Disposable {
    private JPanel myPanel;
    private JBCheckBox myHeaderFormatCheckBox;
    private JPanel myRecordFormatPanel;
    private JPanel myHeaderFormatPanel;
    private JBCheckBox myRowNumbersCheckBox;
    private JPanel myHeaderFormatWithTitlePanel;
    private String myFormatName;
    private CsvRecordFormatForm myRecordFormatForm;
    private CsvRecordFormatForm myHeaderFormatForm;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    private CsvFormat myFormat;

    public CsvFormatForm(@NotNull Disposable parent, final @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatForm", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/csv/ui/CsvFormatForm", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myHeaderFormatCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean headerEnabled = CsvFormatForm.this.myHeaderFormatCheckBox.isSelected();
                CsvFormatForm.this.myHeaderFormatWithTitlePanel.setVisible(headerEnabled && settings.isHeaderSettingsVisible());
                if (headerEnabled) {
                    CsvFormatForm.this.myHeaderFormatForm.reset(CsvFormatForm.this.myRecordFormatForm.getFormat());
                } else {
                    CsvFormatForm.this.fireFormatChangedEvent();
                }
            }
        });
        this.myRowNumbersCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvFormatForm.this.fireFormatChangedEvent();
            }
        });
        CsvRecordFormatForm.ChangeListener changeEventPropagator = new CsvRecordFormatForm.ChangeListener(){

            @Override
            public void recordFormatChanged(@NotNull CsvRecordFormatForm source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/csv/ui/CsvFormatForm$3", "recordFormatChanged"));
                }
                CsvFormatForm.this.fireFormatChangedEvent();
            }
        };
        this.myHeaderFormatForm.addChangeListener(changeEventPropagator);
        this.myRecordFormatForm.addChangeListener(changeEventPropagator);
        this.myHeaderFormatWithTitlePanel.setVisible(false);
    }

    private void createUIComponents() {
        this.myRecordFormatForm = new CsvRecordFormatForm(this);
        this.myHeaderFormatForm = new CsvRecordFormatForm(this);
        this.myRecordFormatPanel = this.myRecordFormatForm.getMainPanel();
        this.myHeaderFormatPanel = this.myHeaderFormatForm.getMainPanel();
    }

    public void reset(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatForm", "reset"));
        }
        this.myFormat = format;
        this.myResetting = true;
        try {
            this.myFormatName = format.name;
            this.myRecordFormatForm.reset(format.dataRecord);
            this.setHeaderFormat(format.headerRecord);
            this.myRowNumbersCheckBox.setSelected(format.rowNumbers);
        }
        finally {
            this.myResetting = false;
            this.fireFormatChangedEvent();
        }
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvRecordFormat dataFormat = this.myRecordFormatForm.getFormat();
        CsvRecordFormat headerFormat = this.myHeaderFormatCheckBox.isSelected() ? this.myHeaderFormatForm.getFormat() : null;
        CsvFormat csvFormat = new CsvFormat(this.myFormatName, dataFormat, headerFormat, this.myFormat.id, this.myRowNumbersCheckBox.isSelected());
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatForm", "getFormat"));
        }
        return csvFormat;
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/csv/ui/CsvFormatForm", "addChangeListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void addChangeListener(@NotNull ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/csv/ui/CsvFormatForm", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatForm", "addChangeListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener, parent);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatForm", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }

    private void fireFormatChangedEvent() {
        if (!this.myResetting) {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).formatChanged(this);
        }
    }

    private void setHeaderFormat(@Nullable CsvRecordFormat headerFormat) {
        this.myHeaderFormatCheckBox.setSelected(headerFormat != null);
        if (headerFormat != null) {
            this.myHeaderFormatForm.reset(headerFormat);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myRecordFormatPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRowNumbersCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("First column is header");
        jBCheckBox2.setMnemonic('H');
        jBCheckBox2.setDisplayedMnemonicIndex(16);
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeaderFormatCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("First row is header");
        jBCheckBox.setMnemonic('H');
        jBCheckBox.setDisplayedMnemonicIndex(13);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeaderFormatWithTitlePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Header Format");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel5 = this.myHeaderFormatPanel;
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface ChangeListener
    extends EventListener {
        public void formatChanged(@NotNull CsvFormatForm var1);
    }
}

