/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Domain;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitDomain
extends BinaryDomain {
    private final long myUpperBound;

    /*
     * WARNING - void declaration
     */
    public BitDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/BitDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/BitDomain", "<init>"));
        }
        super(name, descriptor, upperBound / 8L, defaultValue, (boolean)narrowable);
        this.myUpperBound = upperBound;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/BitDomain", "narrow"));
        }
        BitDomain bitDomain = this.isNarrowable() && domain instanceof BitDomain ? new BitDomain(this.simpleName(), this.getPoint(), Math.min(((BitDomain)domain).myUpperBound, this.myUpperBound), this.getDefaultValue(), true) : (this.isNarrowable() && domain instanceof BinaryDomain ? new BitDomain(this.simpleName(), this.getPoint(), Math.min(((BinaryDomain)domain).getUpperBound() * 8L, this.getUpperBound()), this.getDefaultValue(), true) : this);
        if (bitDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BitDomain", "narrow"));
        }
        return bitDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/BitDomain", "narrow"));
        }
        BitDomain bitDomain = this.isNarrowable() ? new BitDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.myUpperBound), this.getDefaultValue(), true) : this;
        if (bitDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BitDomain", "narrow"));
        }
        return bitDomain;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/BitDomain", "trim"));
        }
        return o instanceof byte[] ? (Object)Arrays.copyOf((byte[])o, (int)Math.min(this.getUpperBound(), (long)((byte[])o).length)) : o;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.isNarrowable() && this.myUpperBound > 0L && this.myUpperBound != this.getDefaultValue() ? this.simpleName() + "(" + this.myUpperBound + ")" : this.simpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BitDomain", "name"));
        }
        return string;
    }
}

