/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DataSourceManagerImpl", storages={@Storage(value="dataSources.xml")})
public class DataSourceManagerImpl
extends DataSourceManagerEx
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final DataSourceStorage myStorage;

    public DataSourceManagerImpl(Project project) {
        this.myProject = project;
        this.myStorage = new DataSourceStorage(DataSourceStorage.getStorage());
        Disposer.register((Disposable)project, (Disposable)this.myStorage);
        this.addDataSourceListener(this.myStorage.createSavingListener(this.myProject));
    }

    public List<LocalDataSource> getDataSources() {
        return this.myStorage.getDataSources();
    }

    @Override
    public void addDataSource(LocalDataSource dataSource) {
        this.myStorage.addDataSource(dataSource);
        DatabaseCredentials.getInstance().persistCredentials((DatabaseSystem)dataSource);
    }

    @Nullable
    public LocalDataSource getDataSourceByName(String name) {
        return this.myStorage.getDataSourceByName(name);
    }

    @Override
    public void removeDataSource(LocalDataSource dataSource) {
        this.myStorage.removeDataSource(dataSource);
    }

    @Override
    public void addDataSourceListener(DataSourceListener listener) {
        this.myStorage.addDataSourceListener(listener);
    }

    @Override
    public void addDataSourceListener(DataSourceListener listener, Disposable parent) {
        this.myStorage.addDataSourceListener(listener, parent);
    }

    @Override
    public void removeDataSourceListener(DataSourceListener listener) {
        this.myStorage.removeDataSourceListener(listener);
    }

    public void doWhenInitialized(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceManagerImpl", "doWhenInitialized"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceManagerImpl", "lambda$doWhenInitialized$0"));
            }
            this.myStorage.doWhenInitialized(runnable);
        });
    }

    @Override
    public void updateDataSource(LocalDataSource dataSource) {
        this.myStorage.updateDataSource(dataSource);
    }

    public long getModificationCount() {
        return this.myStorage.getModificationCount();
    }

    public DataSourceStorage getStorage() {
        return this.myStorage;
    }

    public Element getState() {
        Element element = new Element("DataSourceManagerImpl");
        this.myStorage.writeState(this.myProject, element);
        return element;
    }

    public void loadState(Element state) {
        this.myStorage.readState(this.myProject, state);
    }
}

